/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_database_info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_DATABASE_INFO_BASE_HPP
#define OBJECTS_BLAST_BLAST4_DATABASE_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/blast/Blast4_seqtech.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast4_database;
class CBlast4_parameters;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4_database_info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_database_info_Base(void);
    // destructor
    virtual ~CBlast4_database_info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CBlast4_database TDatabase;
    typedef string TDescription;
    typedef string TLast_updated;
    typedef Int8 TTotal_length;
    typedef Int8 TNum_sequences;
    typedef int TSeqtech;
    typedef int TTaxid;
    typedef CBlast4_parameters TExtended;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_database,
        e_description,
        e_last_updated,
        e_total_length,
        e_num_sequences,
        e_seqtech,
        e_taxid,
        e_extended
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CBlast4_database TDatabase
    ///  Check whether the Database data member has been assigned a value.
    bool IsSetDatabase(void) const;
    /// Check whether it is safe or not to call GetDatabase method.
    bool CanGetDatabase(void) const;
    void ResetDatabase(void);
    const TDatabase& GetDatabase(void) const;
    void SetDatabase(TDatabase& value);
    TDatabase& SetDatabase(void);

    /// mandatory
    /// typedef string TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(const TDescription& value);
    void SetDescription(TDescription&& value);
    TDescription& SetDescription(void);

    /// mandatory
    /// typedef string TLast_updated
    ///  Check whether the Last_updated data member has been assigned a value.
    bool IsSetLast_updated(void) const;
    /// Check whether it is safe or not to call GetLast_updated method.
    bool CanGetLast_updated(void) const;
    void ResetLast_updated(void);
    const TLast_updated& GetLast_updated(void) const;
    void SetLast_updated(const TLast_updated& value);
    void SetLast_updated(TLast_updated&& value);
    TLast_updated& SetLast_updated(void);

    /// mandatory
    /// typedef Int8 TTotal_length
    ///  Check whether the Total_length data member has been assigned a value.
    bool IsSetTotal_length(void) const;
    /// Check whether it is safe or not to call GetTotal_length method.
    bool CanGetTotal_length(void) const;
    void ResetTotal_length(void);
    TTotal_length GetTotal_length(void) const;
    void SetTotal_length(TTotal_length value);
    TTotal_length& SetTotal_length(void);

    /// mandatory
    /// typedef Int8 TNum_sequences
    ///  Check whether the Num_sequences data member has been assigned a value.
    bool IsSetNum_sequences(void) const;
    /// Check whether it is safe or not to call GetNum_sequences method.
    bool CanGetNum_sequences(void) const;
    void ResetNum_sequences(void);
    TNum_sequences GetNum_sequences(void) const;
    void SetNum_sequences(TNum_sequences value);
    TNum_sequences& SetNum_sequences(void);

    /// mandatory
    /// typedef int TSeqtech
    ///  Check whether the Seqtech data member has been assigned a value.
    bool IsSetSeqtech(void) const;
    /// Check whether it is safe or not to call GetSeqtech method.
    bool CanGetSeqtech(void) const;
    void ResetSeqtech(void);
    TSeqtech GetSeqtech(void) const;
    void SetSeqtech(TSeqtech value);
    TSeqtech& SetSeqtech(void);

    /// mandatory
    /// typedef int TTaxid
    ///  Check whether the Taxid data member has been assigned a value.
    bool IsSetTaxid(void) const;
    /// Check whether it is safe or not to call GetTaxid method.
    bool CanGetTaxid(void) const;
    void ResetTaxid(void);
    TTaxid GetTaxid(void) const;
    void SetTaxid(TTaxid value);
    TTaxid& SetTaxid(void);

    /// optional
    /// typedef CBlast4_parameters TExtended
    ///  Check whether the Extended data member has been assigned a value.
    bool IsSetExtended(void) const;
    /// Check whether it is safe or not to call GetExtended method.
    bool CanGetExtended(void) const;
    void ResetExtended(void);
    const TExtended& GetExtended(void) const;
    void SetExtended(TExtended& value);
    TExtended& SetExtended(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_database_info_Base(const CBlast4_database_info_Base&);
    CBlast4_database_info_Base& operator=(const CBlast4_database_info_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TDatabase > m_Database;
    string m_Description;
    string m_Last_updated;
    Int8 m_Total_length;
    Int8 m_Num_sequences;
    int m_Seqtech;
    int m_Taxid;
    CRef< TExtended > m_Extended;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_database_info_Base::IsSetDatabase(void) const
{
    return m_Database.NotEmpty();
}

inline
bool CBlast4_database_info_Base::CanGetDatabase(void) const
{
    return true;
}

inline
const CBlast4_database_info_Base::TDatabase& CBlast4_database_info_Base::GetDatabase(void) const
{
    if ( !m_Database ) {
        const_cast<CBlast4_database_info_Base*>(this)->ResetDatabase();
    }
    return (*m_Database);
}

inline
CBlast4_database_info_Base::TDatabase& CBlast4_database_info_Base::SetDatabase(void)
{
    if ( !m_Database ) {
        ResetDatabase();
    }
    return (*m_Database);
}

inline
bool CBlast4_database_info_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_database_info_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CBlast4_database_info_Base::TDescription& CBlast4_database_info_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(1);
    }
    return m_Description;
}

inline
void CBlast4_database_info_Base::SetDescription(const CBlast4_database_info_Base::TDescription& value)
{
    m_Description = value;
    m_set_State[0] |= 0xc;
}

inline
void CBlast4_database_info_Base::SetDescription(CBlast4_database_info_Base::TDescription&& value)
{
    m_Description = std::forward<CBlast4_database_info_Base::TDescription>(value);
    m_set_State[0] |= 0xc;
}

inline
CBlast4_database_info_Base::TDescription& CBlast4_database_info_Base::SetDescription(void)
{
#ifdef _DEBUG
    if (!IsSetDescription()) {
        m_Description = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Description;
}

inline
bool CBlast4_database_info_Base::IsSetLast_updated(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBlast4_database_info_Base::CanGetLast_updated(void) const
{
    return IsSetLast_updated();
}

inline
const CBlast4_database_info_Base::TLast_updated& CBlast4_database_info_Base::GetLast_updated(void) const
{
    if (!CanGetLast_updated()) {
        ThrowUnassigned(2);
    }
    return m_Last_updated;
}

inline
void CBlast4_database_info_Base::SetLast_updated(const CBlast4_database_info_Base::TLast_updated& value)
{
    m_Last_updated = value;
    m_set_State[0] |= 0x30;
}

inline
void CBlast4_database_info_Base::SetLast_updated(CBlast4_database_info_Base::TLast_updated&& value)
{
    m_Last_updated = std::forward<CBlast4_database_info_Base::TLast_updated>(value);
    m_set_State[0] |= 0x30;
}

inline
CBlast4_database_info_Base::TLast_updated& CBlast4_database_info_Base::SetLast_updated(void)
{
#ifdef _DEBUG
    if (!IsSetLast_updated()) {
        m_Last_updated = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Last_updated;
}

inline
bool CBlast4_database_info_Base::IsSetTotal_length(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBlast4_database_info_Base::CanGetTotal_length(void) const
{
    return IsSetTotal_length();
}

inline
void CBlast4_database_info_Base::ResetTotal_length(void)
{
    m_Total_length = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CBlast4_database_info_Base::TTotal_length CBlast4_database_info_Base::GetTotal_length(void) const
{
    if (!CanGetTotal_length()) {
        ThrowUnassigned(3);
    }
    return m_Total_length;
}

inline
void CBlast4_database_info_Base::SetTotal_length(CBlast4_database_info_Base::TTotal_length value)
{
    m_Total_length = value;
    m_set_State[0] |= 0xc0;
}

inline
CBlast4_database_info_Base::TTotal_length& CBlast4_database_info_Base::SetTotal_length(void)
{
#ifdef _DEBUG
    if (!IsSetTotal_length()) {
        memset(&m_Total_length,UnassignedByte(),sizeof(m_Total_length));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Total_length;
}

inline
bool CBlast4_database_info_Base::IsSetNum_sequences(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CBlast4_database_info_Base::CanGetNum_sequences(void) const
{
    return IsSetNum_sequences();
}

inline
void CBlast4_database_info_Base::ResetNum_sequences(void)
{
    m_Num_sequences = 0;
    m_set_State[0] &= ~0x300;
}

inline
CBlast4_database_info_Base::TNum_sequences CBlast4_database_info_Base::GetNum_sequences(void) const
{
    if (!CanGetNum_sequences()) {
        ThrowUnassigned(4);
    }
    return m_Num_sequences;
}

inline
void CBlast4_database_info_Base::SetNum_sequences(CBlast4_database_info_Base::TNum_sequences value)
{
    m_Num_sequences = value;
    m_set_State[0] |= 0x300;
}

inline
CBlast4_database_info_Base::TNum_sequences& CBlast4_database_info_Base::SetNum_sequences(void)
{
#ifdef _DEBUG
    if (!IsSetNum_sequences()) {
        memset(&m_Num_sequences,UnassignedByte(),sizeof(m_Num_sequences));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Num_sequences;
}

inline
bool CBlast4_database_info_Base::IsSetSeqtech(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CBlast4_database_info_Base::CanGetSeqtech(void) const
{
    return IsSetSeqtech();
}

inline
void CBlast4_database_info_Base::ResetSeqtech(void)
{
    m_Seqtech = (int)(0);
    m_set_State[0] &= ~0xc00;
}

inline
CBlast4_database_info_Base::TSeqtech CBlast4_database_info_Base::GetSeqtech(void) const
{
    if (!CanGetSeqtech()) {
        ThrowUnassigned(5);
    }
    return m_Seqtech;
}

inline
void CBlast4_database_info_Base::SetSeqtech(CBlast4_database_info_Base::TSeqtech value)
{
    m_Seqtech = value;
    m_set_State[0] |= 0xc00;
}

inline
CBlast4_database_info_Base::TSeqtech& CBlast4_database_info_Base::SetSeqtech(void)
{
#ifdef _DEBUG
    if (!IsSetSeqtech()) {
        memset(&m_Seqtech,UnassignedByte(),sizeof(m_Seqtech));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Seqtech;
}

inline
bool CBlast4_database_info_Base::IsSetTaxid(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CBlast4_database_info_Base::CanGetTaxid(void) const
{
    return IsSetTaxid();
}

inline
void CBlast4_database_info_Base::ResetTaxid(void)
{
    m_Taxid = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CBlast4_database_info_Base::TTaxid CBlast4_database_info_Base::GetTaxid(void) const
{
    if (!CanGetTaxid()) {
        ThrowUnassigned(6);
    }
    return m_Taxid;
}

inline
void CBlast4_database_info_Base::SetTaxid(CBlast4_database_info_Base::TTaxid value)
{
    m_Taxid = value;
    m_set_State[0] |= 0x3000;
}

inline
CBlast4_database_info_Base::TTaxid& CBlast4_database_info_Base::SetTaxid(void)
{
#ifdef _DEBUG
    if (!IsSetTaxid()) {
        memset(&m_Taxid,UnassignedByte(),sizeof(m_Taxid));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Taxid;
}

inline
bool CBlast4_database_info_Base::IsSetExtended(void) const
{
    return m_Extended.NotEmpty();
}

inline
bool CBlast4_database_info_Base::CanGetExtended(void) const
{
    return IsSetExtended();
}

inline
const CBlast4_database_info_Base::TExtended& CBlast4_database_info_Base::GetExtended(void) const
{
    if (!CanGetExtended()) {
        ThrowUnassigned(7);
    }
    return (*m_Extended);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_DATABASE_INFO_BASE_HPP
