/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Link_set_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'access.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ACCESS_LINK_SET_BASE_HPP
#define OBJECTS_ACCESS_LINK_SET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// links between same class = neighbors
/// links between other classes = links
class NCBI_ACCESS_EXPORT CLink_set_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CLink_set_Base(void);
    // destructor
    virtual ~CLink_set_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TNum;
    typedef list< int > TUids;
    typedef list< int > TWeights;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_num,
        e_uids,
        e_weights
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// number of links to this doc type
    /// mandatory
    /// typedef int TNum
    ///  Check whether the Num data member has been assigned a value.
    bool IsSetNum(void) const;
    /// Check whether it is safe or not to call GetNum method.
    bool CanGetNum(void) const;
    void ResetNum(void);
    TNum GetNum(void) const;
    void SetNum(TNum value);
    TNum& SetNum(void);

    /// the links
    /// optional
    /// typedef list< int > TUids
    ///  Check whether the Uids data member has been assigned a value.
    bool IsSetUids(void) const;
    /// Check whether it is safe or not to call GetUids method.
    bool CanGetUids(void) const;
    void ResetUids(void);
    const TUids& GetUids(void) const;
    TUids& SetUids(void);

    /// the weights
    /// optional
    /// typedef list< int > TWeights
    ///  Check whether the Weights data member has been assigned a value.
    bool IsSetWeights(void) const;
    /// Check whether it is safe or not to call GetWeights method.
    bool CanGetWeights(void) const;
    void ResetWeights(void);
    const TWeights& GetWeights(void) const;
    TWeights& SetWeights(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CLink_set_Base(const CLink_set_Base&);
    CLink_set_Base& operator=(const CLink_set_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Num;
    list< int > m_Uids;
    list< int > m_Weights;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CLink_set_Base::IsSetNum(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CLink_set_Base::CanGetNum(void) const
{
    return IsSetNum();
}

inline
void CLink_set_Base::ResetNum(void)
{
    m_Num = 0;
    m_set_State[0] &= ~0x3;
}

inline
CLink_set_Base::TNum CLink_set_Base::GetNum(void) const
{
    if (!CanGetNum()) {
        ThrowUnassigned(0);
    }
    return m_Num;
}

inline
void CLink_set_Base::SetNum(CLink_set_Base::TNum value)
{
    m_Num = value;
    m_set_State[0] |= 0x3;
}

inline
CLink_set_Base::TNum& CLink_set_Base::SetNum(void)
{
#ifdef _DEBUG
    if (!IsSetNum()) {
        memset(&m_Num,UnassignedByte(),sizeof(m_Num));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Num;
}

inline
bool CLink_set_Base::IsSetUids(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CLink_set_Base::CanGetUids(void) const
{
    return true;
}

inline
const CLink_set_Base::TUids& CLink_set_Base::GetUids(void) const
{
    return m_Uids;
}

inline
CLink_set_Base::TUids& CLink_set_Base::SetUids(void)
{
    m_set_State[0] |= 0x4;
    return m_Uids;
}

inline
bool CLink_set_Base::IsSetWeights(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CLink_set_Base::CanGetWeights(void) const
{
    return true;
}

inline
const CLink_set_Base::TWeights& CLink_set_Base::GetWeights(void) const
{
    return m_Weights;
}

inline
CLink_set_Base::TWeights& CLink_set_Base::SetWeights(void)
{
    m_set_State[0] |= 0x10;
    return m_Weights;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ACCESS_LINK_SET_BASE_HPP
