#!/bin/sh

# Copyright (C) 2019-2024 Internet Systems Consortium, Inc. ("ISC")
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# Exit with error if commands exit with non-zero and if undefined variables are
# used.
set -eu

# shellcheck disable=SC2034
# SC2034: ... appears unused. Verify use (or export if used externally).
prefix="/usr/pkg"

# Include utilities based on location of this script. Check for sources first,
# so that the unexpected situations with weird paths fall on the default
# case of installed.
script_path=$(cd "$(dirname "${0}")" && pwd)
if test "${script_path}" = "/tmp/pkgbuild/net/kea/work.aarch64eb/kea-2.6.3/src/share/database/scripts/mysql"; then
    # shellcheck source=./src/bin/admin/admin-utils.sh.in
    . "/tmp/pkgbuild/net/kea/work.aarch64eb/kea-2.6.3/src/bin/admin/admin-utils.sh"
else
    # shellcheck source=./src/bin/admin/admin-utils.sh.in
    . "${prefix}/share/kea/scripts/admin-utils.sh"
fi

VERSION=$(mysql_version "$@")

if [ "$VERSION" != "8.2" ]; then
    printf 'This script upgrades 8.2 to 9.0. '
    printf 'Reported version is %s. Skipping upgrade.\n' "${VERSION}"
    exit 0
fi

mysql "$@" <<EOF
-- This line starts the schema upgrade to version 9.0.

# Create hostname index for host reservations
CREATE INDEX hosts_by_hostname ON hosts (hostname);

# Move to lower case hostnames in lease4 table.
UPDATE lease4 SET hostname = LOWER(hostname)
WHERE BINARY LOWER(hostname) != hostname;

# Move to lower case hostnames in lease6 table.
UPDATE lease6 SET hostname = LOWER(hostname)
WHERE BINARY LOWER(hostname) != hostname;

# Create hostname index for lease4
CREATE INDEX lease4_by_hostname ON lease4 (hostname);

# Create hostname index for lease6
CREATE INDEX lease6_by_hostname ON lease6 (hostname);

# Update the schema version number.
UPDATE schema_version
    SET version = '9', minor = '0';

# This line concludes the schema upgrade to version 9.0.

EOF
