#                                                     -*- Makefile -*-
# Copyright (c) 1999, 2000  Motoyuki Kasahara
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#
# :  Makefile ҤϡGNU make Ǥʤޤ
#

######################################################################
# ѿ
######################################################################

# Bourne ߴ
SHELL = /bin/sh

# Makefile ǵư륹ץȷ֤Ƥǥ쥯ȥ
ifndef FPWLIBEXECDIR
FPWLIBEXECDIR = /usr/pkg/libexec/freepwing
endif

# ȥե񤭹ǥ쥯ȥ
ifndef WORKDIR
WORKDIR = work
endif

# perl ޥ
ifndef PERL
PERL = ${FPWLIBEXECDIR}/perl.sh
endif

# perl ޥɤϤ *.pm եθץ
ifndef PERLINCFLAGS
PERLINCFLAGS = 
endif

# perl ޥɤϤ
ifndef PERLFLAGS
PERLFLAGS = 
endif

# fpwhalfchar ޥ
ifndef FPWHALFCHAR
FPWHALFCHAR = ${FPWLIBEXECDIR}/fpwhalfchar
endif

# fpwhalfchar ޥɤϤե
ifndef HALFCHARS
HALFCHARS = 
endif

# fpwfullchar ޥ
ifndef FPWFULLCHAR
FPWFULLCHAR = ${FPWLIBEXECDIR}/fpwfullchar
endif

# fpwhalfchar ޥɤϤե
ifndef FULLCHARS
FULLCHARS = 
endif

# fpwcgraph ޥ
ifndef FPWCGRAPH
FPWCGRAPH = ${FPWLIBEXECDIR}/fpwcgraph
endif

# fpwcgraph ޥɤϤ顼ǥե
ifndef CGRAPHS
CGRAPHS = 
endif

# fpwsound ޥ
ifndef FPWSOUND
FPWSOUND = ${FPWLIBEXECDIR}/fpwsound
endif

# fpwsound ޥɤϤ顼ǥե
ifndef SOUNDS
SOUNDS = 
endif

# ѡޥ
# (̾桼¦ Makefile Ǿ񤭤롣)
ifndef FPWPARSER
FPWPARSER = ${FPWLIBEXECDIR}/fpwparser
endif

# ѡޥɤϤ
# (̾桼¦ Makefile Ǿ񤭤롣)
ifndef FPWPARSERFLAGS
FPWPARSERFLAGS = 
endif

# fpwsort ֥ޥ
ifndef FPWSORT
FPWSORT = ${FPWLIBEXECDIR}/fpwsort
endif

# fpwindex ֥ޥ
ifndef FPWINDEX
FPWINDEX = ${FPWLIBEXECDIR}/fpwindex
endif

# fpwcontrol ֥ޥ
ifndef FPWCONTROL
FPWCONTROL = ${FPWLIBEXECDIR}/fpwcontrol
endif

# fpwlink ֥ޥ
ifndef FPWLINK
FPWLINK = ${FPWLIBEXECDIR}/fpwlink
endif

# mkdirhier ޥ
ifndef MKDIRHIER
MKDIRHIER = ${FPWLIBEXECDIR}/mkdirhier
endif

# cphier ޥ
ifndef CPHIER
CPHIER = ${FPWLIBEXECDIR}/cphier
endif

# make οʹԤϿե뷲
ifndef USERCHAR_DEP
USERCHAR_DEP = ${WORKDIR}/userchar.dep
endif
ifndef CGRAPH_DEP
CGRAPH_DEP = ${WORKDIR}/cgraph.dep
endif
ifndef SOUND_DEP
SOUND_DEP = ${WORKDIR}/sound.dep
endif
ifndef PARSE_DEP
PARSE_DEP = ${WORKDIR}/parse.dep
endif
ifndef SORT_DEP
SORT_DEP = ${WORKDIR}/sort.dep
endif
ifndef INDEX_DEP
INDEX_DEP = ${WORKDIR}/index.dep
endif
ifndef CONTROL_DEP
CONTROL_DEP = ${WORKDIR}/control.dep
endif
ifndef LINK_DEP
LINK_DEP = ${WORKDIR}/link.dep
endif

# gzip ޥ
ifndef GZIPCMD
GZIPCMD = gzip
endif

# zip ޥ
ifndef ZIP
ZIP = zip
endif

# bzip2 ޥ
ifndef BZIP2
BZIP2 = bzip2
endif

# catdump ޥ
ifndef CATDUMP
CATDUMP = ${FPWLIBEXECDIR}/catdump
endif

# catdump ޥɤϤ
ifndef CATDUMPFLAGS
CATDUMPFLAGS = 
endif

# ϥǡե뷲
# (̾桼¦ Makefile ꤵ롣)
ifndef SOURCES
SOURCES = 
endif

# honmon  (fpwmake all) ˡ¸ե
# (̾桼¦ Makefile ꤵ롣)
ifndef ALLDEPS
ALLDEPS = 
endif

# ѥå̾
# (̾桼¦ Makefile ꤵ롣)
ifndef PACKAGE
PACKAGE = package
endif

# ҤΥǥ쥯ȥ̾
# (̾桼¦ Makefile ꤵ롣)
ifndef DIR
DIR = subdir
endif

# Хʥѥåźդե
# (̾桼¦ Makefile ꤵ롣)
ifndef PACKAGEEXTRA
PACKAGEEXTRA = 
endif

# Хʥѥå (fpwmake package) ˡ¸ե
# (̾桼¦ Makefile ꤵ롣)
ifndef PACKAGEDEPS
PACKAGEDEPS = 
endif

# ֤źդե
# (̾桼¦ Makefile ꤵ롣)
ifndef ARCHIVEEXTRA
ARCHIVEEXTRA = 
endif

# clean ¹Ի˰˺ե
# (̾桼¦ Makefile ꤵ롣)
ifndef CLEANEXTRA
CLEANEXTRA = 
endif

# 󥹥ȡΥǥ쥯ȥ
ifndef INSTALLDIR
INSTALLDIR = /usr/pkg/share/dict
endif

######################################################################
# 롼
######################################################################

#
# all (ǥեȥå)
#	 
.PHONY: all 
all: ${ALLDEPS} link

#
# κ
#
.PHONY: userchar userchar-recursive 

ifneq ($(strip ${SUBDIRS}),)
userchar: userchar-recursive
else
userchar: ${USERCHAR_DEP}
endif

userchar-recursive:
	for subdir in ${SUBDIRS} ; do \
	   ${MAKE} -C $$subdir userchar ; \
	done

${USERCHAR_DEP}: ${HALFCHARS} ${FULLCHARS}
	@rm -f ${USERCHAR_DEP}
	test -d ${WORKDIR} || ${MKDIRHIER} ${WORKDIR}
	${PERL} ${PERLINCFLAGS} ${PERLFLAGS} ${FPWHALFCHAR} \
	   -workdir ${WORKDIR} ${HALFCHARS}
	${PERL} ${PERLINCFLAGS} ${PERLFLAGS} ${FPWFULLCHAR} \
	   -workdir ${WORKDIR} ${FULLCHARS}
	@echo timestamp > ${USERCHAR_DEP}

#
# 顼Ǥκ
#
.PHONY: cgraph cgraph-recursive 

ifneq ($(strip ${SUBDIRS}),)
cgraph: cgraph-recursive
else
cgraph: ${CGRAPH_DEP}
endif

cgraph-recursive:
	for subdir in ${SUBDIRS} ; do \
	   ${MAKE} -C $$subdir cgraph ; \
	done

${CGRAPH_DEP}: ${CGRAPHS}
	@rm -f ${CGRAPH_DEP}
ifneq ($(strip ${CGRAPHS}),)
	test -d ${WORKDIR} || ${MKDIRHIER} ${WORKDIR}
	${PERL} ${PERLINCFLAGS} ${PERLFLAGS} ${FPWCGRAPH} \
	   -workdir ${WORKDIR} ${CGRAPHS}
endif
	@echo timestamp > ${CGRAPH_DEP}

#
# ǡκ
#
.PHONY: sound sound-recursive 

ifneq ($(strip ${SUBDIRS}),)
sound: sound-recursive
else
sound: ${SOUND_DEP}
endif

sound-recursive:
	for subdir in ${SUBDIRS} ; do \
	   ${MAKE} -C $$subdir sound ; \
	done

${SOUND_DEP}: ${SOUNDS}
	@rm -f ${SOUND_DEP}
ifneq ($(strip ${SOUNDS}),)
	test -d ${WORKDIR} || ${MKDIRHIER} ${WORKDIR}
	${PERL} ${PERLINCFLAGS} ${PERLFLAGS} ${FPWSOUND} \
	   -workdir ${WORKDIR} ${SOUNDS}
endif
	@echo timestamp > ${SOUND_DEP}

#
# 桼Ѱդϥץμ¹
#
.PHONY: parse parse-recursive

ifneq ($(strip ${SUBDIRS}),)
parse: parse-recursive
else
parse: ${PARSE_DEP}
endif

parse-recursive:
	for subdir in ${SUBDIRS} ; do \
	   ${MAKE} -C $$subdir parse ; \
	done

${PARSE_DEP}: ${USERCHAR_DEP} ${CGRAPH_DEP} ${SOUND_DEP} ${SOURCES}
	@rm -f ${PARSE_DEP}
	${PERL} ${PERLINCFLAGS} ${PERLFLAGS} ${FPWPARSER} \
	   -workdir ${WORKDIR} ${FPWPARSERFLAGS}
	@echo timestamp > ${PARSE_DEP}

#
# ñΥ
#
.PHONY: sort sort-recursive

ifneq ($(strip ${SUBDIRS}),)
sort: sort-recursive
else
sort: ${SORT_DEP}
endif

sort-recursive:
	for subdir in ${SUBDIRS} ; do \
	   ${MAKE} -C $$subdir sort ; \
	done

${SORT_DEP}: ${PARSE_DEP}
	@rm -f ${SORT_DEP}
	${PERL} ${PERLINCFLAGS} ${PERLFLAGS} ${FPWSORT} -workdir ${WORKDIR} 
	@echo timestamp > ${SORT_DEP}

#
# ǥåκ
#
.PHONY: index index-recursive

ifneq ($(strip ${SUBDIRS}),)
index: index-recursive
else
index: ${INDEX_DEP}
endif

index-recursive:
	for subdir in ${SUBDIRS} ; do \
	   ${MAKE} -C $$subdir index ; \
	done

${INDEX_DEP}: ${SORT_DEP}
	@rm -f ${INDEX_DEP}
	${PERL} ${PERLINCFLAGS} ${PERLFLAGS} ${FPWINDEX} -workdir ${WORKDIR} 
	@echo timestamp > ${INDEX_DEP}

#
# Ҵκ
#
.PHONY: control control-recursive

ifneq ($(strip ${SUBDIRS}),)
control: control-recursive
else
control: ${CONTROL_DEP}
endif

control-recursive:
	for subdir in ${SUBDIRS} ; do \
	   ${MAKE} -C $$subdir control ; \
	done

${CONTROL_DEP}: ${INDEX_DEP}
	@rm -f ${CONTROL_DEP}
	${PERL} ${PERLINCFLAGS} ${PERLFLAGS} ${FPWCONTROL} -workdir ${WORKDIR}
	@echo timestamp > ${CONTROL_DEP}

#
# ƥǡ礷 honmon κ
#
.PHONY: link link-recursive

ifneq ($(strip ${SUBDIRS}),)
link: link-recursive
else
link: ${LINK_DEP}
endif

link-recursive:
	for subdir in ${SUBDIRS} ; do \
	   ${MAKE} -C $$subdir link ; \
	done

${LINK_DEP}: ${CONTROL_DEP}
	@rm -f ${LINK_DEP}
	${PERL} ${PERLINCFLAGS} ${PERLFLAGS} ${FPWLINK} -workdir ${WORKDIR}
	@echo timestamp > ${LINK_DEP}

#
# catalogs κ
#
ifneq ($(strip ${SUBDIRS}),)
catalogs.txt: $(addsuffix /catalogs.txt,${SUBDIRS})
	rm -f $@
	echo "[Catalog]" > $@
	echo "FileName	= catalogs" >> $@
	echo "Type		= EPWING1" >> $@
	${PERL} -e 'printf "Books\t\t= %d\n", scalar(@ARGV)' ${SUBDIRS} >> $@
	for subdir in ${SUBDIRS} ; do \
	   echo "[Book]" >> $@ ; \
	   sed -n -e '/^Title[ 	]*=/p' ${SUBDIRS}/$@ >> $@ ; \
	   sed -n -e '/^BookType[ 	]*=/p' ${SUBDIRS}/$@ >> $@ ; \
	   echo "Directory	= \"$$subdir\"" >> $@ ; \
	done
endif

catalogs: catalogs.txt
	rm -f $@
	${CATDUMP} ${CATDUMPFLAGS} -u catalogs.txt $@

#
# եκ
#
.PHONY: clean clean-recursive clean-directory

ifneq ($(strip ${SUBDIRS}),)
clean: clean-recursive clean-directory
else
clean: clean-directory
endif

clean-recursive:
	for subdir in ${SUBDIRS} ; do \
	   ${MAKE} -C $$subdir clean ; \
	done
	rm -f catalogs.txt

clean-directory:
	rm -rf ${WORKDIR}
	rm -rf ${PACKAGE}
	rm -f catalogs honmon ${CLEANEXTRA}
	rm -f ${PACKAGE}.zip ${PACKAGE}.tar.gz ${PACKAGE}.tar.bz2
	rm -f ${PACKAGE}-src.tar.gz

#
# ѥåκ (*.zip )
#
package package-zip:
	rm -rf ${DIR}
	rm -f ${PACKAGE}.zip
	${MAKE} INSTALLDIR="." DIR="${DIR}" install
	chmod 777 ${DIR}
ifneq ($(strip ${SUBDIRS}),)
	for subdir in ${SUBDIRS} ; do \
	   chmod 777 ${DIR}/$${subdir}/data ; \
	done
else
	chmod 777 ${DIR}/${DIR}/data
endif
	${ZIP} -9rkq ${PACKAGE}.zip ${DIR}
	rm -rf ${DIR}

#
# ѥåκ (*.tar.gz )
#
.PHONY: package package-zip package-tar-gz package-tar-bz2

package-tar-gz:
	rm -rf ${DIR}
	rm -f ${PACKAGE}.tar.gz
	${MAKE} INSTALLDIR="." DIR="${DIR}" install
	chmod 777 ${DIR}
ifneq ($(strip ${SUBDIRS}),)
	for subdir in ${SUBDIRS} ; do \
	   chmod 777 ${DIR}/$${subdir}/data ; \
	done
else
	chmod 777 ${DIR}/${DIR}/data
endif
	tar cf - ${DIR} | ${GZIPCMD} -9 > ${PACKAGE}.tar.gz
	rm -rf ${DIR}

#
# ѥåκ (*.tar.bz2 )
#
package-tar-bz2:
	rm -rf ${DIR}
	rm -f ${PACKAGE}.tar.bz2
	${MAKE} INSTALLDIR="." DIR="${DIR}" install
	chmod 777 ${DIR}
ifneq ($(strip ${SUBDIRS}),)
	for subdir in ${SUBDIRS} ; do \
	   chmod 777 ${DIR}/$${subdir}/data ; \
	done
else
	chmod 777 ${DIR}/${DIR}/data
endif
	tar cf - ${DIR} | ${BZIP2} -9 > ${PACKAGE}.tar.bz2
	rm -rf ${DIR}

#
# 󥹥ȡ
#
.PHONY: install install-directory

install: all catalogs ${PACKAGEDEPS}
	${MKDIRHIER} ${INSTALLDIR}/${DIR}
	for file in catalogs ; do \
	   ${CPHIER} $$file ${INSTALLDIR}/${DIR}/$$file ; \
	   chmod 0644 ${INSTALLDIR}/${DIR}/$$file ; \
	done
ifneq ($(strip ${SUBDIRS}),)
	for subdir in ${SUBDIRS} ; do \
	   case ${INSTALLDIR} in \
	   /*) ${MAKE} -C $$subdir \
	       INSTALLDIR="${INSTALLDIR}/${DIR}/$$subdir" \
	       install-directory ;; \
	   *)  ${MAKE} -C $$subdir \
	       INSTALLDIR="../${INSTALLDIR}/${DIR}/$$subdir" \
	       install-directory ;; \
	   esac ; \
	done
else
	${MAKE} INSTALLDIR="${INSTALLDIR}/${DIR}/${DIR}" install-directory
endif
	packageextra='${PACKAGEEXTRA}' ; \
	for file in $$packageextra ; do \
	   case $$file in \
	   *=*) srcfile="`echo $$file | sed 's/=.*//'`" ; \
	        dstfile="`echo $$file | sed 's/.*=//'`" ; \
	        ${CPHIER} $$srcfile ${INSTALLDIR}/${DIR}/$$dstfile ; \
		if [ -f ${INSTALLDIR}/${DIR}/$$dstfile ] ; then \
	           chmod 0644 ${INSTALLDIR}/${DIR}/$$dstfile ; \
		fi ;; \
	   *)   ${CPHIER} $$file ${INSTALLDIR}/${DIR}/$$file ; \
		if [ -f ${INSTALLDIR}/${DIR}/$$file ] ; then \
	           chmod 0644 ${INSTALLDIR}/${DIR}/$$file ; \
		fi ;; \
	   esac ; \
	done

install-directory:
	${MKDIRHIER} ${INSTALLDIR}/data
	for file in honmon ; do \
	   ${CPHIER} $$file ${INSTALLDIR}/data/$$file ; \
	   chmod 0644 ${INSTALLDIR}/data/$$file ; \
	done
	${MKDIRHIER} ${INSTALLDIR}/gaiji
	for file in gai16h gai24h gai30h gai48h gai16f gai24f gai30f gai48f ; do \
	   if test -f $$file ; then \
	      ${CPHIER} $$file ${INSTALLDIR}/gaiji/$$file ; \
	      chmod 0644 ${INSTALLDIR}/gaiji/$$file ; \
	   fi ; \
	done

#
# ѴץȤΥ֤
#
.PHONY: archive archive-directory

archive:
	rm -rf ${PACKAGE}
	rm -f ${PACKAGE}-src.tar.gz
	${MKDIRHIER} ${PACKAGE}
	chmod 777 ${PACKAGE}
ifneq ($(strip ${SUBDIRS}),)
	for subdir in ${SUBDIRS} ; do \
	   ${MAKE} -C $$subdir ARCHIVEDIR="../${PACKAGE}/$$subdir" \
	      archive-directory ; \
	   chmod 777 ${PACKAGE}/$${subdir} ; \
	done
endif
	${MAKE} ARCHIVEDIR="${PACKAGE}" archive-directory
	tar cf - ${PACKAGE} | ${GZIPCMD} -9 > ${PACKAGE}-src.tar.gz
	rm -rf ${PACKAGE}

archive-directory:
	for file in README Makefile catalogs.txt ${FPWPARSER} \
	   ${CGRAPHS} ${SOUNDS} ${HALFCHARS} ${FULLCHARS} ; do \
	   if test -f $$file ; then \
	      ${CPHIER} $$file ${ARCHIVEDIR}/$$file ; \
	   fi ; \
	done
	archiveextra='${ARCHIVEEXTRA}' ; \
	for file in $$archiveextra ; do \
	   case $$file in \
	   *=*) srcfile="`echo $$file | sed 's/=.*//'`" ; \
	        dstfile="`echo $$file | sed 's/.*=//'`" ; \
	        ${CPHIER} $$srcfile ${ARCHIVEDIR}/$$dstfile ;; \
	   *)   ${CPHIER} $$file ${ARCHIVEDIR}/$$file ;; \
	   esac ; \
	done

.SUFFIXES:

#
# С [3.59, 3.63)  GNU make Фơ٤Ƥѿ export
# ʤ褦˻ؼ롣ʤȡƥ (ʤȤ SysV) 
# ͤۤƤޤ
#
.NOEXPORT:
