/*
 * Decompiled with CFR 0.152.
 */
package com.zabbix.gateway;

import com.zabbix.gateway.InputValidator;
import com.zabbix.gateway.PostInputValidator;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;

class ConfigurationParameter {
    static final int TYPE_INTEGER = 0;
    static final int TYPE_INETADDRESS = 1;
    static final int TYPE_FILE = 2;
    private String name;
    private int type;
    private Object value;
    private InputValidator validator;
    private PostInputValidator postValidator;

    ConfigurationParameter(String string, int n, Object object, InputValidator inputValidator, PostInputValidator postInputValidator) {
        this.name = string;
        this.type = n;
        this.value = object;
        this.validator = inputValidator;
        this.postValidator = postInputValidator;
    }

    String getName() {
        return this.name;
    }

    int getType() {
        return this.type;
    }

    Object getValue() {
        return this.value;
    }

    void setValue(String string) {
        Serializable serializable = null;
        try {
            switch (this.type) {
                case 0: {
                    serializable = Integer.valueOf(string);
                    break;
                }
                case 1: {
                    serializable = InetAddress.getByName(string);
                    break;
                }
                case 2: {
                    serializable = new File(string);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("unknown type %d", this.type));
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        if (null != this.validator && !this.validator.validate(serializable)) {
            throw new IllegalArgumentException(String.format("bad value for %s parameter: '%s'", this.name, string));
        }
        if (null != this.postValidator) {
            this.postValidator.execute(serializable);
        }
        this.value = serializable;
    }
}

