/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xmerge;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openoffice.xmerge.Document;

public class BinaryGraphicsDocument
implements Document {
    private static final int BUFFERSIZE = 1024;
    private String docName;
    private byte[] data;
    private int nOff;
    private int nLen;
    private String sFileExtension;
    private String sMimeType;

    public BinaryGraphicsDocument(String name, String sFileExtension, String sMimeType) {
        this.sFileExtension = sFileExtension;
        this.sMimeType = sMimeType;
        this.docName = this.trimDocumentName(name);
    }

    public void read(InputStream docData) throws IOException {
        if (docData == null) {
            throw new IOException("No input stream to convert");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len = 0;
        byte[] buffer = new byte[1024];
        while ((len = docData.read(buffer)) > 0) {
            baos.write(buffer, 0, len);
        }
        this.data = baos.toByteArray();
    }

    public void read(byte[] data) {
        this.read(data, 0, data.length);
    }

    public void read(byte[] data, int nOff, int nLen) {
        this.data = data;
        this.nOff = nOff;
        this.nLen = nLen;
    }

    private String trimDocumentName(String name) {
        String temp = name.toLowerCase();
        if (temp.endsWith(this.getFileExtension())) {
            int nlen = name.length();
            int endIndex = nlen - this.getFileExtension().length();
            name = name.substring(0, endIndex);
        }
        return name;
    }

    public String getName() {
        return this.docName;
    }

    public String getFileName() {
        return new String(this.docName + this.getFileExtension());
    }

    public void write(OutputStream os) throws IOException {
        os.write(this.data, this.nOff, this.nLen);
    }

    public String getFileExtension() {
        return this.sFileExtension;
    }

    public String getDocumentMIMEType() {
        return this.sMimeType;
    }

    static {
        BUFFERSIZE = 1024;
    }
}

