/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import org.w3c.dom.Node;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.TableGridModel;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Misc;

public class TableFormatter {
    private WriterStyleCollection wsc;
    private boolean bApplyCellFormat;
    private TableGridModel table;
    private boolean[][] bHBorder;
    private boolean[][] bVBorder;
    private boolean[] bGlobalVBorder;
    private String[] sColumnWidth;
    private boolean bIsLongtable;
    private boolean bIsSubtable;

    public TableFormatter(WriterStyleCollection wsc, TableGridModel table, boolean bAllowLongtable, boolean bApplyCellFormat) {
        StyleWithProperties style;
        String sStyleName;
        int nCol;
        this.wsc = wsc;
        this.table = table;
        this.bApplyCellFormat = bApplyCellFormat;
        int nRowCount = table.getRowCount();
        int nColCount = table.getColCount();
        this.bHBorder = new boolean[nRowCount + 1][nColCount];
        int nRow = 0;
        while (nRow <= nRowCount) {
            int nCol2 = 0;
            while (nCol2 < nColCount) {
                this.bHBorder[nRow][nCol2] = false;
                ++nCol2;
            }
            ++nRow;
        }
        this.bVBorder = new boolean[nRowCount][nColCount + 1];
        int nRow2 = 0;
        while (nRow2 < nRowCount) {
            int nCol3 = 0;
            while (nCol3 <= nColCount) {
                this.bVBorder[nRow2][nCol3] = false;
                ++nCol3;
            }
            ++nRow2;
        }
        int nRow3 = 0;
        while (nRow3 < nRowCount) {
            nCol = 0;
            while (nCol < nColCount) {
                Node cell = table.getCell(nRow3, nCol);
                sStyleName = Misc.getAttribute(cell, "table:style-name");
                style = wsc.getCellStyle(sStyleName);
                int nColSpan = Misc.getPosInteger(Misc.getAttribute(cell, "table:number-columns-spanned"), 1);
                boolean bLeft = false;
                boolean bRight = false;
                boolean bTop = false;
                boolean bBottom = false;
                if (style != null) {
                    String sBorder = style.getProperty("fo:border");
                    if (sBorder != null && !"none".equals(sBorder)) {
                        bLeft = true;
                        bRight = true;
                        bTop = true;
                        bBottom = true;
                    }
                    if ((sBorder = style.getProperty("fo:border-left")) != null && !"none".equals(sBorder)) {
                        bLeft = true;
                    }
                    if ((sBorder = style.getProperty("fo:border-right")) != null && !"none".equals(sBorder)) {
                        bRight = true;
                    }
                    if ((sBorder = style.getProperty("fo:border-top")) != null && !"none".equals(sBorder)) {
                        bTop = true;
                    }
                    if ((sBorder = style.getProperty("fo:border-bottom")) != null && !"none".equals(sBorder)) {
                        bBottom = true;
                    }
                }
                boolean[] blArray = this.bVBorder[nRow3];
                int n = nCol;
                blArray[n] = blArray[n] | bLeft;
                boolean[] blArray2 = this.bVBorder[nRow3];
                int n2 = nCol + nColSpan;
                blArray2[n2] = blArray2[n2] | bRight;
                do {
                    boolean[] blArray3 = this.bHBorder[nRow3];
                    int n3 = nCol;
                    blArray3[n3] = blArray3[n3] | bTop;
                    boolean[] blArray4 = this.bHBorder[nRow3 + 1];
                    int n4 = nCol++;
                    blArray4[n4] = blArray4[n4] | bBottom;
                } while (--nColSpan > 0);
            }
            ++nRow3;
        }
        this.bIsSubtable = "table:sub-table".equals(table.getTableNode().getNodeName());
        this.bGlobalVBorder = new boolean[nColCount + 1];
        nCol = 0;
        while (nCol <= nColCount) {
            int nBalance = 0;
            int nRow4 = 0;
            while (nRow4 < nRowCount) {
                nBalance += this.bVBorder[nRow4][nCol] ? 1 : -1;
                ++nRow4;
            }
            this.bGlobalVBorder[nCol] = nBalance > 0;
            ++nCol;
        }
        this.sColumnWidth = new String[nColCount];
        int nCol4 = 0;
        while (nCol4 < nColCount) {
            StyleWithProperties colStyle = wsc.getColumnStyle(table.getCol(nCol4).getStyleName());
            if (colStyle != null) {
                this.sColumnWidth[nCol4] = colStyle.getProperty("style:column-width");
            }
            if (this.sColumnWidth[nCol4] == null) {
                this.sColumnWidth[nCol4] = "2cm";
            }
            ++nCol4;
        }
        sStyleName = Misc.getAttribute(table.getTableNode(), "table:style-name");
        style = wsc.getTableStyle(sStyleName);
        this.bIsLongtable = !this.bIsSubtable && bAllowLongtable && !"false".equals(style.getProperty("style:may-break-between-rows"));
    }

    public boolean isLongtable() {
        return this.bIsLongtable;
    }

    public boolean isSubtable() {
        return this.bIsSubtable;
    }

    public void applyTableStyle(BeforeAfter ba) {
        String s;
        String sStyleName = Misc.getAttribute(this.table.getTableNode(), "table:style-name");
        StyleWithProperties style = this.wsc.getTableStyle(sStyleName);
        int cAlign = 99;
        if (style != null && !this.bIsSubtable) {
            s = style.getProperty("table:align");
            if ("left".equals(s)) {
                cAlign = 108;
            } else if ("right".equals(s)) {
                cAlign = 114;
            }
        }
        if (this.bIsLongtable) {
            ba.add("\\begin{longtable}[" + (char)cAlign + "]", "\\end{longtable}");
        } else if (!this.bIsSubtable) {
            s = "center";
            switch (cAlign) {
                case 99: {
                    s = "center";
                    break;
                }
                case 114: {
                    s = "flushright";
                    break;
                }
                case 108: {
                    s = "flushleft";
                }
            }
            ba.add("\\begin{" + s + "}\\begin{tabular}", "\\end{tabular}\\end{" + s + "}");
        } else {
            ba.add("\\hspace*{-\\tabcolsep}\\begin{tabular}", "\\end{tabular}\\hspace*{-\\tabcolsep}");
        }
        ba.add("{", "");
        if (this.bGlobalVBorder[0]) {
            ba.add("|", "");
        }
        int nColCount = this.table.getColCount();
        int nCol = 0;
        while (nCol < nColCount) {
            ba.add("p{" + Misc.add(this.sColumnWidth[nCol], "-0.2cm") + "}", "");
            if (this.bGlobalVBorder[nCol + 1]) {
                ba.add("|", "");
            }
            ++nCol;
        }
        ba.add("}", "");
    }

    public String getInterrowMaterial(int nRow) {
        int nColCount = this.table.getColCount();
        int nCount = 0;
        int nCol = 0;
        while (nCol < nColCount) {
            if (this.bHBorder[nRow][nCol]) {
                ++nCount;
            }
            ++nCol;
        }
        if (nCount == 0) {
            return "";
        }
        if (nCount == nColCount) {
            return "\\hline";
        }
        StringBuffer buf = new StringBuffer();
        boolean bInCline = false;
        int nCol2 = 0;
        while (nCol2 < nColCount) {
            if (bInCline && !this.bHBorder[nRow][nCol2]) {
                buf.append(nCol2).append("}");
                bInCline = false;
            } else if (!bInCline && this.bHBorder[nRow][nCol2]) {
                buf.append("\\cline{").append(nCol2 + 1).append("-");
                bInCline = true;
            }
            ++nCol2;
        }
        if (bInCline) {
            buf.append(nColCount).append("}");
        }
        return buf.toString();
    }

    public void applyCellStyle(int nRow, int nCol, BeforeAfter ba) {
        Node cell = this.table.getCell(nRow, nCol);
        int nColSpan = Misc.getPosInteger(Misc.getAttribute(cell, "table:number-columns-spanned"), 1);
        boolean bNeedLeft = nCol == 0 && this.bVBorder[nRow][0] != this.bGlobalVBorder[0];
        boolean bNeedRight = this.bVBorder[nRow][nCol + 1] != this.bGlobalVBorder[nCol + 1];
        String sTotalColumnWidth = this.sColumnWidth[nCol];
        int i = nCol + 1;
        while (i < nCol + nColSpan) {
            sTotalColumnWidth = Misc.add(sTotalColumnWidth, this.sColumnWidth[i]);
            ++i;
        }
        sTotalColumnWidth = Misc.add(sTotalColumnWidth, "-0.2cm");
        if (bNeedLeft || bNeedRight || nColSpan > 1) {
            ba.add("\\multicolumn{" + nColSpan + "}{", "");
            if (nCol == 0 && this.bVBorder[nRow][0]) {
                ba.add("|", "");
            }
            ba.add("p{" + sTotalColumnWidth + "}", "");
            if (this.bVBorder[nRow][nCol + nColSpan]) {
                ba.add("|", "");
            }
            ba.add("}{", "}");
        }
        if (this.bApplyCellFormat) {
            StyleWithProperties style = this.wsc.getCellStyle(Misc.getAttribute(cell, "table:style-name"));
            String sValign = "c";
            if (style != null) {
                String s = style.getProperty("fo:vertical-align");
                if ("".equals(s)) {
                    sValign = "b";
                } else if ("top".equals(s)) {
                    sValign = "b";
                } else if ("bottom".equals(s)) {
                    sValign = "t";
                }
            }
            ba.add("\\begin{minipage}[" + sValign + "]{" + sTotalColumnWidth + "}", "\\end{minipage}");
        }
    }
}

