/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import java.util.Enumeration;
import java.util.Hashtable;
import writer2latex.latex.style.StyleMapItem;

public class StyleMap {
    private Hashtable items = new Hashtable();

    public void put(String sName, String sBefore, String sAfter, boolean bLineBreak, boolean bVerbatim) {
        StyleMapItem item = new StyleMapItem();
        item.sBefore = sBefore;
        item.sAfter = sAfter;
        item.sNext = ";;";
        item.bLineBreak = bLineBreak;
        item.bVerbatim = bVerbatim;
        this.items.put(sName, item);
    }

    public void put(String sName, String sBefore, String sAfter, String sNext) {
        StyleMapItem item = new StyleMapItem();
        item.sBefore = sBefore;
        item.sAfter = sAfter;
        item.sNext = ";" + sNext + ";";
        item.bLineBreak = true;
        item.bVerbatim = false;
        this.items.put(sName, item);
    }

    public void put(String sName, String sBefore, String sAfter) {
        StyleMapItem item = new StyleMapItem();
        item.sBefore = sBefore;
        item.sAfter = sAfter;
        item.sNext = ";;";
        item.bLineBreak = true;
        item.bVerbatim = false;
        this.items.put(sName, item);
    }

    public boolean contains(String sName) {
        return sName != null && this.items.containsKey(sName);
    }

    public String getBefore(String sName) {
        return ((StyleMapItem)this.items.get((Object)sName)).sBefore;
    }

    public String getAfter(String sName) {
        return ((StyleMapItem)this.items.get((Object)sName)).sAfter;
    }

    public String getNext(String sName) {
        String sNext = ((StyleMapItem)this.items.get((Object)sName)).sNext;
        return sNext.substring(1, sNext.length() - 1);
    }

    public boolean isNext(String sName, String sNext) {
        String sNext1 = ((StyleMapItem)this.items.get((Object)sName)).sNext;
        return sNext1.indexOf(";" + sNext + ";") > -1;
    }

    public boolean getLineBreak(String sName) {
        return this.contains(sName) && ((StyleMapItem)this.items.get((Object)sName)).bLineBreak;
    }

    public boolean getVerbatim(String sName) {
        return this.contains(sName) && ((StyleMapItem)this.items.get((Object)sName)).bVerbatim;
    }

    public Enumeration getNames() {
        return this.items.keys();
    }
}

