/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.content;

import java.io.IOException;
import java.util.LinkedList;
import org.openoffice.xmerge.converter.xml.EmbeddedObject;
import org.openoffice.xmerge.converter.xml.EmbeddedXMLObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class DrawConverter
extends ConverterHelper {
    private boolean bNeedGraphicx = false;
    private LinkedList floatingFrames = new LinkedList();

    public DrawConverter(Config config, ConverterPalette palette) {
        super(config, palette);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bNeedGraphicx) {
            pack.append("\\usepackage");
            if (this.config.getBackend() == 2) {
                pack.append("[pdftex]");
            } else if (this.config.getBackend() == 1) {
                pack.append("[dvips]");
            }
            pack.append("{graphicx}").nl();
        }
    }

    public void handleDrawElement(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sName = node.getTagName();
        if (sName.equals("draw:object")) {
            this.handleDrawObject(node, ldp, oc);
        } else if (!oc.isInHeaderFooter() && sName.equals("draw:image")) {
            this.handleDrawImage(node, ldp, oc);
        } else if (!oc.isInHeaderFooter() && sName.equals("draw:text-box")) {
            this.handleDrawTextBox(node, ldp, oc);
        } else if (sName.equals("draw:a")) {
            this.palette.getFieldCv().handleAnchor(node, ldp, oc);
        } else {
            ldp.append("[Warning: Draw object ignored]");
        }
    }

    private void handleDrawObject(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sHref = node.getAttribute("xlink:href");
        if (sHref != null && sHref.length() > 0) {
            EmbeddedObject object = this.palette.getEmbeddedObject(sHref);
            if (object != null && "application/vnd.sun.xml.math".equals(object.getType())) {
                try {
                    Document settings = ((EmbeddedXMLObject)object).getSettingsDOM();
                    Document formuladoc = ((EmbeddedXMLObject)object).getContentDOM();
                    Element formula = Misc.getChildByTagName(formuladoc, "math:math");
                    ldp.append(" $").append(this.palette.getMathmlCv().convert(settings, formula)).append("$ ");
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Element formula = Misc.getChildByTagName(node, "math:math");
            if (formula != null) {
                ldp.append(" $").append(this.palette.getMathmlCv().convert(null, formula)).append("$ ");
            }
        }
    }

    private void handleDrawImage(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sName = node.getAttribute("text:name");
        this.palette.getFieldCv().addTarget(node, "|graphics", ldp);
        String sAnchor = node.getAttribute("text:anchor-type");
        if (oc.isInFrame() || "as-char".equals(sAnchor)) {
            this.handleDrawImageAsChar(node, ldp, oc);
        } else {
            this.floatingFrames.add(node);
        }
    }

    private void handleDrawImageAsChar(Element node, LaTeXDocumentPortion ldp, Context oc) {
        ldp.append(" ");
        this.includeGraphics(node, ldp, oc);
        ldp.append(" ");
    }

    private void handleDrawImageFloat(Element node, LaTeXDocumentPortion ldp, Context oc) {
        ldp.append("\\begin{center}").nl();
        this.includeGraphics(node, ldp, oc);
        ldp.nl().append("\\end{center}").nl();
    }

    /*
     * Unable to fully structure code
     */
    private void includeGraphics(Element node, LaTeXDocumentPortion ldp, Context oc) {
        block13: {
            block12: {
                sFileName = null;
                bCommentOut = true;
                sHref = node.getAttribute("xlink:href");
                if (sHref == null || sHref.length() <= 0 || sHref.startsWith("#")) break block12;
                sFileName = sHref;
                nExtStart = sHref.lastIndexOf(".");
                v0 = sExt = nExtStart >= 0 ? sHref.substring(nExtStart).toLowerCase() : "";
                if (sFileName.indexOf(":") > -1) ** GOTO lbl-1000
                if (this.config.getBackend() != 2 || !".jpg".equals(sExt)) {
                    if (this.config.getBackend() != 2 || !".png".equals(sExt)) {
                        ** if (this.config.getBackend() == 1 && ".eps".equals((Object)sExt)) goto lbl-1000
                    }
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v1 = true;
                    ** GOTO lbl19
                }
lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
lbl19:
                // 2 sources

                bCommentOut = v1;
                break block13;
            }
            bgd = this.palette.getImageLoader().getImage(node);
            if (bgd == null) break block13;
            this.palette.addDocument(bgd);
            sFileName = bgd.getFileName();
            sMIME = bgd.getDocumentMIMEType();
            if (this.config.getBackend() == 2 && "image/jpeg".equals(sMIME)) ** GOTO lbl-1000
            if (this.config.getBackend() == 2 && "image/png".equals(sMIME)) ** GOTO lbl-1000
            if (this.config.getBackend() != 1 || !"image/x-eps".equals(sMIME)) {
                v2 = true;
            } else lbl-1000:
            // 3 sources

            {
                v2 = bCommentOut = false;
            }
        }
        if (sFileName == null) {
            ldp.append("[Warning: Image not found]");
            return;
        }
        this.bNeedGraphicx = true;
        sWidth = Misc.truncateLength(node.getAttribute("svg:width"));
        sHeight = Misc.truncateLength(node.getAttribute("svg:height"));
        if (bCommentOut) {
            ldp.append(" [Warning: Image ignored] ");
            ldp.append("% Unhandled or unsupported graphics:").nl().append("%");
        }
        ldp.append("\\includegraphics");
        options = new CSVList(',');
        if (sWidth != null) {
            options.addValue("width=" + sWidth);
        }
        if (sHeight != null) {
            options.addValue("height=" + sHeight);
        }
        if (!options.isEmpty()) {
            ldp.append("[").append(options.toString()).append("]");
        }
        ldp.append("{").append(sFileName).append("}");
        if (bCommentOut) {
            ldp.nl();
        }
    }

    private void handleDrawTextBox(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sName = node.getAttribute("text:name");
        this.palette.getFieldCv().addTarget(node, "|frame", ldp);
        String sAnchor = node.getAttribute("text:anchor-type");
        if (oc.isInFrame() || "as-char".equals(sAnchor)) {
            this.makeDrawTextBox(node, ldp, oc);
        } else {
            this.floatingFrames.add(node);
        }
    }

    private void handleDrawTextBoxFloat(Element node, LaTeXDocumentPortion ldp, Context oc) {
        ldp.append("\\begin{center}").nl();
        this.makeDrawTextBox(node, ldp, oc);
        ldp.append("\\end{center}").nl();
    }

    private void makeDrawTextBox(Element node, LaTeXDocumentPortion ldp, Context oc) {
        Context ic = (Context)oc.clone();
        ic.setInFrame(true);
        ic.setNoFootnotes(true);
        String sWidth = Misc.truncateLength(node.getAttribute("svg:width"));
        ldp.append("\\begin{minipage}{").append(sWidth).append("}").nl();
        this.palette.getBlockCv().traverseBlockText(node, ldp, ic);
        ldp.append("\\end{minipage}");
        if (!oc.isNoFootnotes()) {
            this.palette.getNoteCv().flushFootnotes(ldp, oc);
        }
    }

    public void flushFloatingFrames(LaTeXDocumentPortion ldp, Context oc) {
        if (oc.isInFrame()) {
            return;
        }
        int n = this.floatingFrames.size();
        if (n == 0) {
            return;
        }
        int i = 0;
        while (i < n) {
            Element node = (Element)this.floatingFrames.get(i);
            String sName = node.getNodeName();
            if (sName.equals("draw:image")) {
                this.handleDrawImageFloat(node, ldp, oc);
            } else if (sName.equals("draw:text-box")) {
                this.handleDrawTextBoxFloat(node, ldp, oc);
            }
            ++i;
        }
        this.floatingFrames.clear();
    }
}

