/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.monitor;

import javax.swing.ImageIcon;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.view.JFRViewTab;
import org.graalvm.visualvm.jfr.views.monitor.JFRSnapshotMonitorViewProvider;
import org.graalvm.visualvm.jfr.views.monitor.MonitorViewSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class JFRSnapshotMonitorView
extends JFRViewTab {
    private static final String IMAGE_PATH = "org/graalvm/visualvm/jfr/resources/monitor.png";

    JFRSnapshotMonitorView(JFRSnapshot snapshot) {
        super(snapshot, NbBundle.getMessage(JFRSnapshotMonitorView.class, (String)"LBL_Monitor"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 10);
    }

    @Override
    protected DataViewComponent createComponent() {
        JFRModel model = this.getModel();
        boolean hasEvents = model != null && model.containsEvent(JFRSnapshotMonitorViewProvider.EventChecker.class);
        boolean hasPermGen = hasEvents && model.containsEvent(JFRSnapshotMonitorViewProvider.PermGenChecker.class);
        boolean hasMetaSpace = hasEvents && model.containsEvent(JFRSnapshotMonitorViewProvider.MetaspaceChecker.class);
        final MonitorViewSupport.CPUViewSupport cpuView = hasEvents ? new MonitorViewSupport.CPUViewSupport(model) : null;
        final MonitorViewSupport.HeapViewSupport heapView = hasEvents ? new MonitorViewSupport.HeapViewSupport(model) : null;
        final MonitorViewSupport.PermGenViewSupport permgenView = hasPermGen ? new MonitorViewSupport.PermGenViewSupport(model) : null;
        final MonitorViewSupport.MetaspaceViewSupport metaspaceView = hasMetaSpace ? new MonitorViewSupport.MetaspaceViewSupport(model) : null;
        final MonitorViewSupport.ClassesViewSupport classesView = hasEvents ? new MonitorViewSupport.ClassesViewSupport(model) : null;
        final MonitorViewSupport.ThreadsViewSupport threadsView = hasEvents ? new MonitorViewSupport.ThreadsViewSupport(model) : null;
        MonitorViewSupport.MasterViewSupport masterView = new MonitorViewSupport.MasterViewSupport(model){

            @Override
            void firstShown() {
                JFRSnapshotMonitorView.this.initialize(this, cpuView, heapView, permgenView, metaspaceView, classesView, threadsView);
            }
        };
        DataViewComponent dvc = new DataViewComponent(masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(!hasEvents));
        if (hasEvents) {
            dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(JFRSnapshotMonitorView.class, (String)"LBL_Cpu"), true), 1);
            dvc.addDetailsView(cpuView.getDetailsView(), 1);
            dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(JFRSnapshotMonitorView.class, (String)"LBL_Memory"), true), 2);
            dvc.addDetailsView(heapView.getDetailsView(), 2);
            if (metaspaceView != null) {
                dvc.addDetailsView(metaspaceView.getDetailsView(), 2);
            } else if (permgenView != null) {
                dvc.addDetailsView(permgenView.getDetailsView(), 2);
            }
            dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(JFRSnapshotMonitorView.class, (String)"LBL_Classes"), true), 3);
            dvc.addDetailsView(classesView.getDetailsView(), 3);
            dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(JFRSnapshotMonitorView.class, (String)"LBL_Threads"), true), 4);
            dvc.addDetailsView(threadsView.getDetailsView(), 4);
        }
        return dvc;
    }

    private void initialize(final MonitorViewSupport.MasterViewSupport masterView, final MonitorViewSupport.CPUViewSupport cpuView, final MonitorViewSupport.HeapViewSupport heapView, final MonitorViewSupport.PermGenViewSupport permgenView, final MonitorViewSupport.MetaspaceViewSupport metaspaceView, final MonitorViewSupport.ClassesViewSupport classesView, final MonitorViewSupport.ThreadsViewSupport threadsView) {
        final JFREventVisitor doneHandler = new JFREventVisitor(){

            @Override
            public boolean visit(String typeName, JFREvent event) {
                return true;
            }

            @Override
            public void done() {
                masterView.dataComputed();
            }
        };
        new RequestProcessor("JFR Monitor Initializer").post(new Runnable(){

            @Override
            public void run() {
                if (permgenView == null && metaspaceView == null) {
                    JFRSnapshotMonitorView.this.getModel().visitEvents(cpuView, heapView, classesView, threadsView, doneHandler);
                } else {
                    JFRSnapshotMonitorView.this.getModel().visitEvents(new JFREventVisitor[]{cpuView, heapView, metaspaceView != null ? metaspaceView : permgenView, classesView, threadsView, doneHandler});
                }
            }
        });
    }
}

