'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  If an argument is present, then a line break is
'\"	forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.8 96/02/15 20:02:24
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$1"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH ined n "" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ined \- Access and manipulate tkined objects.
.BE

.SH DESCRIPTION
The \fBTnm\fR extension can be used to write applications for the
tkined(1) network editor. The \fBined\fR command described in this man
page allows to access and manipulate the objects shown inside of the
editor. The communication between the tkined(1) editor and the
\fBTnm\fR process is encapsulated by the \fBined\fR command. The
\fBined\fR command also allows to make use of some standard dialogs
provided by the tkined(1) editor.

.SH TCL OBJECT FORMAT
The tkined(1) editor distinguishes between various object types.
Every object has a unique identifier, called its id, which is used to
access and manipulate this object. Exchanging the id between tkined(1)
and the \fBTnm\fR extension would be sufficient to implement all of
the commands below. However, this would not be very efficient because
an application often needs to access a set of standard object
attributes. To reduce communication costs, an external object
representation of the various object types is used which allows to
cache some information in the \fBTnm\fR extension.

The external object format is a Tcl list. The first element in this
list contains the object type and the second element the id of the
object. The following list elements depend on the type of the object
as described below.

To extract elements out of the external object format, you should
always use one of the \fBined\fR commands. Although not stated
explicitly, all the commands that return information which is included
in the external object format accept the external format as a single
argument and return the requested value as extracted from the external
format. By using these commands, you never need to access the external
format directly. This makes your scripts usually more readable and
makes sure that your scripts continue to work even if the format
changes in a future version.

.SS NETWORK

Network objects are used to represent networks (Ethernet, Token Ring,
FDDI, ATM). A network object is represented by a Tcl list containing
six elements:

.B { NETWORK <id> <name> <address> <oid> <list of links> }

The first element defines that the list represents a network object.
The <id> element is the unique identifier for the network object. The
value of the name and the address attributes of the network object are
contained in the <name> and <address> elements. The <oid> element
contains an external object identifier which is stored with the object
and may be used by applications to link external information (e.g. a
database) to a tkined object. The last field contains a list of link
objects that are connected to this network. The list contains the ids
of the links objects.

.SS NODE

Node objects are used to represent devices connected to a
network. Nodes may be used to model complex devices such as network
server or simple devices such as a transceiver, depending on the level
of detail shown in a map. A node object is represented by a Tcl list
containing six elements:

.B { NODE <id> <name> <address> <oid> <list of links> }

The meaning of these six elements is similar to the network object
described above.

.SS LINK

Link objects represent connections between node objects or a node
object and a network object. Note that a link can not connect two
network objects directly. You always have to model the device that
connects two networks by a node object. A link object is represented
by a Tcl list containing four elements:

.B { LINK <id> <src> <dst> }

The first element defines that the list represents a link object. The
<id> element is the unique identifier for the link object. The <src>
and <dst> elements contain the ids of the node or the network objects
that are connected by this link.

.SS GROUP

Group objects are container objects. They can contain arbitrary tkined
objects including other group objects. This allows to build
hierarchical structures. A group object is represented by a Tcl list
containing five elements:

.B { GROUP <id> <name> <oid> <list of objects> }

The first element defines that the list represents a group object. The
<id> element is the unique identifier for the group object.  The value
of the name attribute of the group object is contained in the <name>
element. The <oid> element contains an external object identifier
which is stored with the object and may be used by applications to
link external information (e.g. a database) to a tkined object. The
<list of objects> element contains a list of object ids which are
contained in this group object.

.SS TEXT

Text objects allow to display some text on the map. They are used to
make annotations or comments. A text object is represented by a Tcl
list containing three elements:

.B { TEXT <id> <text>}

The first element defines that the list represents a text object. The
<id> element is the unique identifier for the text object.  The text
displayed by the text object is contained in the <text> element.

.SS IMAGE

Image object allow to create and manipulate images. For example, image
objects can be used to put a floor plan or a geographical map in the
background of a map. An image object is represented by a Tcl list
containing three elements:

.B { IMAGE <id> <filename> }

The first element defines that the list represents an image
object. The <id> element is the unique identifier for the image
object. The image that is displayed by this image object is given by
the local file name contained in the <filename> element. The currently
supported image format is the X11 bitmap format.

.SS MENU

Menu objects are used to create new menus in the menu bar. An
application usually creates one or more menu objects which contain
commands provided by this application. A menu object is represented by
a Tcl list containing four elements:

.B { MENU <id> <name> <list of commands> }

The first element defines that the list represents a menu object. The
<id> element is the unique identifier for the menu object. The <name>
element contains the name of the menu as shown in the menu bar and the
<list of commands> element lists the commands that are exported by
this menu. These commands correspond to Tcl procedures provided by the
application. The procedures are called with the list of selected
objects.

.SS INTERPRETER

Interpreter objects represent external processes which provide
additional functionality. Interpreter objects allow to start and
control additional applications from an already running application.
They can also be used to exchange messages between applications. An
interpreter object is represented by a Tcl list containing three
elements:

.B { INTERPRETER <id> <name> }

The first element defines that the list represents an interpreter
object. The <id> element is the unique identifier for the interpreter
object. The <name> element contains the script or program name that
was started when the interpreter object was created.

.SS LOG

Log objects represent output windows and provide a way for
applications to write texts to the user interface. A log object has a
menubar which allows the user to load, save, print or email the
contents of the text window. A log object is represented by a Tcl list
containing four elements:

.B { LOG <id> <name> <address> }

The first element defines that the list represents a log object. The
<id> element is the unique identifier for the log object. The <name>
element contains the name of the output window and the <address>
element contains the default email address.

.SS REFERENCE

Reference objects are pointers (similar to hypertext links) to other
tkined maps. They can be used to tie logical and physical maps for the
same network together or they can be used to split up large maps into
smaller pieces. A reference object is represented by a Tcl list
containing four elements:

.B { REFERENCE <id> <name> <address> }

The first element defines that the list represents a reference
object. The <id> element is the unique identifier for the reference
object. The <name> element contains the value of the name attribute
and the <address> element contains the pointer. The pointer can either
be a simple path to a file which contains a tkined map or a FTP URL
like ftp://ftp.ibr.cs.tu-bs.de/pub/local/tkined/maps/ibr.tki. In the
later case, the file will be retrieved via anonymous ftp. This feature
allows you to let different people maintain their private network maps
while sharing the whole picture globally.

.SS STRIPCHART

Stripchart objects are used to display measured data. They show values
in a X-Y diagram which is scaled automatically. Scale lines indicate
the current scale value. A stripchart object is represented by a Tcl
list containing four elements:

.B { STRIPCHART <id> <name> <address> }

The first element defines that the list represents a stripchart
object. The <id> element is the unique identifier for the stripchart
object. The value of the name and the address attributes of the
stripchart object are contained in the <name> and <address> elements.

.SS BARCHART

Barchart objects are used to display measured data. They show a set of
values in a barchart diagram. Scale lines indicate the current scale
value. A barchart object is represented by a Tcl list containing four
elements:

.B { BARCHART <id> <name> <address> }

The first element defines that the list represents a barchart
object. The <id> element is the unique identifier for the barchart
object. The value of the name and the address attributes of the
barchart object are contained in the <name> and <address> elements.

.SS GRAPH

Graph objects are used to display measured data. Data is again shown
in a X-Y diagram. Graph objects use their own top-level window to
display the data and are not embedded into the map. Graph objects are
implemented using the BLT Tcl extension. Note, graph objects will be
mapped to stripchart objects if there is no BLT extension available.
A graph object is represented by a Tcl list containing four elements:

.B { GRAPH <id> <name> <address> }

The first element defines that the list represents a graph object. The
<id> element is the unique identifier for the graph object. The value
of the name and the address attributes of the graph object are
contained in the <name> and <address> elements.

.SH INED OBJECT COMMANDS
This section describes the \fBined\fR commands which can be used to
manipulate tkined objects.

.TP
.B ined create NODE
.ns
.TP
.B ined create NETWORK \fR[\fIx1 y1 x2 y2 \fR...]
.ns
.TP
.B ined create LINK \fIid1 id2 \fR[\fIx1 y1 \fR...]
.ns
.TP
.B ined create GROUP \fR[\fIida idb \fR...]
.ns
.TP
.B ined create TEXT \fIstring
.ns
.TP
.B ined create IMAGE \fIfilename
.ns
.TP
.B ined create MENU \fIname command1 \fR[\fIcommand2 \fR...]
.ns
.TP
.B ined create INTERPRETER \fIname
.ns
.TP
.B ined create LOG
.ns
.TP
.B ined create REFERENCE
.ns
.TP
.B ined create STRIPCHART
.ns
.TP
.B ined create BARCHART
.ns
.TP
.B ined create GRAPH

The \fBined create\fR command allows to create new tkined objects. The
\fBined create NODE\fR command creates a new node object and does not
require any arguments. The node will appear with the built-in default
icon and the default name. Its initial position is the upper left
corner.

The \fBined create NETWORK\fR command creates a new network object.
Coordinates for the fixed points of the network object can be defined
by providing the optional coordinates. Tkined will use the default
coordinates 0 0 130 0 if you do not specify any coordinates.

The \fBined create LINK\fR command creates a new link object. The
mandatory parameters define the two objects which are connected by the
new link object. Link objects find their position based on the
position of the nodes connected by this link. It is possible to
specify additional fixed points that will be respected by the link
positioning algorithm.

The \fBined create GROUP\fR command creates a new group
object. Optional parameters define the ids of all objects that are
becoming members of the new group object. The position of the group
object will be determined by the position of its members. The position
is the upper left corner if there are no members.

The \fBined create TEXT\fR command creates a new text object.  Text
objects are always created at the upper left corner and simply display
the string given in the mandatory parameter. Note, the string may
contain newline characters if they are written as \\n.

The \fBined create IMAGE\fR command creates background images which
are read from the file name given in the mandatory argument. Images
are positioned at the upper left corner.  The file name must point to
a valid X11 bitmap file.

The \fBined create MENU\fR command creates a new menu object. The menu
object appears in the menu bar. The first mandatory argument defines
the name of the menu as shown in the menu bar. The command arguments
will pop up when the menu is opened and correspond to Tcl procedures
that are called when an menu entry is selected.

The \fBined create INTERPRETER\fR command creates a new interpreter
object which starts an additional application. The mandatory argument
specifies which program or script is to be started.

The \fBined create LOG\fR command creates a new log object which can
be used to display texts. The new output window automatically pops up
on the screen.

The \fBined create REFERENCE\fR command creates a reference object
which points to other tkined maps. The address attribute can point
to local map files or remote map files by using FTP URLs.

The \fBined create STRIPCHART\fR, \fBined create BARCHART\fR and
\fBined create GRAPH\fR commands create stripchart, barchart or graph
objects. They can used by applications to display status and
monitoring information. They behave much like node objects but they
are not allowed to have links.

.TP
.B ined delete \fIid\fB

The \fBined delete\fR commands deletes the object given by
\fIid\fR. This command is understood by all tkined object types. If
the object has associated link objects, than these links are also
deleted.

.TP
.B ined type \fIid\fB
The \fBined type\fR command returns the type of the object given by 
\fIid\fR. The type name is returned in uppercase letters.

.TP
.B ined id \fIid\fB
The \fBined id\fR command returns the unique identifier for the object
given by \fIid\fR. This command is especially useful to extract the
object id out of the external object representation. It can also be used
to to test if the object given by id still exists.

.TP
.B ined name \fIid\fR [\fIstring\fR]
.ns
.TP
.B ined address \fIid\fR [\fIstring\fR]
.ns
.TP
.B ined oid \fIid\fR [\fInumber\fR]
.ns
.TP
.B ined attribute \fIid attribute\fR [\fIstring\fR]
The \fBined name\fR command allows to get or set the name attribute of
the object given by \fIid\fR. The \fBined address\fR command allows to
get or set the address attribute of the object given by \fIid\fR. The
\fBined oid\fR command allows to get or set the oid attribute of the
object given by \fIid\fR. All three commands return the current value
of the attribute or an empty string if the object does not support
this attribute. The \fBined attribute\fR command allows to get or set
arbitrary user-defined attributes of the object given by \fIid\fR.
The current value of the \fIattribute\fR is returned.  An empty string
is returned if the \fIattribute\fR does not exits.

.TP
.B ined select
.ns
.TP
.B ined select \fIid
.ns
.TP
.B ined unselect \fIid
.ns
.TP
.B ined selected \fIid
The \fBined select\fR command without any arguments returns the list
of currently selected objects. It is possible to add an object to the
current selection by using the \fBined select\fR command with an
argument which contains the object \fIid\fR. The \fBined unselect\fR
command removes the object given by \fIid\fR from the current
selection. The \fBined selected\fR command can be used to test if an
object given by \fIid\fR is currently selected or not. The \fBined
selected\fR command returns a boolean value.

.TP
.B ined retrieve \fR[\fIid\fR]
The \fBined retrieve\fR command retrurns a list containing the external
object representations of all objects associated with the current view
of the tkined editor. The \fBined retrieve\fR command returns the
object representation of the object with the given \fIid\fR if this
optional argument is present.

.TP
.B ined icon \fIid\fR [\fIname\fR]
The \fBined icon\fR command allows to get or change the name of the
icon associated with the object given by \fIid\fR. This command
is ignored by objects that don't support icons.

.TP
.B ined label \fIid
.ns
.TP
.B ined label \fIid\fB clear
.ns
.TP
.B ined label \fIid\fB name
.ns
.TP
.B ined label \fIid\fB address
.ns
.TP
.B ined label \fIid attribute
The \fBined label\fR command allows an application to query, modify or
delete the text displayed in the label below an icon. The first
version of the \fBined label\fR command returns the current settings
while the second version clears the current label. The \fBined label
\fIid\fB name\fR command tells tkined to use the value of the name
attribute as a label and the \fBined label \fIid\fB address\fR command
tells tkined to use the value of the address attribute. The \fBined
label\fR \fIid attribute\fR command tells tkined to use the value found
in a user defined \fIattribute\fR.

.TP
.B ined font \fIid\fR [\fIfontname\fR]
The \fBined font\fR command allows to get or change the font used by
the object given by \fIid\fR. This command is ignored by objects that
don't support fonts.

.TP
.B ined color \fIid\fR [\fIcolorname\fR]
The \fBined color\fR command allows to get or change the color which is
used to draw the object given by \fIid\fR. This command is ignored by 
objects that don't support color.

.TP
.B ined flash \fIid\fR \fIseconds\fR
The \fBined flash\fR command allows to flash the icon assiciated with
the object given by \fIid\fR. This command is ignored by objects that
can't flash.

.TP
.B ined move \fIid\fR [\fIx y\fR]
The \fBined move\fR command allows to move an object and to retrieve
the coordinates of an object. The command always returns the current
position of the object. The optional \fIx\fR and \fIy\fR parameters 
move the object relative to the current position.

.TP
.B ined size \fIid\fR
This \fBined size\fR command returns the size of the object given by
\fIid\fR. The size is returned as the coordinates of the bounding box,
that is the upper left and the lower right corners of the bounding
box.

.TP
.B ined text \fIid\fR [\fItext\fR]
The \fBined text\fR command allows to to get or change the text displayed
by a text object given by \fIid\fR.

.TP
.B ined links \fIid
The \fBined links\fR command returns the links currently connected to
the object given by \fIid\fR. This command is only understood by
objects that can be connected to links, like nodes and networks.

.TP
.B ined parent \fIid
The \fBined parent\fR command returns the unique identifier of the
group which contains the object given by \fIid\fR. An empty string is
returned if the object given by \fIid\fR is not a member of a group
object.

.TP
.B ined members \fIid\fR [\fIlist\fR]
The \fBined members\fR command allows to get or change the members of
the group object given by \fIid\fR. The command always returns the list
of members currently contained in the group.

.TP
.B ined collapse \fIid
The \fBined collapse\fR command tells tkined to show the group as a 
single icon. All objects contained in the group are invisible.

.TP
.B ined expand \fIid
The \fBined expand\fR command expands a collapsed group which makes
all the members of the group visible. The group itself is shown as a
rectangle encompassing the members of the group.

.TP
.B ined collapsed \fIid
The \fBined collapsed\fR command allows to check whether a group is
collapsed or expanded. It returns a boolean value which is true if
the group objects given by \fIid\fR is currently collapsed.

.TP
.B ined clear \fIid
The \fBined clear\fR command is used to clear all values contained in
a graph, bar- or stripchart given by \fIid\fR. The \fBined clear\fR
can also be used to remove all text from a log object if the object
given by \fIid\fR is a log object.

.TP
.B ined append \fIid text
The \fBined append\fR command appends some \fItext\fR to the log
object given by \fIid\fR.

.TP
.B ined hyperlink \fIid cmd text
The \fBined hyperlink\fR command appends the \fItext\fR to the log
object given by \fIid\fR and associates the command \fIcmd\fR with
it. A button press on \fItext\fR will send \fIcmd\fR to the
interpreter which created the log object given by \fIid\fR.

.TP
.B ined send \fIid cmd
The \fBined send\fR command is understood by interpreter objects.
The command \fIcmd\fR is send to the interpreter given by \fIid\fR for
execution. This allows scripts to use and control other scripts.

.TP
.B ined values \fIid\fR [\fInumber\fR ...]
The \fBined values\fR command is used to write new data to a barchart,
stripchart or graph object given by \fIid\fR. If called without the
optional arguments, the command returns all data currently stored in
the barchart, stripchart or graph object.

.TP
.B ined scale \fIid\fR [\fIvalue\fR]
The \fBined scale\fR command allows to set the scaling factor of a
graph, barchart or stripchart object given by \fIid\fR. The default
scale value is 100. Applications can use this command to adjust the
default if they know a better value. The command returns the actual
value.

.TP
.B ined jump \fIid\fR [\fInumber\fR]
The \fBined jump\fR command sets or retrieves the amount of pixels
that are scrolled when the stripchart given by \fIid\fR reaches the
right border.

.TP
.B ined dump \fIid\fR
The \fBined dump\fR command returns a command string which can be
used to recreate the object given by \fIid\fR. The contents of the
command string depends on the object type of \fIid\fR.



.SH INED DIALOG COMMANDS
This section describes the \fBined\fR commands which can be used
to create tkined dialogs on behalf of an application.

.TP
.B ined acknowledge \fIline\fR [\fIline\fR ...]
The \fBined acknowledge\fR command displays some text lines and waits
until the user clicks on the dismiss button. This dialog is usually
used to inform the user about some error situations.

.TP
.B ined confirm \fIline\fR [\fIline\fR ...] \fIbuttonlist\fR
The \fBined confirm\fR command issues a dialog which displays some
text lines and waits until the user clicks on one of the buttons
given in the \fIbuttonlist\fR. The name of the pressed button is
returned by the \fBined confirm\fR command.

.TP
.B ined fileselect \fItitle\fR [\fIdirectory\fR] [\fIfile\fR]
The \fBined fileselect\fR dialog allows to select a local file name.
The title of the fileselect dialog is given by the \fItitle\fR
argument. The optional parameters define the default \fIdirectory\fR
in the file system and the default \fIfile\fR name.

.TP
.B ined list \fItitle list buttonlist 
The \fBined list\fR dialog displays a listbox which allows to select
one of the elements given in the \fIlist\fR argument. The \fItitle\fR
parameter defines the title displayed above the listbox. The
\fIbuttonlist\fR contains a set of buttons which the user can press to
end the dialog. The result of the dialog is a Tcl list containing two
elements. The first element is the button pressed by the user and the
second element is the selected list object.

.TP
.B ined browse \fItitle\fR \fItext\fR
The \fBined browse\fR command allows to display some text that can be
browsed by the user. The text can be scrolled by pressing the middle
mouse button.

.TP
.B ined request \fItitle requestlist buttonlist
The \fBined request\fR command allows to request information from the
user. The displayed input form has a \fItitle\fR at the top and a list 
of buttons as defined in the \fIbuttonlist\fR at the bottom. Every
element in the \fIrequestlist\fR specifies an input field. The
specification on an input field is again a Tcl list. The first element
of this list is the label for the input field. The second element is
the default value for the input field. The third element defines which
input method is used. Recognized input methods are:

.RS
.TP
.B scale
The scale input method uses a slider to read the value. Additional
arguments in the list specify the minimum and the maximum value.
.TP
.B radio
The radio input method uses radiobuttons to select one or multiple
options. Additional arguments in the list define the legal
options.
.TP
.B check
The check input method uses checkbuttons to select one or more
options. Additional arguments in the list define the legal
options.
.TP
.B option
The option input method uses an option menu to select one option out
of a potentially large set of options. Additional arguments in the
list define the legal options.
.TP
.B request
The request input method displays an entry field where the user
can type and edit some text. The argument in the list specifies the
length of the entry box.
.RE

The \fBined request\fR command returns a Tcl list. The first element
of this list is the button pressed by the user to end the dialog.  The
following elements correspond to the elements in the \fIrequestlist\fR
and contain the value as selected by the user.

.SH INED GENERAL COMMANDS
This section describes some commands that manipulate the editor
as a whole and are not associated with particular objects.

.TP
.B ined size
The \fBined size\fR command returns the overall size of the map.  The
size is returned as the coordinates of the bounding box, that is the
upper left and the lower right corners of the bounding box. The upper
left corner always has the coordinates 0 0.

.TP
.B ined page [\fIsize\fR [\fIorientation\fR]]
The \fBined page\fR command can be used to get or set the page
size. The \fBined page\fR command always returns a string with the
current page size and its orientation. Legal \fIsize\fR values are
Letter, Legal, DINA0, DINA1, DINA2, DINA3 and DINA4. An unknown
\fIsize\fR value is mapped to DINA4. The \fIorientation\fR may be
portrait or landscape.

.TP
.B ined trace \fIcallback\fR
The \fBined trace\fR command tells tkined to trace all operations
performed on its objects. For every operation that modifies an object
state, the \fIcallback\fR procedure is called. It is expected to have
two arguments. The first argument contains the ined command and the
second one the result returned by the ined command. Applications can
use this trace for debugging purposes.

.TP
.B ined restart \fR[\fIcommand\fR]
The \fBined restart\fR command allows an application to save some
additional information in a tkined map file. This is usually used to
automatically restart monitoring jobs. When a new job is created, a
Tcl command string is assembled by the application that will restart
this job. This \fIcommand\fR string is then send to tkined using the
\fBined restart\fR command. Tkined will save this command string
together with the map file. If the map is loaded later, the
interpreter object is re-created and the command string send to it.
The \fBined restart\fR command always returns the current command
stored for the current interpreter object.

.SH BUGS
INTERPRETER objects should be named APPLICATION objects.
.br
LOG objects should be named OUTPUT objects.

.SH SEE ALSO
scotty(1), tkined(1), Tnm(n), Tcl(n), Tk(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
