/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.SybaseDialectExt;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;
import org.hibernate.HibernateException;
import org.hibernate.dialect.SybaseDialect;

public class SQLServerDialectExt
extends SybaseDialectExt
implements HibernateDialect {
    private SQLServerDialectHelper _dialect = new SQLServerDialectHelper();

    @Override
    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        return this._dialect.getTypeName(code, length, precision, scale);
    }

    @Override
    public boolean canPasteTo(IDatabaseObjectInfo info) {
        boolean result = true;
        DatabaseObjectType type = info.getDatabaseObjectType();
        if (type.getName().equalsIgnoreCase("database") || type.getName().equalsIgnoreCase("catalog")) {
            result = false;
        }
        return result;
    }

    @Override
    public String getLengthFunction(int dataType) {
        return "len";
    }

    @Override
    public int getMaxPrecision(int dataType) {
        if (dataType == 8 || dataType == 6) {
            return 53;
        }
        return 38;
    }

    @Override
    public int getMaxScale(int dataType) {
        return this.getMaxPrecision(dataType);
    }

    @Override
    public int getPrecisionDigits(int columnSize, int dataType) {
        return columnSize;
    }

    @Override
    public int getColumnLength(int columnSize, int dataType) {
        return columnSize;
    }

    @Override
    public String getDisplayName() {
        return "MS SQLServer";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().toLowerCase().startsWith("microsoft");
    }

    @Override
    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        boolean featureId = false;
        String msg = DialectUtils.getUnsupportedMessage(this, 0);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getColumnDropSQL(tableName, columnName, "DROP COLUMN", false, null, qualifier, prefs, this);
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo iTableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getTableDropSQL(iTableInfo, false, cascadeConstraints, false, "CASCADE", false, qualifier, prefs, this);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] colInfos, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        String alterClause = "ALTER COLUMN";
        DialectUtils.getMultiColNotNullSQL(colInfos, this, alterClause, true, result, qualifier, prefs);
        String pkSQL = DialectUtils.getAddPrimaryKeySQL(ti, pkName, colInfos, false, qualifier, prefs, this);
        result.add(pkSQL);
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return true;
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "ALTER COLUMN";
        return new String[]{DialectUtils.getColumnNullableAlterSQL(info, this, alterClause, true, qualifier, prefs)};
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuffer result = new StringBuffer();
        result.append("exec sp_rename ");
        result.append("'");
        result.append(from.getTableName());
        result.append(".");
        result.append(from.getColumnName());
        result.append("'");
        result.append(", ");
        result.append(to.getColumnName());
        result.append(", 'COLUMN'");
        return result.toString();
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer result = new StringBuffer();
        result.append("ALTER TABLE ");
        result.append(from.getTableName());
        result.append(" ALTER COLUMN ");
        result.append(from.getColumnName());
        result.append(" ");
        result.append(DialectUtils.getTypeName(to, this));
        list.add(result.toString());
        return list;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuffer result = new StringBuffer();
        result.append("ALTER TABLE ");
        result.append(info.getTableName());
        result.append(" ADD CONSTRAINT ");
        result.append(info.getTableName()).append("_").append(info.getColumnName()).append("_default");
        result.append(" DEFAULT ");
        if (JDBCTypeMapper.isNumberType(info.getDataType())) {
            result.append(info.getDefaultValue());
        } else {
            result.append("'");
            result.append(info.getDefaultValue());
            result.append("'");
        }
        result.append(" FOR ");
        result.append(info.getColumnName());
        return result.toString();
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.MSSQL;
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = true;
        boolean addNullClause = true;
        String sql = DialectUtils.getAddColumSQL(column, this, addDefaultClause, supportsNullQualifier, addNullClause, qualifier, prefs);
        result.add(sql);
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP INDEX $tableName$.$indexName$");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("indexName", indexName);
        valuesMap.put("tableName", tableName);
        return DialectUtils.bindAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 9;
        String msg = DialectUtils.getUnsupportedMessage(this, 9);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return "sp_helptext " + viewName;
    }

    @Override
    public boolean supportsRenameTable() {
        return false;
    }

    @Override
    public boolean supportsRenameView() {
        return false;
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 11;
        String msg = DialectUtils.getUnsupportedMessage(this, 11);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsSubSecondTimestamps() {
        return false;
    }

    private class SQLServerDialectHelper
    extends SybaseDialect {
        public SQLServerDialectHelper() {
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, "image");
            this.registerColumnType(-7, "tinyint");
            this.registerColumnType(2004, "image");
            this.registerColumnType(16, "tinyint");
            this.registerColumnType(1, 8000, "char($l)");
            this.registerColumnType(1, "text");
            this.registerColumnType(2005, "text");
            this.registerColumnType(91, "datetime");
            this.registerColumnType(3, "decimal($p,$s)");
            this.registerColumnType(8, "float($p)");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-4, "image");
            this.registerColumnType(-1, "text");
            this.registerColumnType(-15, "nchar($l)");
            this.registerColumnType(2, "numeric($p,$s)");
            this.registerColumnType(-9, "nvarchar($l)");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "datetime");
            this.registerColumnType(93, "datetime");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(-3, 8000, "varbinary($l)");
            this.registerColumnType(-3, "image");
            this.registerColumnType(12, 8000, "varchar($l)");
            this.registerColumnType(12, "text");
        }
    }
}

