/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import java.util.EventObject;

public class ButtonEvent
extends EventObject {
    public static final int BUTTON_EVENT_FIRST = 3299;
    public static final int BUTTON_EVENT_LAST = 3307;
    public static final int SHOW_BUTTON = 3299;
    public static final int HIDE_BUTTON = 3300;
    public static final int ENABLE_BUTTON = 3301;
    public static final int DISABLE_BUTTON = 3302;
    public static final int CHANGE_BUTTON_TEXT = 3303;
    public static final int CHANGE_BUTTON_MNEMONIC = 3304;
    public static final int CHANGE_BUTTON_TOOLTIP = 3305;
    public static final int CHANGE_BUTTON_FOCUS = 3306;
    public static final int SET_DEFAULT_BUTTON = 3307;
    private int _id;
    private String _buttonName;
    private String _userObject;

    public ButtonEvent(Object source, int id, String buttonName) {
        super(source);
        this._id = id;
        this._buttonName = buttonName;
        this.checkParam();
    }

    public ButtonEvent(Object source, int id, String buttonName, String userObject) {
        super(source);
        this._id = id;
        this._buttonName = buttonName;
        this._userObject = userObject;
        this.checkParam();
    }

    private void checkParam() {
        if (this.getID() < 3299 && this.getID() > 3307) {
            throw new IllegalArgumentException(this.getID() + " is an invalid event id for ButtonEvent");
        }
        if (this._buttonName == null || this._buttonName.trim().length() == 0) {
            throw new IllegalArgumentException("buttonName cannot be null or empty");
        }
        if (!(this._userObject != null && this._userObject.trim().length() != 0 || this.getID() != 3303 && this.getID() != 3304 && this.getID() != 3305)) {
            throw new IllegalArgumentException("userObject cannot be null or empty for " + this.paramString());
        }
    }

    public int getID() {
        return this._id;
    }

    public void setID(int id) {
        this._id = id;
    }

    public String getButtonName() {
        return this._buttonName;
    }

    public void setButtonName(String buttonName) {
        this._buttonName = buttonName;
    }

    public String getUserObject() {
        return this._userObject;
    }

    public void setUserObject(String userObject) {
        this._userObject = userObject;
    }

    public String paramString() {
        String typeStr;
        switch (this.getID()) {
            case 3299: {
                typeStr = "SHOW_BUTTON";
                break;
            }
            case 3300: {
                typeStr = "HIDE_BUTTON";
                break;
            }
            case 3301: {
                typeStr = "ENABLE_BUTTON";
                break;
            }
            case 3302: {
                typeStr = "DISABLE_BUTTON";
                break;
            }
            case 3303: {
                typeStr = "CHANGE_BUTTON_TEXT";
                break;
            }
            case 3304: {
                typeStr = "CHANGE_BUTTON_MNEMONIC";
                break;
            }
            case 3305: {
                typeStr = "CHANGE_BUTTON_TOOLTIP";
                break;
            }
            case 3306: {
                typeStr = "CHANGE_BUTTON_FOCUS";
                break;
            }
            case 3307: {
                typeStr = "SET_DEFAULT_BUTTON";
                break;
            }
            default: {
                typeStr = "BUTTON_EVENT_UNKNOWN";
            }
        }
        return typeStr;
    }
}

