# MySQL Connector/Python - MySQL driver written in Python.
# Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.

# MySQL Connector/Python is licensed under the terms of the GPLv2
# <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most
# MySQL Connectors. There are special exceptions to the terms and
# conditions of the GPLv2 as it is applied to this software, see the
# FOSS License Exception
# <http://www.mysql.com/about/legal/licensing/foss-exception.html>.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

"""This module handles compatibility issues between Python 2 and Python 3."""

import sys
import decimal
import binascii


PY3 = sys.version_info.major == 3


if PY3:
    from urllib.parse import urlparse

    def hexlify(data):
        return binascii.hexlify(data).decode("utf-8")

    NUMERIC_TYPES = (int, float, decimal.Decimal,)
    INT_TYPES = (int,)
    UNICODE_TYPES = (str,)
    STRING_TYPES = (str,)
    BYTE_TYPES = (bytearray, bytes,)


else:
    from urlparse import urlparse

    def hexlify(data):
        return data.encode("hex")

    NUMERIC_TYPES = (int, float, decimal.Decimal, long,)
    INT_TYPES = (int, long,)
    UNICODE_TYPES = (unicode,)
    STRING_TYPES = (str, unicode,)
    BYTE_TYPES = (bytearray,)
