/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import net.sf.mpxj.explorer.FileChooserController;
import net.sf.mpxj.explorer.FileChooserModel;
import net.sf.mpxj.explorer.FileChooserView;
import net.sf.mpxj.explorer.FileSaverController;
import net.sf.mpxj.explorer.FileSaverModel;
import net.sf.mpxj.explorer.FileSaverView;

public class ProjectExplorer {
    protected JFrame m_frame;

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    ProjectExplorer projectExplorer = new ProjectExplorer();
                    projectExplorer.m_frame.setVisible(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public ProjectExplorer() {
        this.initialize();
    }

    private void initialize() {
        this.m_frame = new JFrame();
        this.m_frame.setBounds(100, 100, 900, 451);
        this.m_frame.setDefaultCloseOperation(3);
        this.m_frame.getContentPane().setLayout(new GridLayout(1, 0, 0, 0));
        FileChooserModel fileChooserModel = new FileChooserModel();
        final FileChooserController fileChooserController = new FileChooserController(fileChooserModel);
        FileChooserView fileChooserView = new FileChooserView(this.m_frame, fileChooserModel);
        fileChooserModel.setExtensions("mpp", "mpx", "xml", "planner", "xer", "pmxml", "pp", "zip", "ppx", "fts", "pod", "mdb", "zip", "gan", "pep", "prx", "stx");
        FileSaverModel fileSaverModel = new FileSaverModel();
        final FileSaverController fileSaverController = new FileSaverController(fileSaverModel);
        FileSaverView fileSaverView = new FileSaverView(this.m_frame, fileSaverModel);
        fileSaverModel.setExtensions("sdef", "sdef", "mpx", "mpx", "planner", "xml", "pmxml", "xml", "json", "json", "mspdi", "xml");
        JMenuBar jMenuBar = new JMenuBar();
        this.m_frame.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open File...");
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Save As...");
        jMenuItem2.setEnabled(false);
        jMenu.add(jMenuItem2);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                fileChooserController.openFileChooser();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                fileSaverController.openFileSaver();
            }
        });
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        this.m_frame.getContentPane().add(jTabbedPane);
    }
}

