/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHArguments;
import bsh.BSHPrimarySuffix;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import java.lang.reflect.InvocationTargetException;

class BSHLHSPrimarySuffix
extends SimpleNode {
    public static final int INDEX = 1;
    public static final int NAME = 2;
    public static final int PROPERTY = 3;
    public int operation;
    Object index;
    public String field;
    public String method;

    public LHS doLHSSuffix(Object object, CallStack callStack, Interpreter interpreter) throws EvalError {
        try {
            switch (this.operation) {
                case 1: {
                    return this.doIndex(object, callStack, interpreter);
                }
                case 2: {
                    return this.doName(object, callStack, interpreter);
                }
                case 3: {
                    return this.doProperty(object, callStack, interpreter);
                }
            }
            throw new InterpreterError("LHS suffix");
        }
        catch (ReflectError reflectError) {
            throw new EvalError("reflection error: " + reflectError, this);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TargetError("target exception", invocationTargetException.getTargetException(), this, true);
        }
    }

    private final LHS doName(Object object, CallStack callStack, Interpreter interpreter) throws EvalError, ReflectError, InvocationTargetException {
        if (this.jjtGetNumChildren() == 0) {
            return Reflect.getLHSObjectField(object, this.field);
        }
        Object[] objectArray = ((BSHArguments)this.jjtGetChild(0)).getArguments(callStack, interpreter);
        try {
            object = Reflect.invokeObjectMethod(interpreter, object, this.method, objectArray, this);
        }
        catch (EvalError evalError) {
            throw new EvalError(evalError.getMessage(), this);
        }
        return Reflect.getLHSObjectField(object, this.field);
    }

    private final LHS doIndex(Object object, CallStack callStack, Interpreter interpreter) throws EvalError, ReflectError {
        int n = BSHPrimarySuffix.getIndexAux(object, callStack, interpreter, this);
        return new LHS(object, n);
    }

    private final LHS doProperty(Object object, CallStack callStack, Interpreter interpreter) throws EvalError, ReflectError {
        if (object == Primitive.VOID) {
            throw new EvalError("Attempt to access property on a void type", this);
        }
        if (object instanceof Primitive) {
            throw new EvalError("Attempt to access property on a primitive", this);
        }
        Object object2 = ((SimpleNode)this.jjtGetChild(0)).eval(callStack, interpreter);
        if (!(object2 instanceof String)) {
            throw new EvalError("Property expression must be a String or identifier.", this);
        }
        if (Interpreter.DEBUG) {
            Interpreter.debug("LHS property access: ");
        }
        return new LHS(object, (String)object2);
    }

    BSHLHSPrimarySuffix(int n) {
        super(n);
    }
}

