/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.frames;

import org.eclipse.jetty.spdy.api.Headers;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.ControlFrameType;

public class SynStreamFrame
extends ControlFrame {
    private final int streamId;
    private final int associatedStreamId;
    private final byte priority;
    private final short slot;
    private final Headers headers;

    public SynStreamFrame(short version, byte flags, int streamId, int associatedStreamId, byte priority, short slot, Headers headers) {
        super(version, ControlFrameType.SYN_STREAM, flags);
        this.streamId = streamId;
        this.associatedStreamId = associatedStreamId;
        this.priority = priority;
        this.slot = slot;
        this.headers = headers;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public int getAssociatedStreamId() {
        return this.associatedStreamId;
    }

    public byte getPriority() {
        return this.priority;
    }

    public short getSlot() {
        return this.slot;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public boolean isClose() {
        return (this.getFlags() & 1) == 1;
    }

    public boolean isUnidirectional() {
        return (this.getFlags() & 2) == 2;
    }

    @Override
    public String toString() {
        return String.format("%s stream=%d close=%b", super.toString(), this.getStreamId(), this.isClose());
    }
}

