;;;
;;; $Id: irchat-vars.el,v 1.4 1994/02/23 15:05:00 tmo Exp $
;;;
;;; see file irchat-copyright.el for change log and copyright info

(provide 'irchat-vars)

;;;
;;; user modifiable variables
;;;

(defvar irchat-command-window-height 4
  "*How large should Command window be on startup.")

(defvar irchat-channel-window-height-percent 63
  "*How large percent should Current channel window be on startup.")

(defvar irchat-want-traditional nil
  "*Do we want Irchat to look like IrcII.")

(defvar irchat-want-jp-compatible t
  "*Do we want this to look like irchat1.25jp")

(defvar irchat-variables-file "~/.irchat_vars.el"
  "*Where to look for variables. Helps to remove clutter from your .emacs.
This feature is most likely to dissappear in near future. The preferred 
way is to put irchat variables on .emacs or file loaded from there.")

(defvar irchat-server-alist
  '(("fc" . "irc.friend.td.nu")
    ("kyoto" . "irc.kyoto.wide.ad.jp")
    ("tokyo0" . "irc.tokyo.wide.ad.jp:6660")
    ("tokyo1" . "irc.tokyo.wide.ad.jp:6661")
    ("tokyo2" . "irc.tokyo.wide.ad.jp:6662")
    ("tokyo3" . "irc.tokyo.wide.ad.jp:6663")
    ("rcac" . "irc.rcac.tdi.co.jp:6669")
    ("race" . "irc.race.u-tokyo.ac.jp"))
  "*IRC server assoc-list which is used for input IRC server.")

(defvar irchat-server (or (getenv "IRCSERVER") nil)
  "*Name of the host running the IRC server. 
Value initialized from the IRCSERVER environment variable if one is set")

(defvar irchat-service 
  (let ((ircport-env (getenv "IRCPORT")))
    (if ircport-env
	(if (> (string-to-int ircport-env) 0)
	    (string-to-int ircport-env)
	  ircport-env)
      6667))
  "*IRC service name or (port) number.")

(defvar irchat-dcc-auto-get-file nil
  "*If non-nil, get a file automatically when DCC request received.")

(defvar irchat-dcc-program "dcc"
  "*Name of dcc-program.")

(defvar irchat-dcc-directory "~/tmp"
  "*Directory where irchat-dcc puts its files.")

(defvar irchat-name (or (getenv "IRCNAME")
			(getenv "NAME")
			(user-full-name)
			"IRCHAT-PJ Default")
  "*Your realname.
Initialized from the IRCNAME or NAME environment variable, or your GCOS field.")

(defvar irchat-password (or (getenv "IRCPASSWORD") nil)
  "*Your password when connecting to server.")

(defvar irchat-nickname (or (getenv "IRCNICK")
			    (user-real-login-name)
			    "irchat-pj")
  "*The nickname you want to use in IRC.
Default is the environment variable IRCNICK, or your login name.")

;; add by simm@irc.fan.gr.jp, Mon, 08 Nov 1999 02:55:16 +0900
(defvar irchat-pj-startup-nickname-list nil
  "*The nickname list you want to use in IRC.
When startup, try to connect according to this nickname list.")

(defvar irchat-servername "")

(defvar irchat-startup-channel nil
  "obsolete.")

(defvar irchat-startup-channel-list nil
  "*The channel list to join automatically at startup.
If nil, do not join any channel.")

(defvar irchat-default-channel-binding nil
  "*The channel list to bind the channel number when joining.")

(defvar irchat-channel-conversion-map nil
  "*The map of channel conversion.")

(defvar irchat-channel-conversion-default-mask "*.jp"
  "*The default mask of channel conversion.")

(defvar irchat-format-string ">%s<"
  "*Format string for private messages being sent.")

(defvar irchat-format-string1 "=%s="
  "*Format string for arriving private messages.")

(defvar irchat-format-string2 "<%s>"
  "*Format string for arriving messages to current channel.")

(defvar irchat-format-string3 "<%s:%s>"
  "*Format string for arriving messages to current channel from outside the channel.")

(defvar irchat-format-string4 "(%s)"
  "*Format string for arriving messages to other channel from outside the channel.")

(defvar irchat-format-string5 "(%s:%s)"
  "*Format string for arriving messages to other channel from outside the channel.")

(defvar irchat-signoff-msg nil
  "*Default signoff message if no-nil")

(defvar irchat-channel-signoff-msg nil
  "*Default signoff message if no-nil")

(defvar irchat-switching-channels nil
  "*channel list to switch directly*")

(defvar irchat-print-time t
  "*If non-nil, print time prefix on each line in channel buffer*")

(defvar irchat-others-high-watermark 10000
  "*The value of high watermark in Others buffer*")

(defvar irchat-others-low-watermark 5000
  "*The value of high watermark in Others buffer*")

(defvar irchat-beep-on-bells nil
  "*If non-nil, and the IRC Dialogue buffer is not selected in a window,
an IRC message arriving containing a bell character, will cause you
to be notified.
If value is 'always, an arriving bell will always cause a beep (or flash).")

(defvar irchat-ctcp-userinfo "No user information given."
  "*Userinfo message given to anyone asking via CTCP.")

(defvar irchat-timestamp-interval nil
  "*Interval in minutes between timestamps in dialogue-buffer, nil for none.")

(defvar irchat-timestamp-format "*** Time: %s"
  "*Format-string for timestamp.")

(defvar irchat-global-names nil
  "*Set this to T if you want irchat to be able to complete user and 
channel names. If NIL given, irchat does not do global names polling, 
thus causing much less network traffic, but then it is only able to 
complete names on channels you have joined. If number given, it is the
internal between two successive polls.

Notice: There are some gotchas here.
  1. The server sendq is by default 20k and globals names maybe about 30k
     at the time this is written. The NAMES query may cause server to 
     drop the client because of flooding.
  2. The namreply (353) handler is called pretty often and it causes some
     garbage even if it is heavily optimized. You emacs will eat a lot of
     cpu if this is enabled.")

;;;
;;; additional variables for irchat-pj enhancemet, by irchat-PJ Project
;;;

;; add by simm@irc.fan.gr.jp Thu, 19 Nov 1998
(defvar irchat-pj-rewrite-server-notice nil
  "Rewrite notice message from server.
Default : =irc.kyoto.wide.ad.jp= gaga
If t    : === gaga")

(defvar irchat-pj-katakana-convert t
  "Convert jisx0201 katakana characters to jisx0208.")

(defvar irchat-pj-fix-gaga-problem nil
  "When `gaga' problem occured, not join but warn.
If your server is irc2.10.3+jp6, set nil.
If your server is older version, set t.")

;; add by simm@irc.fan.gr.jp Sun, 1 Nov 1998
(defvar irchat-pj-code-verbose nil
  "Output messages on minibuffer when received non-JIS code")

;; add by simm@irc.fan.gr.jp Sat, 16 Jan 1999
(defvar irchat-pj-string-in-code 'auto-detect
  "Input character code from server. Select below:

'iso-2022-7bit-ss2           : Input code is ISO-2022-7BIT-SS2.
'iso-2022-jp                 : Input code is ISO-2022-JP.
'euc-jp, 'euc-japan          : Input code is EUC-Japan.
'sjis, 'shift-jis, 'ms-kanji : Input code is MS-Kanji.
'noconv                      : No conversion when input.
'non-euc                     : Detect automatically. (ISO-2022-7BIT-SS2 or MS-Kanji)
'auto-detect       (default) : Detect automatically. (ISO-2022-7BIT-SS2/MS-Kanji/EUC-Japan)
")

(defvar irchat-pj-string-out-code 'iso-2022-7bit-ss2
  "Output character code to server. Select below:

'iso-2022-7bit-ss2 (default) : Output code is ISO-2022-7BIT-SS2.
'iso-2022-jp                 : Output code is ISO-2022-JP.
'euc-jp, 'euc-japan          : Output code is EUC-Japan.
'sjis, 'shift-jis, 'ms-kanji : Output code is MS-Kanji.
'noconv                      : No conversion when output.
")

;; add by simm@irc.fan.gr.jp Sun, 24 Jan 1999
(defvar irchat-pj-filter-queue ""
  "Queue variable for irchat-filter.")

;; add by negi@KU3G.org, 1 Jun 1999
(defvar irchat-pj-abbrev-table nil
  "Abbrev table in use irchat-pj")

;; add by negi@KU3G.org, 1 Jun 1999
;;        simm@irc.fan.gr.jp, Sat, 5 Jun 1999
(defvar irchat-pj-save-log-directory "~/tmp"
  "Log directory")

(defvar irchat-pj-save-log-channel-alist nil
  "Alist of save channel and filename.
car: channel
cdr: base filename

ex. '((\"#KU3G\" . \"KU3G\")
      (\"#IRC$(BIa5Z0Q0w2q(B:*.jp\" . \"ircpa\"))")

;; add by simm@irc.fan.gr.jp, Sat, 5 Jun 1999
(defvar irchat-pj-quit-with-kill-buffer nil
  "If t, kill some irchat-pj-related buffers.")

;; add by simm@irc.fan.gr.jp, Thu, 10 Jun 1999
(defvar irchat-pj-my-userhost ""
  "My user@host. Set when received 001.")

;; add by simm@irc.fan.gr.jp, Mon, 14 Jun 1999
(defvar irchat-pj-broadcast-ignore-list nil
  "Channel/nick list irchat-pj-send-broadcast ignores.")

(defvar irchat-pj-broadcast-accept-list nil
  "Channel/nick list irchat-pj-send-broadcast accepts.")

(defvar irchat-pj-broadcast-private nil
  "If t, broadcast message is sent to private partner.")

(defvar irchat-pj-broadcast-channel t
  "If t, broadcast message is sent to channels.")

;; add by simm@irc.fan.gr.jp, Sun, 27 Jun 1999
(defvar irchat-pj-scroll-condition nil
  "Configure scroll condition.
This variable decides scroll condition when non-pj frame is active.
It uses as second argument for get-buffer-window.")

;; add by simm@irc.fan.gr.jp, Tue, 20 Jul 1999
(defvar irchat-pj-handle-join-verbose t
  "Display userhost when someone joins")
(defvar irchat-pj-handle-nick-verbose t
  "Display userhost when someone changes nick")
(defvar irchat-pj-handle-part-verbose t
  "Display userhost when someone parts")
(defvar irchat-pj-handle-quit-verbose t
  "Display userhost when someone quits")

;; add by simm@irc.fan.gr.jp, Sat, 18 Dec 1999 00:17:46 +0900
(defvar irchat-pj-auto-oper-list nil
  "List of user@host to give channel operator automatically.
Each element consists of  \"nick!user@host\"-formatted string,
\(\"user@host\" . \"#channel1,#channel2,...\"\)-formatted cons-cell,
or \(\"user@host\" \"#channel1\" \"#channel2,...\"\)-formatted list.")

(defvar irchat-pj-maximum-privmsg-channels 5
  "Maximum channels PRIVMSG accepts.")

;; add by simm@irc.fan.gr.jp, Fri, 28 Jan 2000 02:42:03 +0900
(defvar irchat-pj-first-channel nil
  "First channel or nickname you first contact with.
If non-nil, do (irchat-Command-join irchat-pj-first-channel) when initialize.")

(defvar irchat-pj-initialize-p nil
  "Temporary variable for irchat-pj-first-channel")

;; add by simm@irc.fan.gr.jp, Wed, 22 Mar 2000 00:10:42 +0900
(defvar irchat-pj-enable-undernet-server t
  "If non-nil, enable Undernet server.")

;;;
;;; eof
;;;
