;;;
;;; irchat-pj-specific-other-emacsen.el
;;; last modify : Thu, 28 Oct 1999 00:04:46 +0900
;;;               by simm@irc.fan.gr.jp / irchat-PJ Project
;;; (date format modification by simm@irc.fan.gr.jp, Sun, 27 Jun 1999)
;;; see file irchat-copyright.el for change log and copyright info
;;;

;; load defsubst

(or (fboundp 'defsubst)
    (fset 'defsubst 'defun))

;;; for irchat-pj-coding-system.el

;; define service / set process

;; begin: from irchat-2.4jp24g
(defsubst irchat-pj-define-service-coding-system (service)
  (if (fboundp 'modify-coding-system-alist)
      (modify-coding-system-alist 'network service
                                  (cons 'no-conversion 'no-conversion))
    (if (fboundp 'define-service-coding-system)
        (define-service-coding-system service nil (cons *noconv* *noconv*))
      (if (fboundp 'define-service-kanji-code)
          (define-service-kanji-code service nil 0)))))

(defsubst irchat-pj-set-process-coding-system (proc)
  (if (fboundp 'modify-coding-system-alist)
      (set-process-coding-system proc 'no-conversion 'no-conversion)
    (if (fboundp 'set-process-coding-system)
        (set-process-coding-system proc *noconv* *noconv*)
      (if (fboundp 'set-process-kanji-code)
          (set-process-kanji-code proc 0)))))
;; end: from irchat-2.4jp24g

;; output functions

(defsubst irchat-pj-string-out-iso-2022-jp (str)
  str)
(fset 'irchat-pj-string-out-iso-2022-7bit-ss2
      'irchat-pj-string-out-iso-2022-jp)
(fset 'irchat-pj-string-out-euc-jp
      'irchat-pj-string-out-iso-2022-jp)
(fset 'irchat-pj-string-out-sjis
      'irchat-pj-string-out-iso-2022-jp)

;; input functions

(defsubst irchat-pj-string-in-iso-2022-jp (str)
  str)
(fset 'irchat-pj-string-in-iso-2022-7bit-ss2
      'irchat-pj-string-in-iso-2022-jp)
(fset 'irchat-pj-string-in-euc-jp
      'irchat-pj-string-in-iso-2022-jp)
(fset 'irchat-pj-string-in-sjis
      'irchat-pj-string-in-iso-2022-jp)

(defsubst irchat-pj-string-in-euc-jp-internal (str)
  str)

(defsubst irchat-pj-string-in-sjis-internal (str)
  (convert-string-kanji-code str 1 3))

;;; for irchat-pj-version-string.el

(defun irchat-pj-set-emacs-version-string ()
  "Set Emacs version string for CTCP VERSION"
  (or (and (boundp 'system-configuration)
	   (stringp system-configuration)
	   (concat "Emacs " emacs-version " (" system-configuration ")"))
      (concat "Emacs " emacs-version)))

(provide 'irchat-pj-specific-other-emacsen)

;;;
;;; end
;;;
