/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.readers;

import it.unimi.dsi.lang.MutableString;

public class FastXEntry
implements Cloneable {
    private char headerSymbol;
    private MutableString entry = new MutableString();
    private MutableString entrySansHeader = new MutableString();
    private MutableString sequenceHeader = new MutableString();
    private MutableString sequence = new MutableString();
    private MutableString qualityHeader = new MutableString();
    private MutableString quality = new MutableString();
    private boolean entryComplete;

    FastXEntry() {
        this.reset();
    }

    void reset() {
        this.entry.length(0);
        this.entrySansHeader.length(0);
        this.sequenceHeader.length(0);
        this.sequence.length(0);
        this.qualityHeader.length(0);
        this.quality.length(0);
        this.entryComplete = false;
        this.headerSymbol = '\u0000';
    }

    boolean addLine(String line) {
        if (line.length() == 0) {
            return true;
        }
        char symbol = line.charAt(0);
        boolean setSequenceHeader = false;
        if (this.sequenceHeader.length() == 0) {
            this.headerSymbol = symbol;
            this.sequenceHeader.append(line.subSequence(1, line.length()));
            setSequenceHeader = true;
        } else {
            if ((symbol == '@' || symbol == '>') && this.sequenceHeader.length() > 0 && this.qualityHeader.length() == 0) {
                this.entryComplete = true;
                return false;
            }
            if (symbol == '+' && this.qualityHeader.length() == 0) {
                this.qualityHeader.append(line);
            } else if (this.qualityHeader.length() > 0) {
                this.quality.append(line);
            } else {
                this.sequence.append(line);
            }
        }
        if (this.quality.length() > 0 && this.quality.length() >= this.sequence.length()) {
            this.entryComplete = true;
        }
        if (!setSequenceHeader) {
            if (this.entrySansHeader.length() > 0) {
                this.entrySansHeader.append('\n');
            }
            this.entrySansHeader.append(line);
        }
        if (this.entry.length() > 0) {
            this.entry.append('\n');
        }
        this.entry.append(line);
        return true;
    }

    public boolean isCasavaFilteredOutEntry() {
        return this.sequenceHeader.indexOf((CharSequence)":Y:") != -1;
    }

    public char getHeaderSymbol() {
        return this.headerSymbol;
    }

    public MutableString getEntry() {
        return this.entry;
    }

    public MutableString getSequence() {
        return this.sequence;
    }

    public MutableString getQuality() {
        return this.quality;
    }

    public MutableString getQualityHeader() {
        return this.qualityHeader;
    }

    public MutableString getEntrySansHeader() {
        return this.entrySansHeader;
    }

    public MutableString getEntryHeader() {
        return this.sequenceHeader;
    }

    public int getReadLength() {
        return this.sequence.length();
    }

    public boolean isEntryComplete() {
        return this.entryComplete;
    }

    void setEntryComplete(boolean entryComplete) {
        this.entryComplete = entryComplete;
    }

    public FastXEntry clone() throws CloneNotSupportedException {
        FastXEntry clone = (FastXEntry)super.clone();
        clone.headerSymbol = this.headerSymbol;
        clone.entry = new MutableString(this.entry);
        clone.entrySansHeader = new MutableString(this.entrySansHeader);
        clone.sequenceHeader = new MutableString(this.sequenceHeader);
        clone.sequence = new MutableString(this.sequence);
        clone.qualityHeader = new MutableString(this.qualityHeader);
        clone.quality = new MutableString(this.quality);
        clone.entryComplete = this.entryComplete;
        return clone;
    }
}

