/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.perms;

import it.unimi.dsi.fastutil.objects.Object2ByteAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.lang.MutableString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.AlignmentReaderImpl;

public class ReadNameToIndex {
    private static final Log LOG = LogFactory.getLog(ReadNameToIndex.class);
    private final String basename;
    private int globalQueryMaxOccurences = 2;
    private int smallIndexCounter;
    private final Object2ByteMap<MutableString> timesRequested = new Object2ByteAVLTreeMap();
    private final Object2IntMap<MutableString> namesToIndex = new Object2IntAVLTreeMap();

    public ReadNameToIndex(String filename) {
        this.basename = AlignmentReaderImpl.getBasename(filename);
        this.reset();
    }

    private void reset() {
        this.namesToIndex.clear();
        this.namesToIndex.defaultReturnValue(-1);
        this.timesRequested.clear();
        this.timesRequested.defaultReturnValue((byte)0);
    }

    private void pushToPreStorage(MutableString readName, int queryIndex) {
    }

    public int getQueryIndex(String readName, int maxObservations) {
        int timesSeen;
        int queryIndex;
        MutableString readNameMutable = new MutableString(readName).compact();
        byte timesRequestedInt = this.timesRequested.getByte((Object)readNameMutable);
        if (timesRequestedInt == 0) {
            queryIndex = this.smallIndexCounter++;
            if (maxObservations > 1) {
                this.namesToIndex.put((Object)readNameMutable, queryIndex);
            }
        } else {
            queryIndex = this.namesToIndex.getInt((Object)readNameMutable);
        }
        if ((timesSeen = timesRequestedInt + 1) >= maxObservations) {
            this.namesToIndex.remove((Object)readNameMutable);
            this.timesRequested.remove((Object)readNameMutable);
            this.pushToPreStorage(readNameMutable, queryIndex);
        } else if (maxObservations > 1) {
            this.timesRequested.put((Object)readNameMutable, (byte)timesSeen);
        }
        return queryIndex;
    }

    public void setPruneLimit(byte limit) {
        this.globalQueryMaxOccurences = limit;
    }

    public void close() {
    }
}

