/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.ruler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.diylc.appframework.images.IconLoader;
import org.diylc.swingframework.IDrawingProvider;
import org.diylc.swingframework.ruler.ComponentThumbnailProvider;
import org.diylc.swingframework.ruler.IRulerListener;
import org.diylc.swingframework.ruler.NavigateDialog;
import org.diylc.swingframework.ruler.Ruler;

public class RulerScrollPane
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private Ruler horizontalRuler;
    private Ruler verticalRuler;
    private JButton unitButton;
    private JButton navigateButton;
    private List<IRulerListener> listeners;

    public RulerScrollPane(Component view) {
        this(view, new ComponentThumbnailProvider(view));
    }

    public RulerScrollPane(Component view, IDrawingProvider provider) {
        this(view, provider, 0.0, 0.0);
    }

    public RulerScrollPane(Component view, final IDrawingProvider provider, double cmSpacing, double inSpacing) {
        super(view);
        this.horizontalRuler = new Ruler(0, true, cmSpacing, inSpacing);
        this.setColumnHeaderView(this.horizontalRuler);
        this.verticalRuler = new Ruler(1, true, cmSpacing, inSpacing);
        this.setRowHeaderView(this.verticalRuler);
        this.listeners = new ArrayList<IRulerListener>();
        view.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                RulerScrollPane.this.updateRulerSize(e.getComponent().getWidth(), e.getComponent().getHeight());
            }
        });
        this.updateRulerSize(view.getWidth(), view.getHeight());
        this.unitButton = new JButton("cm");
        this.unitButton.setToolTipText("Toggle metric/imperial system");
        this.unitButton.setMargin(new Insets(0, 0, 0, 0));
        this.unitButton.setFont(this.unitButton.getFont().deriveFont(9.0f));
        this.unitButton.setFocusable(false);
        this.setCorner("UPPER_LEFT_CORNER", this.unitButton);
        this.unitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RulerScrollPane.this.horizontalRuler.isMetric()) {
                    RulerScrollPane.this.horizontalRuler.setIsMetric(false);
                    RulerScrollPane.this.verticalRuler.setIsMetric(false);
                    RulerScrollPane.this.unitButton.setText("in");
                } else {
                    RulerScrollPane.this.horizontalRuler.setIsMetric(true);
                    RulerScrollPane.this.verticalRuler.setIsMetric(true);
                    RulerScrollPane.this.unitButton.setText("cm");
                }
                for (IRulerListener listener : RulerScrollPane.this.listeners) {
                    listener.unitsChanged(RulerScrollPane.this.horizontalRuler.isMetric());
                }
            }
        });
        this.setCorner("UPPER_RIGHT_CORNER", new Corner(0));
        this.setCorner("LOWER_LEFT_CORNER", new Corner(1));
        this.navigateButton = new JButton(IconLoader.MoveSmall.getIcon());
        this.navigateButton.setToolTipText("Auto-scroll");
        this.navigateButton.setFocusable(false);
        this.navigateButton.setMargin(new Insets(0, 0, 0, 0));
        this.navigateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NavigateDialog navigateDialog = new NavigateDialog(RulerScrollPane.this, provider);
                navigateDialog.setVisible(true);
                navigateDialog.setLocationRelativeTo(RulerScrollPane.this.navigateButton);
            }
        });
        this.setCorner("LOWER_RIGHT_CORNER", this.navigateButton);
        view.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("dragPoint")) {
                    RulerScrollPane.this.horizontalRuler.setIndicatorValue(((Long)evt.getOldValue()).intValue());
                    RulerScrollPane.this.horizontalRuler.repaint();
                    RulerScrollPane.this.verticalRuler.setIndicatorValue(((Long)evt.getNewValue()).intValue());
                    RulerScrollPane.this.verticalRuler.repaint();
                }
            }
        });
        view.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                RulerScrollPane.this.horizontalRuler.setIndicatorValue(e.getX());
                RulerScrollPane.this.horizontalRuler.repaint();
                RulerScrollPane.this.verticalRuler.setIndicatorValue(e.getY());
                RulerScrollPane.this.verticalRuler.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                RulerScrollPane.this.horizontalRuler.setIndicatorValue(e.getX());
                RulerScrollPane.this.horizontalRuler.repaint();
                RulerScrollPane.this.verticalRuler.setIndicatorValue(e.getY());
                RulerScrollPane.this.verticalRuler.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RulerScrollPane.this.horizontalRuler.setIndicatorValue(-1);
                RulerScrollPane.this.horizontalRuler.repaint();
                RulerScrollPane.this.verticalRuler.setIndicatorValue(-1);
                RulerScrollPane.this.verticalRuler.repaint();
            }
        });
        this.setHorizontalScrollBarPolicy(32);
        this.getHorizontalScrollBar().setUnitIncrement(50);
        this.setVerticalScrollBarPolicy(22);
        this.getVerticalScrollBar().setUnitIncrement(50);
    }

    public void setSelectionRectangle(Rectangle2D rect) {
        this.horizontalRuler.setSelectionRect(rect);
        this.verticalRuler.setSelectionRect(rect);
    }

    public boolean addUnitListener(IRulerListener e) {
        return this.listeners.add(e);
    }

    public boolean removeUnitListener(IRulerListener o) {
        return this.listeners.remove(o);
    }

    public void setZoomLevel(double zoomLevel) {
        this.horizontalRuler.setZoomLevel(zoomLevel);
        this.verticalRuler.setZoomLevel(zoomLevel);
    }

    public void setMetric(boolean isMetric) {
        if (isMetric) {
            this.horizontalRuler.setIsMetric(true);
            this.verticalRuler.setIsMetric(true);
            this.unitButton.setText("cm");
        } else {
            this.horizontalRuler.setIsMetric(false);
            this.verticalRuler.setIsMetric(false);
            this.unitButton.setText("in");
        }
        for (IRulerListener listener : this.listeners) {
            listener.unitsChanged(isMetric);
        }
    }

    protected void updateRulerSize(int width, int height) {
        this.horizontalRuler.setPreferredWidth(width);
        this.horizontalRuler.invalidate();
        this.verticalRuler.setPreferredHeight(height);
        this.verticalRuler.invalidate();
    }

    class Corner
    extends JComponent {
        private static final long serialVersionUID = 1L;
        private final int orientation;

        public Corner(int orientation) {
            this.orientation = orientation;
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(Ruler.COLOR);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            if (this.orientation == 0) {
                g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            } else if (this.orientation == 1) {
                g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }
}

