/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.canvas;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.appframework.miscutils.IConfigListener;
import org.diylc.common.BadPositionException;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.core.ExpansionMode;
import org.diylc.core.IDIYComponent;
import org.diylc.core.Template;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.images.IconLoader;
import org.diylc.swing.ActionFactory;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.plugins.canvas.CanvasPanel;
import org.diylc.swing.plugins.edit.ComponentTransferable;
import org.diylc.swing.plugins.file.ProjectDrawingProvider;
import org.diylc.swingframework.IDrawingProvider;
import org.diylc.swingframework.ruler.IRulerListener;
import org.diylc.swingframework.ruler.RulerScrollPane;

public class CanvasPlugin
implements IPlugIn,
ClipboardOwner {
    private static final Logger LOG = Logger.getLogger(CanvasPlugin.class);
    private RulerScrollPane scrollPane;
    private CanvasPanel canvasPanel;
    private JPopupMenu popupMenu;
    private JMenu selectionMenu;
    private JMenu expandMenu;
    private JMenu applyTemplateMenu;
    private ActionFactory.CutAction cutAction;
    private ActionFactory.CopyAction copyAction;
    private ActionFactory.PasteAction pasteAction;
    private ActionFactory.EditSelectionAction editSelectionAction;
    private ActionFactory.DeleteSelectionAction deleteSelectionAction;
    private ActionFactory.SaveAsTemplateAction saveAsTemplateAction;
    private ActionFactory.GroupAction groupAction;
    private ActionFactory.UngroupAction ungroupAction;
    private ActionFactory.SendToBackAction sendToBackAction;
    private ActionFactory.BringToFrontAction bringToFrontAction;
    private ActionFactory.ExpandSelectionAction expandSelectionAllAction;
    private ActionFactory.ExpandSelectionAction expandSelectionImmediateAction;
    private ActionFactory.ExpandSelectionAction expandSelectionSameTypeAction;
    private ActionFactory.RotateSelectionAction rotateClockwiseAction;
    private ActionFactory.RotateSelectionAction rotateCounterclockwiseAction;
    private IPlugInPort plugInPort;
    private ISwingUI swingUI;
    private Clipboard clipboard;
    private double zoomLevel = 1.0;

    public CanvasPlugin(ISwingUI iSwingUI) {
        this.swingUI = iSwingUI;
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        try {
            this.swingUI.injectGUIComponent((JComponent)this.getScrollPane(), 0);
        }
        catch (BadPositionException badPositionException) {
            LOG.error((Object)"Could not install canvas plugin", (Throwable)badPositionException);
        }
    }

    public CanvasPanel getCanvasPanel() {
        if (this.canvasPanel == null) {
            this.canvasPanel = new CanvasPanel(this.plugInPort);
            this.canvasPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    CanvasPlugin.this.canvasPanel.requestFocus();
                    this.mouseReleased(mouseEvent);
                }

                @Override
                public void mouseReleased(final MouseEvent mouseEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (CanvasPlugin.this.plugInPort.getNewComponentTypeSlot() == null && mouseEvent.isPopupTrigger()) {
                                boolean bl = !CanvasPlugin.this.plugInPort.getSelectedComponents().isEmpty();
                                CanvasPlugin.this.getCutAction().setEnabled(bl);
                                CanvasPlugin.this.getCopyAction().setEnabled(bl);
                                try {
                                    CanvasPlugin.this.getPasteAction().setEnabled(CanvasPlugin.this.clipboard.isDataFlavorAvailable(ComponentTransferable.listFlavor));
                                }
                                catch (Exception exception) {
                                    CanvasPlugin.this.getPasteAction().setEnabled(false);
                                }
                                CanvasPlugin.this.getEditSelectionAction().setEnabled(bl);
                                CanvasPlugin.this.getDeleteSelectionAction().setEnabled(bl);
                                CanvasPlugin.this.getExpandSelectionAllAction().setEnabled(bl);
                                CanvasPlugin.this.getExpandSelectionImmediateAction().setEnabled(bl);
                                CanvasPlugin.this.getExpandSelectionSameTypeAction().setEnabled(bl);
                                CanvasPlugin.this.getGroupAction().setEnabled(bl);
                                CanvasPlugin.this.getUngroupAction().setEnabled(bl);
                                CanvasPlugin.this.getSendToBackAction().setEnabled(bl);
                                CanvasPlugin.this.getBringToFrontAction().setEnabled(bl);
                                CanvasPlugin.this.getSaveAsTemplateAction().setEnabled(CanvasPlugin.this.plugInPort.getSelectedComponents().size() == 1);
                                CanvasPlugin.this.showPopupAt(mouseEvent.getX(), mouseEvent.getY());
                            }
                        }
                    });
                }
            });
            this.canvasPanel.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (CanvasPlugin.this.plugInPort.keyPressed(keyEvent.getKeyCode(), keyEvent.isControlDown(), keyEvent.isShiftDown(), keyEvent.isAltDown())) {
                        keyEvent.consume();
                    }
                }
            });
            this.canvasPanel.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    CanvasPlugin.this.canvasPanel.setCursor(CanvasPlugin.this.plugInPort.getCursorAt(mouseEvent.getPoint()));
                    CanvasPlugin.this.plugInPort.mouseMoved(mouseEvent.getPoint(), mouseEvent.isControlDown(), mouseEvent.isShiftDown(), mouseEvent.isAltDown());
                }
            });
            this.canvasPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    CanvasPlugin.this.plugInPort.mouseClicked(mouseEvent.getPoint(), mouseEvent.getButton(), mouseEvent.isControlDown(), mouseEvent.isShiftDown(), mouseEvent.isAltDown(), mouseEvent.getClickCount());
                }
            });
        }
        return this.canvasPanel;
    }

    private RulerScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new RulerScrollPane((Component)this.getCanvasPanel(), (IDrawingProvider)new ProjectDrawingProvider(this.plugInPort, true, false), new Size(Double.valueOf(1.0), SizeUnit.cm).convertToPixels(), new Size(Double.valueOf(1.0), SizeUnit.in).convertToPixels());
            boolean bl = ConfigurationManager.getInstance().readBoolean("metric", true);
            boolean bl2 = ConfigurationManager.getInstance().readBoolean("wheelZoom", false);
            ConfigurationManager.getInstance().addConfigListener("wheelZoom", new IConfigListener(){

                public void valueChanged(String string, Object object) {
                    CanvasPlugin.this.scrollPane.setWheelScrollingEnabled((Boolean)object == false);
                }
            });
            this.scrollPane.setMetric(bl);
            this.scrollPane.setWheelScrollingEnabled(!bl2);
            this.scrollPane.addUnitListener(new IRulerListener(){

                public void unitsChanged(boolean bl) {
                    CanvasPlugin.this.plugInPort.setMetric(bl);
                }
            });
            this.scrollPane.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    boolean bl = ConfigurationManager.getInstance().readBoolean("wheelZoom", false);
                    if (!bl) {
                        return;
                    }
                    double d = CanvasPlugin.this.plugInPort.getZoomLevel();
                    Double[] doubleArray = CanvasPlugin.this.plugInPort.getAvailableZoomLevels();
                    if (mouseWheelEvent.getWheelRotation() > 0) {
                        int n;
                        for (n = doubleArray.length - 1; n > 0 && doubleArray[n] >= d; --n) {
                        }
                        CanvasPlugin.this.plugInPort.setZoomLevel(doubleArray[n].doubleValue());
                    } else {
                        int n;
                        for (n = 0; n < doubleArray.length - 1 && doubleArray[n] <= d; ++n) {
                        }
                        CanvasPlugin.this.plugInPort.setZoomLevel(doubleArray[n].doubleValue());
                    }
                }
            });
        }
        return this.scrollPane;
    }

    private void showPopupAt(int n, int n2) {
        this.updateSelectionMenu(n, n2);
        this.updateApplyTemplateMenu();
        this.getPopupMenu().show(this.canvasPanel, n, n2);
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.getSelectionMenu());
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.getCutAction());
            this.popupMenu.add(this.getCopyAction());
            this.popupMenu.add(this.getPasteAction());
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.getEditSelectionAction());
            this.popupMenu.add(this.getDeleteSelectionAction());
            this.popupMenu.add(this.getRotateClockwiseAction());
            this.popupMenu.add(this.getRotateCounterclockwiseAction());
            this.popupMenu.add(this.getGroupAction());
            this.popupMenu.add(this.getUngroupAction());
            this.popupMenu.add(this.getSendToBackAction());
            this.popupMenu.add(this.getBringToFrontAction());
            this.popupMenu.add(this.getSaveAsTemplateAction());
            this.popupMenu.add(this.getApplyTemplateMenu());
            this.popupMenu.add(this.getExpandMenu());
            this.popupMenu.addSeparator();
            this.popupMenu.add(ActionFactory.getInstance().createEditProjectAction(this.plugInPort));
        }
        return this.popupMenu;
    }

    public JMenu getSelectionMenu() {
        if (this.selectionMenu == null) {
            this.selectionMenu = new JMenu("Select");
            this.selectionMenu.setIcon(IconLoader.ElementsSelection.getIcon());
        }
        return this.selectionMenu;
    }

    public JMenu getExpandMenu() {
        if (this.expandMenu == null) {
            this.expandMenu = new JMenu("Expand Selection");
            this.expandMenu.setIcon(IconLoader.BranchAdd.getIcon());
            this.expandMenu.add(this.getExpandSelectionAllAction());
            this.expandMenu.add(this.getExpandSelectionImmediateAction());
            this.expandMenu.add(this.getExpandSelectionSameTypeAction());
        }
        return this.expandMenu;
    }

    public JMenu getApplyTemplateMenu() {
        if (this.applyTemplateMenu == null) {
            this.applyTemplateMenu = new JMenu("Apply Template");
            this.applyTemplateMenu.setIcon(IconLoader.BriefcaseInto.getIcon());
        }
        return this.applyTemplateMenu;
    }

    private void updateSelectionMenu(int n, int n2) {
        this.getSelectionMenu().removeAll();
        for (IDIYComponent iDIYComponent : this.plugInPort.findComponentsAt(new Point(n, n2))) {
            JMenuItem jMenuItem = new JMenuItem(iDIYComponent.getName());
            final IDIYComponent iDIYComponent2 = iDIYComponent;
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ArrayList<IDIYComponent> arrayList = new ArrayList<IDIYComponent>();
                    arrayList.add(iDIYComponent2);
                    CanvasPlugin.this.plugInPort.updateSelection(arrayList);
                    CanvasPlugin.this.plugInPort.refresh();
                }
            });
            this.getSelectionMenu().add(jMenuItem);
        }
    }

    private void updateApplyTemplateMenu() {
        this.getApplyTemplateMenu().removeAll();
        List list = null;
        try {
            list = this.plugInPort.getTemplatesForSelection();
        }
        catch (Exception exception) {
            LOG.info((Object)"Could not get templates for selection");
            this.getApplyTemplateMenu().setEnabled(false);
        }
        if (list == null) {
            return;
        }
        this.getApplyTemplateMenu().setEnabled(list.size() > 0);
        for (Template template : list) {
            JMenuItem jMenuItem = new JMenuItem(template.getName());
            final Template template2 = template;
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CanvasPlugin.this.plugInPort.applyTemplateToSelection(template2);
                }
            });
            this.getApplyTemplateMenu().add(jMenuItem);
        }
    }

    public ActionFactory.CutAction getCutAction() {
        if (this.cutAction == null) {
            this.cutAction = ActionFactory.getInstance().createCutAction(this.plugInPort, this.clipboard, this);
        }
        return this.cutAction;
    }

    public ActionFactory.CopyAction getCopyAction() {
        if (this.copyAction == null) {
            this.copyAction = ActionFactory.getInstance().createCopyAction(this.plugInPort, this.clipboard, this);
        }
        return this.copyAction;
    }

    public ActionFactory.PasteAction getPasteAction() {
        if (this.pasteAction == null) {
            this.pasteAction = ActionFactory.getInstance().createPasteAction(this.plugInPort, this.clipboard);
        }
        return this.pasteAction;
    }

    public ActionFactory.EditSelectionAction getEditSelectionAction() {
        if (this.editSelectionAction == null) {
            this.editSelectionAction = ActionFactory.getInstance().createEditSelectionAction(this.plugInPort);
        }
        return this.editSelectionAction;
    }

    public ActionFactory.DeleteSelectionAction getDeleteSelectionAction() {
        if (this.deleteSelectionAction == null) {
            this.deleteSelectionAction = ActionFactory.getInstance().createDeleteSelectionAction(this.plugInPort);
        }
        return this.deleteSelectionAction;
    }

    public ActionFactory.RotateSelectionAction getRotateClockwiseAction() {
        if (this.rotateClockwiseAction == null) {
            this.rotateClockwiseAction = ActionFactory.getInstance().createRotateSelectionAction(this.plugInPort, 1);
        }
        return this.rotateClockwiseAction;
    }

    public ActionFactory.RotateSelectionAction getRotateCounterclockwiseAction() {
        if (this.rotateCounterclockwiseAction == null) {
            this.rotateCounterclockwiseAction = ActionFactory.getInstance().createRotateSelectionAction(this.plugInPort, -1);
        }
        return this.rotateCounterclockwiseAction;
    }

    public ActionFactory.SaveAsTemplateAction getSaveAsTemplateAction() {
        if (this.saveAsTemplateAction == null) {
            this.saveAsTemplateAction = ActionFactory.getInstance().createSaveAsTemplateAction(this.plugInPort);
        }
        return this.saveAsTemplateAction;
    }

    public ActionFactory.GroupAction getGroupAction() {
        if (this.groupAction == null) {
            this.groupAction = ActionFactory.getInstance().createGroupAction(this.plugInPort);
        }
        return this.groupAction;
    }

    public ActionFactory.UngroupAction getUngroupAction() {
        if (this.ungroupAction == null) {
            this.ungroupAction = ActionFactory.getInstance().createUngroupAction(this.plugInPort);
        }
        return this.ungroupAction;
    }

    public ActionFactory.SendToBackAction getSendToBackAction() {
        if (this.sendToBackAction == null) {
            this.sendToBackAction = ActionFactory.getInstance().createSendToBackAction(this.plugInPort);
        }
        return this.sendToBackAction;
    }

    public ActionFactory.BringToFrontAction getBringToFrontAction() {
        if (this.bringToFrontAction == null) {
            this.bringToFrontAction = ActionFactory.getInstance().createBringToFrontAction(this.plugInPort);
        }
        return this.bringToFrontAction;
    }

    public ActionFactory.ExpandSelectionAction getExpandSelectionAllAction() {
        if (this.expandSelectionAllAction == null) {
            this.expandSelectionAllAction = ActionFactory.getInstance().createExpandSelectionAction(this.plugInPort, ExpansionMode.ALL);
        }
        return this.expandSelectionAllAction;
    }

    public ActionFactory.ExpandSelectionAction getExpandSelectionImmediateAction() {
        if (this.expandSelectionImmediateAction == null) {
            this.expandSelectionImmediateAction = ActionFactory.getInstance().createExpandSelectionAction(this.plugInPort, ExpansionMode.IMMEDIATE);
        }
        return this.expandSelectionImmediateAction;
    }

    public ActionFactory.ExpandSelectionAction getExpandSelectionSameTypeAction() {
        if (this.expandSelectionSameTypeAction == null) {
            this.expandSelectionSameTypeAction = ActionFactory.getInstance().createExpandSelectionAction(this.plugInPort, ExpansionMode.SAME_TYPE);
        }
        return this.expandSelectionSameTypeAction;
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return EnumSet.of(EventType.PROJECT_LOADED, EventType.ZOOM_CHANGED, EventType.REPAINT);
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
        switch (eventType) {
            case PROJECT_LOADED: {
                this.refreshSize();
                if (!((Boolean)objectArray[1]).booleanValue()) break;
                Rectangle rectangle = this.canvasPanel.getVisibleRect();
                rectangle.setLocation((this.canvasPanel.getWidth() - rectangle.width) / 2, (this.canvasPanel.getHeight() - rectangle.height) / 2);
                this.canvasPanel.scrollRectToVisible(rectangle);
                this.canvasPanel.revalidate();
                break;
            }
            case ZOOM_CHANGED: {
                Rectangle rectangle = this.canvasPanel.getVisibleRect();
                this.refreshSize();
                double d = (Double)objectArray[0] / this.zoomLevel;
                rectangle.setBounds((int)((double)rectangle.x * d), (int)((double)rectangle.y * d), rectangle.width, rectangle.height);
                this.canvasPanel.scrollRectToVisible(rectangle);
                this.canvasPanel.revalidate();
                this.zoomLevel = (Double)objectArray[0];
                break;
            }
            case REPAINT: {
                this.canvasPanel.repaint();
            }
        }
    }

    private void refreshSize() {
        Dimension dimension = this.plugInPort.getCanvasDimensions(true);
        this.canvasPanel.setSize(dimension);
        this.canvasPanel.setPreferredSize(dimension);
        this.getScrollPane().setZoomLevel(this.plugInPort.getZoomLevel());
    }

    public void refresh() {
        MouseEvent mouseEvent = new MouseEvent(this.canvasPanel, 503, System.currentTimeMillis(), 0, 1, 1, 0, false);
        this.canvasPanel.dispatchEvent(mouseEvent);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

