/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.CubicCurve2D;
import org.diylc.common.ObjectCache;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

public abstract class AbstractCurvedComponent<T>
extends AbstractTransparentComponent<T> {
    private static final long serialVersionUID = 1L;
    public static Color GUIDELINE_COLOR = Color.blue;
    public static Size DEFAULT_SIZE = new Size((Double)1.0, SizeUnit.in);
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point((int)(DEFAULT_SIZE.convertToPixels() / 2.0), 0), new Point((int)(DEFAULT_SIZE.convertToPixels() / 2.0), (int)DEFAULT_SIZE.convertToPixels()), new Point((int)DEFAULT_SIZE.convertToPixels(), (int)DEFAULT_SIZE.convertToPixels())};
    protected Color color = this.getDefaultColor();
    protected PointCount pointCount = PointCount.FOUR;

    protected abstract void drawCurve(CubicCurve2D var1, Graphics2D var2, ComponentState var3);

    protected abstract Color getDefaultColor();

    @Override
    public void drawIcon(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(this.getDefaultColor().darker());
        graphics2D.setStroke(ObjectCache.getInstance().fetchBasicStroke(3));
        CubicCurve2D.Double double_ = new CubicCurve2D.Double(1.0, n2 - 1, n / 4, n2 / 3, 3 * n / 4, 2 * n2 / 3, n - 1, 1.0);
        graphics2D.draw(double_);
        graphics2D.setColor(this.getDefaultColor());
        graphics2D.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        graphics2D.draw(double_);
    }

    @Override
    public void draw(Graphics2D graphics2D, ComponentState componentState, boolean bl, Project project, IDrawingObserver iDrawingObserver) {
        if (this.checkPointsClipped(graphics2D.getClip())) {
            return;
        }
        if (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING) {
            iDrawingObserver.stopTracking();
            graphics2D.setStroke(Constants.DASHED_STROKE);
            graphics2D.setColor(GUIDELINE_COLOR);
            graphics2D.drawLine(this.controlPoints[0].x, this.controlPoints[0].y, this.controlPoints[1].x, this.controlPoints[1].y);
            graphics2D.drawLine(this.controlPoints[1].x, this.controlPoints[1].y, this.controlPoints[2].x, this.controlPoints[2].y);
            graphics2D.drawLine(this.controlPoints[2].x, this.controlPoints[2].y, this.controlPoints[3].x, this.controlPoints[3].y);
            iDrawingObserver.startTracking();
        }
        CubicCurve2D.Double double_ = new CubicCurve2D.Double(this.controlPoints[0].x, this.controlPoints[0].y, this.controlPoints[1].x, this.controlPoints[1].y, this.controlPoints[2].x, this.controlPoints[2].y, this.controlPoints[3].x, this.controlPoints[3].y);
        Composite composite = graphics2D.getComposite();
        if (this.alpha < MAX_ALPHA) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        this.drawCurve(double_, graphics2D, componentState);
        graphics2D.setComposite(composite);
    }

    @EditableProperty(name="Point Count")
    public PointCount getPointCount() {
        if (this.pointCount == null) {
            this.pointCount = PointCount.FOUR;
        }
        return this.pointCount;
    }

    public void setPointCount(PointCount pointCount) {
        this.pointCount = pointCount;
        for (int i = 0; i < this.getControlPointCount(); ++i) {
            this.setControlPoint(this.getControlPoint(i), i);
        }
    }

    @Override
    public int getControlPointCount() {
        switch (this.getPointCount()) {
            case TWO: {
                return 2;
            }
            case THREE: {
                return 3;
            }
            case FOUR: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public boolean isControlPointSticky(int n) {
        return n == 0 || n == this.getControlPointCount() - 1;
    }

    @Override
    public VisibilityPolicy getControlPointVisibilityPolicy(int n) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    @Override
    public boolean canControlPointOverlap(int n) {
        switch (this.getPointCount()) {
            case TWO: {
                return false;
            }
            case THREE: {
                return n == 1;
            }
            case FOUR: {
                return n == 1 || n == 2;
            }
        }
        return false;
    }

    @Override
    public Point getControlPoint(int n) {
        if (n == 0) {
            return this.controlPoints[0];
        }
        switch (this.getPointCount()) {
            case TWO: {
                switch (n) {
                    case 1: {
                        return this.controlPoints[3];
                    }
                }
            }
            case THREE: {
                switch (n) {
                    case 1: {
                        return this.controlPoints[1];
                    }
                    case 2: {
                        return this.controlPoints[3];
                    }
                }
            }
            case FOUR: {
                switch (n) {
                    case 1: {
                        return this.controlPoints[1];
                    }
                    case 2: {
                        return this.controlPoints[2];
                    }
                    case 3: {
                        return this.controlPoints[3];
                    }
                }
            }
        }
        return this.controlPoints[n];
    }

    @Override
    public void setControlPoint(Point point, int n) {
        if (n == 0) {
            this.controlPoints[0].setLocation(point);
        } else {
            block0 : switch (this.getPointCount()) {
                case TWO: {
                    switch (n) {
                        case 1: {
                            Point point2 = new Point((point.x + this.controlPoints[0].x) / 2, (point.y + this.controlPoints[0].y) / 2);
                            this.controlPoints[1].setLocation(point2);
                            this.controlPoints[2].setLocation(point2);
                            this.controlPoints[3].setLocation(point);
                        }
                    }
                    break;
                }
                case THREE: {
                    switch (n) {
                        case 1: {
                            this.controlPoints[1].setLocation(point);
                            this.controlPoints[2].setLocation(point);
                            break;
                        }
                        case 2: {
                            this.controlPoints[3].setLocation(point);
                        }
                    }
                    break;
                }
                case FOUR: {
                    switch (n) {
                        case 1: {
                            this.controlPoints[1].setLocation(point);
                            break block0;
                        }
                        case 2: {
                            this.controlPoints[2].setLocation(point);
                            break block0;
                        }
                        case 3: {
                            this.controlPoints[3].setLocation(point);
                        }
                    }
                }
            }
        }
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    static enum PointCount {
        TWO,
        THREE,
        FOUR;


        public String toString() {
            return this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
        }
    }
}

