/*****
 NAME
 	dconststr.h - constant string definition file
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 DESCRIPTION
 	This file defines the constant string used by this class library
	and the applications. The real definition (not extern) is done
	in "csystem.m".
 */

#if !defined(DCONSTSTR_H_INCLUDED)
#define DCONSTSTR_H_INCLUDED

#if !defined(EXTERN)
#	define	EXTERN(NAME, STR)	extern const char NAME[] 
#endif

EXTERN(EMPTY_STR, "") ;
EXTERN(HYPHEN_STR, "-") ;

EXTERN(ACCESS_STR, "access") ;
EXTERN(ARROW_STR, "arrow") ;
EXTERN(BUTTON_STR, "button") ;
EXTERN(CHECK_BUTTON_STR, "check_button") ;
EXTERN(CONTAINER_STR, "container") ;
EXTERN(ENV_STR, "env") ;
EXTERN(ERROR_STR, "error") ;
EXTERN(EXIT_STR, "exit") ;
EXTERN(FALSE_STR, "false") ;
EXTERN(FLAG_STR, "flag") ;
EXTERN(FORMAT_STR, "format") ;
EXTERN(FRAME_STR, "frame") ;
EXTERN(IN_STR, "in") ;
EXTERN(LABEL_STR, "label") ;
EXTERN(NAME_STR, "name") ;
EXTERN(NO_STR, "no") ;
EXTERN(NONE_STR, "none") ;
EXTERN(OUT_STR, "out") ;
EXTERN(PRINT_STR, "print") ;
EXTERN(READ_STR, "read") ;
EXTERN(SCRIPT_STR, "script") ;
EXTERN(SEPARATOR_STR, "separator") ;
EXTERN(STRING_STR, "string") ;
EXTERN(TITLE_STR, "title") ;
EXTERN(TRUE_STR, "true") ;
EXTERN(UNKNOWN_STR, "unknown") ;
EXTERN(VALUE_STR, "value") ;
EXTERN(WARNING_STR, "warning") ;
EXTERN(WINDOW_STR, "window") ;
EXTERN(WRITE_STR, "write") ;
EXTERN(YES_STR, "yes") ;

EXTERN(STDIN_STR, "<stdin>") ;
EXTERN(STDOUT_STR, "<stdout>") ;
EXTERN(STDIO_STR, "<stdio>");
EXTERN(UNKNOWN_NAME_STR, "<unknown>") ;

EXTERN(TEMP_FILE_NAME_STR, "coconut_tmp_file_XXXXXX") ;

#undef	EXTERN

#endif /* !defined(DCONSTSTR_H_INCLUDED) */

