/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.utils;

import edu.umd.marbl.mhap.impl.MhapRuntimeException;
import edu.umd.marbl.mhap.utils.MersenneTwisterFast;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public final class RandomSequenceGenerator {
    private MersenneTwisterFast randGenerator;

    public RandomSequenceGenerator() {
        this.randGenerator = new MersenneTwisterFast();
    }

    public RandomSequenceGenerator(int seed) {
        this.randGenerator = new MersenneTwisterFast(seed);
    }

    private final char getRandomBase(Character toExclude) {
        Character result = null;
        while (result == null) {
            double base = this.randGenerator.nextDouble();
            result = base < 0.25 ? Character.valueOf('A') : (base < 0.5 ? Character.valueOf('C') : (base < 0.75 ? Character.valueOf('G') : Character.valueOf('T')));
            if (toExclude == null || !toExclude.equals(result)) continue;
            result = null;
        }
        return result.charValue();
    }

    public String generateRandomSequence(int length) {
        StringBuilder str = new StringBuilder(length);
        for (int iter = 0; iter < length; ++iter) {
            str.append(this.getRandomBase(null));
        }
        return str.toString();
    }

    public String addPacBioError(String str) {
        return this.addError(str, 0.1188, 0.0183, 0.0129);
    }

    public String addError(String str, double insertionRate, double deletionRate, double substitutionRate) {
        if (insertionRate < 0.0 || deletionRate < 0.0 || substitutionRate < 0.0) {
            throw new MhapRuntimeException("Error rate cannot be negative.");
        }
        if (insertionRate + deletionRate + substitutionRate > 1.00001) {
            throw new MhapRuntimeException("Error rate must be less than or equal to 1.0.");
        }
        double errorRate = insertionRate + deletionRate + substitutionRate;
        LinkedList<Character> modifiedSequence = new LinkedList<Character>();
        for (char a : str.toCharArray()) {
            modifiedSequence.add(Character.valueOf(a));
        }
        ListIterator<Character> iter = modifiedSequence.listIterator();
        while (iter.hasNext()) {
            char i = ((Character)iter.next()).charValue();
            if (!(this.randGenerator.nextDouble() < errorRate)) continue;
            double errorType = this.randGenerator.nextDouble();
            if (errorType < substitutionRate) {
                iter.set(Character.valueOf(this.getRandomBase(Character.valueOf(i))));
                i = (char)(i + '\u0001');
                continue;
            }
            if (errorType < insertionRate + substitutionRate) {
                iter.previous();
                iter.add(Character.valueOf(this.getRandomBase(null)));
                continue;
            }
            iter.remove();
        }
        StringBuilder returnedString = new StringBuilder(modifiedSequence.size());
        Iterator iterator = modifiedSequence.iterator();
        while (iterator.hasNext()) {
            char c = ((Character)iterator.next()).charValue();
            returnedString.append(c);
        }
        return returnedString.toString();
    }
}

