/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.sketch.AbstractBitSketch;
import edu.umd.marbl.mhap.sketch.HashUtils;

public final class SimHash
extends AbstractBitSketch<SimHash> {
    private static final long serialVersionUID = -2655482279264410602L;

    private static final long[] recordHashes(long[][] hashes, int numWords) {
        int[] counts = new int[numWords * 64];
        for (long[] objectHashes : hashes) {
            for (int wordIndex = 0; wordIndex < numWords; ++wordIndex) {
                long val = objectHashes[wordIndex];
                int offset = wordIndex * 64;
                long mask = 1L;
                for (int bit = 0; bit < 64; ++bit) {
                    if ((val & mask) == 0L) {
                        int n = offset + bit;
                        counts[n] = counts[n] - 1;
                    } else {
                        int n = offset + bit;
                        counts[n] = counts[n] + 1;
                    }
                    mask <<= 1;
                }
            }
        }
        long[] bits = new long[numWords];
        for (int wordIndex = 0; wordIndex < numWords; ++wordIndex) {
            int offset = wordIndex * 64;
            long val = 0L;
            long mask = 1L;
            for (int bit = 0; bit < 64; ++bit) {
                if (counts[offset + bit] > 0) {
                    val |= mask;
                }
                mask <<= 1;
            }
            bits[wordIndex] = val;
        }
        return bits;
    }

    public SimHash(String string, int nGramSize, int numberWords) {
        super(SimHash.recordHashes(HashUtils.computeNGramHashesExact(string, nGramSize, numberWords, 0), numberWords));
    }

    public final double jaccard(SimHash sh) {
        int count = this.getIntersectionCount(sh);
        double sim = (double)count / (double)this.numberOfBits();
        double jaccard = (sim - 0.5) * 2.0;
        return Math.max(0.0, jaccard);
    }
}

