/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Optional;
import java.io.IOException;

public class Throwables {
    public static Throwable merge(Throwable existingFail, Throwable newFail) {
        if (existingFail == null) {
            return newFail;
        }
        existingFail.addSuppressed(newFail);
        return existingFail;
    }

    public static void maybeFail(Throwable fail) {
        if (fail != null) {
            com.google.common.base.Throwables.propagate((Throwable)fail);
        }
    }

    public static Throwable close(Throwable accumulate, Iterable<? extends AutoCloseable> closeables) {
        for (AutoCloseable autoCloseable : closeables) {
            try {
                autoCloseable.close();
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        return accumulate;
    }

    public static Optional<IOException> extractIOExceptionCause(Throwable t) {
        if (t instanceof IOException) {
            return Optional.of((Object)((IOException)t));
        }
        Throwable cause = t;
        while ((cause = cause.getCause()) != null) {
            if (!(cause instanceof IOException)) continue;
            return Optional.of((Object)((IOException)cause));
        }
        return Optional.absent();
    }
}

