/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.jersey.cfg;

import org.apache.zookeeper.server.jersey.cfg.Credentials;
import org.apache.zookeeper.server.jersey.cfg.HostPortSet;

public class Endpoint {
    private String context;
    private HostPortSet hostPort;
    private Credentials credentials;
    private Credentials zookeeperAuth;

    public Endpoint(String context, String hostPortList) {
        this.context = context;
        this.hostPort = new HostPortSet(hostPortList);
    }

    public String getContext() {
        return this.context;
    }

    public String getHostPort() {
        return this.hostPort.toString();
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String c) {
        this.credentials = new Credentials(c);
    }

    public void setZooKeeperAuthInfo(String digest) {
        this.zookeeperAuth = new Credentials(digest);
    }

    public final Credentials getZooKeeperAuthInfo() {
        return this.zookeeperAuth;
    }

    public boolean equals(Object o) {
        Endpoint e = (Endpoint)o;
        return this.context.equals(e.context);
    }

    public int hashCode() {
        return this.context.hashCode();
    }

    public String toString() {
        return String.format("<Endpoint %s %s>", this.context, this.hostPort.toString());
    }
}

