/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.PathGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupInterface;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;

public class TestStringTemplate
extends TestCase {
    static final String newline = System.getProperty("line.separator");

    public static void assertEquals(String expected, String actual) {
        Assert.assertEquals((String)expected.replaceAll("\r\n", "\n"), (String)actual.replaceAll("\r\n", "\n"));
    }

    public void testInterfaceFileFormat() throws Exception {
        String groupI = "interface test;" + newline + "t();" + newline + "bold(item);" + newline + "optional duh(a,b,c);" + newline;
        StringTemplateGroupInterface I = new StringTemplateGroupInterface(new StringReader(groupI));
        String expecting = "interface test;\nt();\nbold(item);\noptional duh(a, b, c);\n";
        TestStringTemplate.assertEquals(expecting, I.toString());
    }

    public void testNoGroupLoader() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        String templates = "group testG implements blort;" + newline + "t() ::= <<foo>>" + newline + "bold(item) ::= <<foo>>" + newline + "duh(a,b,c) ::= <<foo>>" + newline;
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        new StringTemplateGroup((Reader)new FileReader(tmpdir + "/testG.stg"), errors);
        String expecting = "no group loader registered";
        TestStringTemplate.assertEquals(expecting, ((Object)errors).toString());
    }

    public void testCannotFindInterfaceFile() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir, errors));
        String templates = "group testG implements blort;" + newline + "t() ::= <<foo>>" + newline + "bold(item) ::= <<foo>>" + newline + "duh(a,b,c) ::= <<foo>>" + newline;
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        new StringTemplateGroup((Reader)new FileReader(tmpdir + "/testG.stg"), errors);
        String expecting = "no such interface file blort.sti";
        TestStringTemplate.assertEquals(expecting, ((Object)errors).toString());
    }

    public void testMultiDirGroupLoading() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (!new File(tmpdir + "/sub").exists() && !new File(tmpdir + "/sub").mkdir()) {
            System.err.println("can't make subdir in test");
            return;
        }
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir + ":" + tmpdir + "/sub", errors));
        String templates = "group testG2;" + newline + "t() ::= <<foo>>" + newline + "bold(item) ::= <<foo>>" + newline + "duh(a,b,c) ::= <<foo>>" + newline;
        TestStringTemplate.writeFile(tmpdir + "/sub", "testG2.stg", templates);
        StringTemplateGroup group = StringTemplateGroup.loadGroup("testG2");
        String expecting = "group testG2;\nbold(item) ::= <<foo>>\nduh(a,b,c) ::= <<foo>>\nt() ::= <<foo>>\n";
        TestStringTemplate.assertEquals(expecting, group.toString());
    }

    public void testGroupSatisfiesSingleInterface() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir, errors));
        String groupI = "interface testI;" + newline + "t();" + newline + "bold(item);" + newline + "optional duh(a,b,c);" + newline;
        TestStringTemplate.writeFile(tmpdir, "testI.sti", groupI);
        String templates = "group testG implements testI;" + newline + "t() ::= <<foo>>" + newline + "bold(item) ::= <<foo>>" + newline + "duh(a,b,c) ::= <<foo>>" + newline;
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        new StringTemplateGroup((Reader)new FileReader(tmpdir + "/testG.stg"), errors);
        String expecting = "";
        TestStringTemplate.assertEquals(expecting, ((Object)errors).toString());
    }

    public void testGroupExtendsSuperGroup() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir, errors));
        String superGroup = "group superG;" + newline + "bold(item) ::= <<*$item$*>>;\n" + newline;
        TestStringTemplate.writeFile(tmpdir, "superG.stg", superGroup);
        String templates = "group testG : superG;" + newline + "main(x) ::= <<$bold(x)$>>" + newline;
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        StringTemplateGroup group = new StringTemplateGroup(new FileReader(tmpdir + "/testG.stg"), DefaultTemplateLexer.class, errors);
        StringTemplate st = group.getInstanceOf("main");
        st.setAttribute("x", "foo");
        String expecting = "*foo*";
        TestStringTemplate.assertEquals(expecting, st.toString());
    }

    public void testMissingInterfaceTemplate() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir, errors));
        String groupI = "interface testI;" + newline + "t();" + newline + "bold(item);" + newline + "optional duh(a,b,c);" + newline;
        TestStringTemplate.writeFile(tmpdir, "testI.sti", groupI);
        String templates = "group testG implements testI;" + newline + "t() ::= <<foo>>" + newline + "duh(a,b,c) ::= <<foo>>" + newline;
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        new StringTemplateGroup((Reader)new FileReader(tmpdir + "/testG.stg"), errors);
        String expecting = "group testG does not satisfy interface testI: missing templates [bold]";
        TestStringTemplate.assertEquals(expecting, ((Object)errors).toString());
    }

    public void testMissingOptionalInterfaceTemplate() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir, errors));
        String groupI = "interface testI;" + newline + "t();" + newline + "bold(item);" + newline + "optional duh(a,b,c);" + newline;
        TestStringTemplate.writeFile(tmpdir, "testI.sti", groupI);
        String templates = "group testG implements testI;" + newline + "t() ::= <<foo>>" + newline + "bold(item) ::= <<foo>>";
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        new StringTemplateGroup((Reader)new FileReader(tmpdir + "/testG.stg"), errors);
        String expecting = "";
        TestStringTemplate.assertEquals(expecting, ((Object)errors).toString());
    }

    public void testMismatchedInterfaceTemplate() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String tmpdir = System.getProperty("java.io.tmpdir");
        StringTemplateGroup.registerGroupLoader(new PathGroupLoader(tmpdir, errors));
        String groupI = "interface testI;" + newline + "t();" + newline + "bold(item);" + newline + "optional duh(a,b,c);" + newline;
        TestStringTemplate.writeFile(tmpdir, "testI.sti", groupI);
        String templates = "group testG implements testI;" + newline + "t() ::= <<foo>>" + newline + "bold(item) ::= <<foo>>" + newline + "duh(a,c) ::= <<foo>>" + newline;
        TestStringTemplate.writeFile(tmpdir, "testG.stg", templates);
        new StringTemplateGroup((Reader)new FileReader(tmpdir + "/testG.stg"), errors);
        String expecting = "group testG does not satisfy interface testI: mismatched arguments on these templates [optional duh(a, b, c)]";
        TestStringTemplate.assertEquals(expecting, ((Object)errors).toString());
    }

    public void testGroupFileFormat() throws Exception {
        String templates = "group test;" + newline + "t() ::= \"literal template\"" + newline + "bold(item) ::= \"<b>$item$</b>\"" + newline + "duh() ::= <<" + newline + "xx" + newline + ">>" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        String expecting = "group test;" + newline + "bold(item) ::= <<<b>$item$</b>>>" + newline + "duh() ::= <<xx>>" + newline + "t() ::= <<literal template>>" + newline;
        TestStringTemplate.assertEquals(expecting, group.toString());
        StringTemplate a = group.getInstanceOf("t");
        expecting = "literal template";
        TestStringTemplate.assertEquals(expecting, a.toString());
        StringTemplate b = group.getInstanceOf("bold");
        b.setAttribute("item", "dork");
        expecting = "<b>dork</b>";
        TestStringTemplate.assertEquals(expecting, b.toString());
    }

    public void testEscapedTemplateDelimiters() throws Exception {
        String templates = "group test;" + newline + "t() ::= <<$\"literal\":{a|$a$\\}}$ template\n>>" + newline + "bold(item) ::= <<<b>$item$</b\\>>>" + newline + "duh() ::= <<" + newline + "xx" + newline + ">>" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        String expecting = "group test;" + newline + "bold(item) ::= <<<b>$item$</b>>>" + newline + "duh() ::= <<xx>>" + newline + "t() ::= <<$\"literal\":{a|$a$\\}}$ template>>" + newline;
        TestStringTemplate.assertEquals(expecting, group.toString());
        StringTemplate b = group.getInstanceOf("bold");
        b.setAttribute("item", "dork");
        expecting = "<b>dork</b>";
        TestStringTemplate.assertEquals(expecting, b.toString());
        StringTemplate a = group.getInstanceOf("t");
        expecting = "literal} template";
        TestStringTemplate.assertEquals(expecting, a.toString());
    }

    public void testTemplateParameterDecls() throws Exception {
        String templates = "group test;" + newline + "t() ::= \"no args but ref $foo$\"" + newline + "t2(item) ::= \"decl but not used is ok\"" + newline + "t3(a,b,c,d) ::= <<$a$ $d$>>" + newline + "t4(a,b,c,d) ::= <<$a$ $b$ $c$ $d$>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate a = group.getInstanceOf("t");
        String error = null;
        try {
            a.setAttribute("foo", "x");
        }
        catch (NoSuchElementException e) {
            error = e.getMessage();
        }
        String expecting = "no such attribute: foo in template context [t]";
        TestStringTemplate.assertEquals(expecting, error);
        a = group.getInstanceOf("t2");
        a.setAttribute("item", "x");
        a = group.getInstanceOf("t3");
        a.setAttribute("b", "x");
    }

    public void testTemplateRedef() throws Exception {
        String templates = "group test;" + newline + "a() ::= \"x\"" + newline + "b() ::= \"y\"" + newline + "a() ::= \"z\"" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        new StringTemplateGroup((Reader)new StringReader(templates), errors);
        String expecting = "redefinition of template: a";
        TestStringTemplate.assertEquals(expecting, ((Object)errors).toString());
    }

    public void testMissingInheritedAttribute() throws Exception {
        String templates = "group test;" + newline + "page(title,font) ::= <<" + newline + "<html>" + newline + "<body>" + newline + "$title$<br>" + newline + "$body()$" + newline + "</body>" + newline + "</html>" + newline + ">>" + newline + "body() ::= \"<font face=$font$>my body</font>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        t.setAttribute("title", "my title");
        t.setAttribute("font", "Helvetica");
        t.toString();
    }

    public void testFormalArgumentAssignment() throws Exception {
        String templates = "group test;" + newline + "page() ::= <<$body(font=\"Times\")$>>" + newline + "body(font) ::= \"<font face=$font$>my body</font>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        String expecting = "<font face=Times>my body</font>";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testUndefinedArgumentAssignment() throws Exception {
        String templates = "group test;" + newline + "page(x) ::= <<$body(font=x)$>>" + newline + "body() ::= \"<font face=$font$>my body</font>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        t.setAttribute("x", "Times");
        String error = "";
        try {
            t.toString();
        }
        catch (NoSuchElementException iae) {
            error = iae.getMessage();
        }
        String expecting = "template body has no such attribute: font in template context [page <invoke body arg context>]";
        TestStringTemplate.assertEquals(expecting, error);
    }

    public void testFormalArgumentAssignmentInApply() throws Exception {
        String templates = "group test;" + newline + "page(name) ::= <<$name:bold(font=\"Times\")$>>" + newline + "bold(font) ::= \"<font face=$font$><b>$it$</b></font>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        t.setAttribute("name", "Ter");
        String expecting = "<font face=Times><b>Ter</b></font>";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testUndefinedArgumentAssignmentInApply() throws Exception {
        String templates = "group test;" + newline + "page(name,x) ::= <<$name:bold(font=x)$>>" + newline + "bold() ::= \"<font face=$font$><b>$it$</b></font>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        t.setAttribute("x", "Times");
        t.setAttribute("name", "Ter");
        String error = "";
        try {
            t.toString();
        }
        catch (NoSuchElementException iae) {
            error = iae.getMessage();
        }
        String expecting = "template bold has no such attribute: font in template context [page <invoke bold arg context>]";
        TestStringTemplate.assertEquals(expecting, error);
    }

    public void testUndefinedAttributeReference() throws Exception {
        String templates = "group test;" + newline + "page() ::= <<$bold()$>>" + newline + "bold() ::= \"$name$\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        String error = "";
        try {
            t.toString();
        }
        catch (NoSuchElementException iae) {
            error = iae.getMessage();
        }
        String expecting = "no such attribute: name in template context [page bold]";
        TestStringTemplate.assertEquals(expecting, error);
    }

    public void testUndefinedDefaultAttributeReference() throws Exception {
        String templates = "group test;" + newline + "page() ::= <<$bold()$>>" + newline + "bold() ::= \"$it$\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate t = group.getInstanceOf("page");
        String error = "";
        try {
            t.toString();
        }
        catch (NoSuchElementException nse) {
            error = nse.getMessage();
        }
        String expecting = "no such attribute: it in template context [page bold]";
        TestStringTemplate.assertEquals(expecting, error);
    }

    public void testAngleBracketsWithGroupFile() throws Exception {
        String templates = "group test;" + newline + "a(s) ::= \"<s:{case <i> : <it> break;}>\"" + newline + "b(t) ::= \"<t; separator=\\\",\\\">\"" + newline + "c(t) ::= << <t; separator=\",\"> >>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate t = group.getInstanceOf("a");
        t.setAttribute("s", "Test");
        String expecting = "case 1 : Test break;";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testAngleBracketsNoGroup() throws Exception {
        StringTemplate st = new StringTemplate("Tokens : <rules; separator=\"|\"> ;", AngleBracketTemplateLexer.class);
        st.setAttribute("rules", "A");
        st.setAttribute("rules", "B");
        String expecting = "Tokens : A|B ;";
        TestStringTemplate.assertEquals(expecting, st.toString());
    }

    public void testRegionRef() throws Exception {
        String templates = "group test;" + newline + "a() ::= \"X$@r()$Y\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate st = group.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XY";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmbeddedRegionRef() throws Exception {
        String templates = "group test;" + newline + "a() ::= \"X$@r$blort$@end$Y\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate st = group.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XblortY";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testRegionRefAngleBrackets() throws Exception {
        String templates = "group test;" + newline + "a() ::= \"X<@r()>Y\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XY";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmbeddedRegionRefAngleBrackets() throws Exception {
        String templates = "group test;" + newline + "a() ::= \"X<@r>blort<@end>Y\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XblortY";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmbeddedRegionRefWithNewlinesAngleBrackets() throws Exception {
        String templates = "group test;" + newline + "a() ::= \"X<@r>" + newline + "blort" + newline + "<@end>" + newline + "Y\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XblortY";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testRegionRefWithDefAngleBrackets() throws Exception {
        String templates = "group test;" + newline + "a() ::= \"X<@r()>Y\"" + newline + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XfooY";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testRegionRefWithDefInConditional() throws Exception {
        String templates = "group test;" + newline + "a(v) ::= \"X<if(v)>A<@r()>B<endif>Y\"" + newline + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("a");
        st.setAttribute("v", "true");
        String result = st.toString();
        String expecting = "XAfooBY";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testRegionRefWithImplicitDefInConditional() throws Exception {
        String templates = "group test;" + newline + "a(v) ::= \"X<if(v)>A<@r>yo<@end>B<endif>Y\"" + newline + "@a.r() ::= \"foo\"" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), errors);
        StringTemplate st = group.getInstanceOf("a");
        st.setAttribute("v", "true");
        String result = st.toString();
        String expecting = "XAyoBY";
        TestStringTemplate.assertEquals(expecting, result);
        String err_result = ((Object)errors).toString();
        String err_expecting = "group test line 3: redefinition of template region: @a.r";
        TestStringTemplate.assertEquals(err_expecting, err_result);
    }

    public void testRegionOverride() throws Exception {
        String templates1 = "group super;" + newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + newline + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, null, group);
        StringTemplate st = subGroup.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XfooY";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testRegionOverrideRefSuperRegion() throws Exception {
        String templates1 = "group super;" + newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + newline + "@a.r() ::= \"A<@super.r()>B\"" + newline;
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, null, group);
        StringTemplate st = subGroup.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XAfooBY";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testRegionOverrideRefSuperRegion3Levels() throws Exception {
        String templates1 = "group super;" + newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + newline + "@a.r() ::= \"<@super.r()>2\"" + newline;
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, null, group);
        String templates3 = "group subsub;" + newline + "@a.r() ::= \"<@super.r()>3\"" + newline;
        StringTemplateGroup subSubGroup = new StringTemplateGroup(new StringReader(templates3), AngleBracketTemplateLexer.class, null, subGroup);
        StringTemplate st = subSubGroup.getInstanceOf("a");
        String result = st.toString();
        String expecting = "Xfoo23Y";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testRegionOverrideRefSuperImplicitRegion() throws Exception {
        String templates1 = "group super;" + newline + "a() ::= \"X<@r>foo<@end>Y\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + newline + "@a.r() ::= \"A<@super.r()>\"" + newline;
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, null, group);
        StringTemplate st = subGroup.getInstanceOf("a");
        String result = st.toString();
        String expecting = "XAfooY";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmbeddedRegionRedefError() throws Exception {
        String templates = "group test;" + newline + "a() ::= \"X<@r>dork<@end>Y\"" + "@a.r() ::= \"foo\"" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), errors);
        StringTemplate st = group.getInstanceOf("a");
        st.toString();
        String result = ((Object)errors).toString();
        String expecting = "group test line 2: redefinition of template region: @a.r";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testImplicitRegionRedefError() throws Exception {
        String templates = "group test;" + newline + "a() ::= \"X<@r()>Y\"" + newline + "@a.r() ::= \"foo\"" + newline + "@a.r() ::= \"bar\"" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), errors);
        StringTemplate st = group.getInstanceOf("a");
        st.toString();
        String result = ((Object)errors).toString();
        String expecting = "group test line 4: redefinition of template region: @a.r";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testImplicitOverriddenRegionRedefError() throws Exception {
        String templates1 = "group super;" + newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + newline + "@a.r() ::= \"foo\"" + newline + "@a.r() ::= \"bar\"" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, errors, group);
        subGroup.getInstanceOf("a");
        String result = ((Object)errors).toString();
        String expecting = "group sub line 3: redefinition of template region: @a.r";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testUnknownRegionDefError() throws Exception {
        String templates = "group test;" + newline + "a() ::= \"X<@r()>Y\"" + newline + "@a.q() ::= \"foo\"" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), errors);
        StringTemplate st = group.getInstanceOf("a");
        st.toString();
        String result = ((Object)errors).toString();
        String expecting = "group test line 3: template a has no region called q";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testSuperRegionRefError() throws Exception {
        String templates1 = "group super;" + newline + "a() ::= \"X<@r()>Y\"" + "@a.r() ::= \"foo\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + newline + "@a.r() ::= \"A<@super.q()>B\"" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, errors, group);
        subGroup.getInstanceOf("a");
        String result = ((Object)errors).toString();
        String expecting = "template a has no region called q";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMissingEndRegionError() throws Exception {
        String templates = "group test;" + newline + "a() ::= \"X$@r$foo\"" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors, null);
        StringTemplate st = group.getInstanceOf("a");
        st.toString();
        String result = ((Object)errors).toString();
        String expecting = "missing region r $@end$ tag";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMissingEndRegionErrorAngleBrackets() throws Exception {
        String templates = "group test;" + newline + "a() ::= \"X<@r>foo\"" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), errors);
        StringTemplate st = group.getInstanceOf("a");
        st.toString();
        String result = ((Object)errors).toString();
        String expecting = "missing region r <@end> tag";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testSimpleInheritance() throws Exception {
        StringTemplateGroup supergroup = new StringTemplateGroup("super");
        StringTemplateGroup subgroup = new StringTemplateGroup("sub");
        supergroup.defineTemplate("bold", "<b>$it$</b>");
        subgroup.setSuperGroup(supergroup);
        ErrorBuffer errors = new ErrorBuffer();
        subgroup.setErrorListener(errors);
        supergroup.setErrorListener(errors);
        StringTemplate duh = new StringTemplate(subgroup, "$name:bold()$");
        duh.setAttribute("name", "Terence");
        String expecting = "<b>Terence</b>";
        TestStringTemplate.assertEquals(expecting, duh.toString());
    }

    public void testOverrideInheritance() throws Exception {
        StringTemplateGroup supergroup = new StringTemplateGroup("super");
        StringTemplateGroup subgroup = new StringTemplateGroup("sub");
        supergroup.defineTemplate("bold", "<b>$it$</b>");
        subgroup.defineTemplate("bold", "<strong>$it$</strong>");
        subgroup.setSuperGroup(supergroup);
        ErrorBuffer errors = new ErrorBuffer();
        subgroup.setErrorListener(errors);
        supergroup.setErrorListener(errors);
        StringTemplate duh = new StringTemplate(subgroup, "$name:bold()$");
        duh.setAttribute("name", "Terence");
        String expecting = "<strong>Terence</strong>";
        TestStringTemplate.assertEquals(expecting, duh.toString());
    }

    public void testMultiLevelInheritance() throws Exception {
        StringTemplateGroup rootgroup = new StringTemplateGroup("root");
        StringTemplateGroup level1 = new StringTemplateGroup("level1");
        StringTemplateGroup level2 = new StringTemplateGroup("level2");
        rootgroup.defineTemplate("bold", "<b>$it$</b>");
        level1.setSuperGroup(rootgroup);
        level2.setSuperGroup(level1);
        ErrorBuffer errors = new ErrorBuffer();
        rootgroup.setErrorListener(errors);
        level1.setErrorListener(errors);
        level2.setErrorListener(errors);
        StringTemplate duh = new StringTemplate(level2, "$name:bold()$");
        duh.setAttribute("name", "Terence");
        String expecting = "<b>Terence</b>";
        TestStringTemplate.assertEquals(expecting, duh.toString());
    }

    public void testComplicatedInheritance() throws Exception {
        String basetemplates = "group base;" + newline + "decls() ::= \"D<labels()>\"" + newline + "labels() ::= \"L\"" + newline;
        StringTemplateGroup base = new StringTemplateGroup(new StringReader(basetemplates));
        String subtemplates = "group sub;" + newline + "decls() ::= \"<super.decls()>\"" + newline + "labels() ::= \"SL\"" + newline;
        StringTemplateGroup sub = new StringTemplateGroup(new StringReader(subtemplates));
        sub.setSuperGroup(base);
        StringTemplate st = sub.getInstanceOf("decls");
        String expecting = "DSL";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void test3LevelSuperRef() throws Exception {
        String templates1 = "group super;" + newline + "r() ::= \"foo\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates1));
        String templates2 = "group sub;" + newline + "r() ::= \"<super.r()>2\"" + newline;
        StringTemplateGroup subGroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, null, group);
        String templates3 = "group subsub;" + newline + "r() ::= \"<super.r()>3\"" + newline;
        StringTemplateGroup subSubGroup = new StringTemplateGroup(new StringReader(templates3), AngleBracketTemplateLexer.class, null, subGroup);
        StringTemplate st = subSubGroup.getInstanceOf("r");
        String result = st.toString();
        String expecting = "foo23";
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testExprInParens() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate duh = new StringTemplate(group, "$(\"blort: \"+(list)):bold()$");
        duh.setAttribute("list", "a");
        duh.setAttribute("list", "b");
        duh.setAttribute("list", "c");
        String expecting = "<b>blort: abc</b>";
        TestStringTemplate.assertEquals(expecting, duh.toString());
    }

    public void testMultipleAdditions() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        group.defineTemplate("link", "<a href=\"$url$\"><b>$title$</b></a>");
        StringTemplate duh = new StringTemplate(group, "$link(url=\"/member/view?ID=\"+ID+\"&x=y\"+foo, title=\"the title\")$");
        duh.setAttribute("ID", "3321");
        duh.setAttribute("foo", "fubar");
        String expecting = "<a href=\"/member/view?ID=3321&x=yfubar\"><b>the title</b></a>";
        TestStringTemplate.assertEquals(expecting, duh.toString());
    }

    public void testCollectionAttributes() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate t = new StringTemplate(group, "$data$, $data:bold()$, $list:bold():bold()$, $array$, $a2$, $a3$, $a4$");
        Vector<String> v = new Vector<String>();
        v.addElement("1");
        v.addElement("2");
        v.addElement("3");
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        list.add("b");
        list.add("c");
        t.setAttribute("data", v);
        t.setAttribute("list", list);
        t.setAttribute("array", (Object)new String[]{"x", "y"});
        t.setAttribute("a2", (Object)new int[]{10, 20});
        t.setAttribute("a3", (Object)new float[]{1.2f, 1.3f});
        t.setAttribute("a4", (Object)new double[]{8.7, 9.2});
        String expecting = "123, <b>1</b><b>2</b><b>3</b>, <b><b>a</b></b><b><b>b</b></b><b><b>c</b></b>, xy, 1020, 1.21.3, 8.79.2";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testParenthesizedExpression() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate t = new StringTemplate(group, "$(f+l):bold()$");
        t.setAttribute("f", "Joe");
        t.setAttribute("l", "Schmoe");
        String expecting = "<b>JoeSchmoe</b>";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testApplyTemplateNameExpression() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("foobar", "foo$attr$bar");
        StringTemplate t = new StringTemplate(group, "$data:(name+\"bar\")()$");
        t.setAttribute("data", "Ter");
        t.setAttribute("data", "Tom");
        t.setAttribute("name", "foo");
        String expecting = "fooTerbarfooTombar";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testApplyTemplateNameTemplateEval() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("foobar", "foo$it$bar");
        group.defineTemplate("a", "$it$bar");
        StringTemplate t = new StringTemplate(group, "$data:(\"foo\":a())()$");
        t.setAttribute("data", "Ter");
        t.setAttribute("data", "Tom");
        String expecting = "fooTerbarfooTombar";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testTemplateNameExpression() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("foo", "hi there!");
        StringTemplate t = new StringTemplate(group, "$(name)()$");
        t.setAttribute("name", "foo");
        String expecting = "hi there!";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testMissingEndDelimiter() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        new StringTemplate(group, "stuff $a then more junk etc...");
        String expectingError = "problem parsing template 'anonymous': line 1:31: expecting '$', found '<EOF>'";
        TestStringTemplate.assertTrue((boolean)((Object)errors).toString().startsWith(expectingError));
    }

    public void testSetButNotRefd() throws Exception {
        StringTemplate.setLintMode(true);
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate t = new StringTemplate(group, "$a$ then $b$ and $c$ refs.");
        t.setAttribute("a", "Terence");
        t.setAttribute("b", "Terence");
        t.setAttribute("cc", "Terence");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        String expectingError = "anonymous: set but not used: cc";
        t.toString();
        StringTemplate.setLintMode(false);
        TestStringTemplate.assertEquals(expectingError, ((Object)errors).toString());
    }

    public void testNullTemplateApplication() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "$names:bold(x=it)$");
        t.setAttribute("names", "Terence");
        String error = null;
        try {
            t.toString();
        }
        catch (IllegalArgumentException iae) {
            error = iae.getMessage();
        }
        String expecting = "Can't find template bold.st; context is [anonymous]";
        TestStringTemplate.assertEquals(expecting, error);
    }

    public void testNullTemplateToMultiValuedApplication() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "$names:bold(x=it)$");
        t.setAttribute("names", "Terence");
        t.setAttribute("names", "Tom");
        String error = null;
        try {
            t.toString();
        }
        catch (IllegalArgumentException iae) {
            error = iae.getMessage();
        }
        String expecting = "Can't find template bold.st; context is [anonymous]";
        TestStringTemplate.assertEquals(expecting, error);
    }

    public void testChangingAttrValueTemplateApplicationToVector() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate t = new StringTemplate(group, "$names:bold(x=it)$");
        t.setAttribute("names", "Terence");
        t.setAttribute("names", "Tom");
        String expecting = "<b>Terence</b><b>Tom</b>";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testChangingAttrValueRepeatedTemplateApplicationToVector() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        group.defineTemplate("bold", "<b>$item$</b>");
        group.defineTemplate("italics", "<i>$it$</i>");
        StringTemplate members = new StringTemplate(group, "$members:bold(item=it):italics(it=it)$");
        members.setAttribute("members", "Jim");
        members.setAttribute("members", "Mike");
        members.setAttribute("members", "Ashar");
        String expecting = "<i><b>Jim</b></i><i><b>Mike</b></i><i><b>Ashar</b></i>";
        TestStringTemplate.assertEquals(expecting, members.toString());
    }

    public void testAlternatingTemplateApplication() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        group.defineTemplate("listItem", "<li>$it$</li>");
        group.defineTemplate("bold", "<b>$it$</b>");
        group.defineTemplate("italics", "<i>$it$</i>");
        StringTemplate item = new StringTemplate(group, "$item:bold(),italics():listItem()$");
        item.setAttribute("item", "Jim");
        item.setAttribute("item", "Mike");
        item.setAttribute("item", "Ashar");
        String expecting = "<li><b>Jim</b></li><li><i>Mike</i></li><li><b>Ashar</b></li>";
        TestStringTemplate.assertEquals(item.toString(), expecting);
    }

    public void testExpressionAsRHSOfAssignment() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("hostname", "$machine$.jguru.com");
        group.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate t = new StringTemplate(group, "$bold(x=hostname(machine=\"www\"))$");
        String expecting = "<b>www.jguru.com</b>";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testTemplateApplicationAsRHSOfAssignment() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("hostname", "$machine$.jguru.com");
        group.defineTemplate("bold", "<b>$x$</b>");
        group.defineTemplate("italics", "<i>$it$</i>");
        StringTemplate t = new StringTemplate(group, "$bold(x=hostname(machine=\"www\"):italics())$");
        String expecting = "<b><i>www.jguru.com</i></b>";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testParameterAndAttributeScoping() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("italics", "<i>$x$</i>");
        group.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate t = new StringTemplate(group, "$bold(x=italics(x=name))$");
        t.setAttribute("name", "Terence");
        String expecting = "<b><i>Terence</i></b>";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testComplicatedSeparatorExpr() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("bulletSeparator", "</li>$foo$<li>");
        StringTemplate t = new StringTemplate(group, "<ul>$name; separator=bulletSeparator(foo=\" \")+\"&nbsp;\"$</ul>");
        t.setAttribute("name", "Ter");
        t.setAttribute("name", "Tom");
        t.setAttribute("name", "Mel");
        String expecting = "<ul>Ter</li> <li>&nbsp;Tom</li> <li>&nbsp;Mel</ul>";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testAttributeRefButtedUpAgainstEndifAndWhitespace() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate a = new StringTemplate(group, "$if (!firstName)$$email$$endif$");
        a.setAttribute("email", "parrt@jguru.com");
        String expecting = "parrt@jguru.com";
        TestStringTemplate.assertEquals(a.toString(), expecting);
    }

    public void testStringCatenationOnSingleValuedAttributeViaTemplateLiteral() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate b = new StringTemplate(group, "$bold(it={$name$ Parr})$");
        b.setAttribute("name", "Terence");
        String expecting = "<b>Terence Parr</b>";
        TestStringTemplate.assertEquals(b.toString(), expecting);
    }

    public void testStringCatenationOpOnArg() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate b = new StringTemplate(group, "$bold(it=name+\" Parr\")$");
        b.setAttribute("name", "Terence");
        String expecting = "<b>Terence Parr</b>";
        TestStringTemplate.assertEquals(expecting, b.toString());
    }

    public void testStringCatenationOpOnArgWithEqualsInString() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate b = new StringTemplate(group, "$bold(it=name+\" Parr=\")$");
        b.setAttribute("name", "Terence");
        String expecting = "<b>Terence Parr=</b>";
        TestStringTemplate.assertEquals(expecting, b.toString());
    }

    public void testApplyingTemplateFromDiskWithPrecompiledIF() throws Exception {
        StringBuffer name;
        File tmpWorkDir;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        int counter = new Random().nextInt() & 0xFFFF;
        do {
            name = new StringBuffer("st-junit-");
            name.append(++counter);
        } while ((tmpWorkDir = new File(tmpDir, name.toString())).exists());
        tmpWorkDir.mkdirs();
        File pageFile = new File(tmpWorkDir, "page.st");
        FileWriter fw = new FileWriter(pageFile);
        fw.write("<html><head>" + newline);
        fw.write("</head>" + newline);
        fw.write("<body>" + newline);
        fw.write("$if(member)$User: $member:terse()$$endif$" + newline);
        fw.write("</body>" + newline);
        fw.write("</head>" + newline);
        fw.close();
        File terseFile = new File(tmpWorkDir, "terse.st");
        fw = new FileWriter(terseFile);
        fw.write("$it.firstName$ $it.lastName$ (<tt>$it.email$</tt>)" + newline);
        fw.close();
        StringTemplateGroup group = new StringTemplateGroup("dummy", tmpWorkDir.toString());
        StringTemplate a = group.getInstanceOf("page");
        a.setAttribute("member", new Connector());
        String expecting = "<html><head>" + newline + "</head>" + newline + "<body>" + newline + "User: Terence Parr (<tt>parrt@jguru.com</tt>)" + newline + "</body>" + newline + "</head>";
        TestStringTemplate.assertEquals(expecting, a.toString());
        pageFile.delete();
        terseFile.delete();
        tmpWorkDir.delete();
    }

    public void testMultiValuedAttributeWithAnonymousTemplateUsingIndexVariableI() throws Exception {
        StringTemplateGroup tgroup = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(tgroup, " List:" + newline + "  " + newline + "foo" + newline + newline + "$names:{<br>$i$. $it$" + newline + "}$");
        t.setAttribute("names", "Terence");
        t.setAttribute("names", "Jim");
        t.setAttribute("names", "Sriram");
        String expecting = " List:" + newline + "  " + newline + "foo" + newline + newline + "<br>1. Terence" + newline + "<br>2. Jim" + newline + "<br>3. Sriram" + newline;
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testFindTemplateInCLASSPATH() throws Exception {
        StringTemplateGroup mgroup = new StringTemplateGroup("method stuff", AngleBracketTemplateLexer.class);
        StringTemplate m = mgroup.getInstanceOf("org/antlr/stringtemplate/test/method");
        m.setAttribute("visibility", "public");
        m.setAttribute("name", "foobar");
        m.setAttribute("returnType", "void");
        m.setAttribute("statements", "i=1;");
        m.setAttribute("statements", "x=i;");
        String expecting = "public void foobar() {" + newline + "\t// start of a body" + newline + "\ti=1;" + newline + "\tx=i;" + newline + "\t// end of a body" + newline + "}";
        TestStringTemplate.assertEquals(expecting, m.toString());
    }

    public void testApplyTemplateToSingleValuedAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate name = new StringTemplate(group, "$name:bold(x=name)$");
        name.setAttribute("name", "Terence");
        TestStringTemplate.assertEquals("<b>Terence</b>", name.toString());
    }

    public void testStringLiteralAsAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate name = new StringTemplate(group, "$\"Terence\":bold()$");
        TestStringTemplate.assertEquals("<b>Terence</b>", name.toString());
    }

    public void testApplyTemplateToSingleValuedAttributeWithDefaultAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate name = new StringTemplate(group, "$name:bold()$");
        name.setAttribute("name", "Terence");
        TestStringTemplate.assertEquals("<b>Terence</b>", name.toString());
    }

    public void testApplyAnonymousTemplateToSingleValuedAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate item = new StringTemplate(group, "$item:{<li>$it$</li>}$");
        item.setAttribute("item", "Terence");
        TestStringTemplate.assertEquals("<li>Terence</li>", item.toString());
    }

    public void testApplyAnonymousTemplateToMultiValuedAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate list = new StringTemplate(group, "<ul>$items$</ul>");
        StringTemplate item = new StringTemplate(group, "$item:{<li>$it$</li>}; separator=\",\"$");
        item.setAttribute("item", "Terence");
        item.setAttribute("item", "Jim");
        item.setAttribute("item", "John");
        list.setAttribute("items", item);
        String expecting = "<ul><li>Terence</li>,<li>Jim</li>,<li>John</li></ul>";
        TestStringTemplate.assertEquals(expecting, list.toString());
    }

    public void testApplyAnonymousTemplateToAggregateAttribute() throws Exception {
        StringTemplate st = new StringTemplate("$items:{$it.lastName$, $it.firstName$\n}$");
        st.setAttribute("items.{ firstName ,lastName}", "Ter", "Parr");
        st.setAttribute("items.{firstName, lastName }", "Tom", "Burns");
        String expecting = "Parr, Ter" + newline + "Burns, Tom" + newline;
        TestStringTemplate.assertEquals(expecting, st.toString());
    }

    public void testRepeatedApplicationOfTemplateToSingleValuedAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate item = new StringTemplate(group, "$item:bold():bold()$");
        item.setAttribute("item", "Jim");
        TestStringTemplate.assertEquals("<b><b>Jim</b></b>", item.toString());
    }

    public void testRepeatedApplicationOfTemplateToMultiValuedAttributeWithSeparator() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate item = new StringTemplate(group, "$item:bold():bold(); separator=\",\"$");
        item.setAttribute("item", "Jim");
        item.setAttribute("item", "Mike");
        item.setAttribute("item", "Ashar");
        String expecting = "<b><b>Jim</b></b>,<b><b>Mike</b></b>,<b><b>Ashar</b></b>";
        TestStringTemplate.assertEquals(item.toString(), expecting);
    }

    public void testMultiValuedAttributeWithSeparator() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate query = new StringTemplate(group, "SELECT <distinct> <column; separator=\", \"> FROM <table>;");
        query.setAttribute("column", "name");
        query.setAttribute("column", "email");
        query.setAttribute("table", "User");
        TestStringTemplate.assertEquals("SELECT  name, email FROM User;", query.toString());
    }

    public void testSingleValuedAttributes() throws Exception {
        StringTemplate query = new StringTemplate("SELECT $column$ FROM $table$;");
        query.setAttribute("column", "name");
        query.setAttribute("table", "User");
        TestStringTemplate.assertEquals("SELECT name FROM User;", query.toString());
    }

    public void testIFTemplate() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate t = new StringTemplate(group, "SELECT <column> FROM PERSON <if(cond)>WHERE ID=<id><endif>;");
        t.setAttribute("column", "name");
        t.setAttribute("cond", "true");
        t.setAttribute("id", "231");
        TestStringTemplate.assertEquals("SELECT name FROM PERSON WHERE ID=231;", t.toString());
    }

    public void testIFCondWithParensTemplate() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate t = new StringTemplate(group, "<if(map.(type))><type> <prop>=<map.(type)>;<endif>");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("int", "0");
        t.setAttribute("map", map);
        t.setAttribute("prop", "x");
        t.setAttribute("type", "int");
        TestStringTemplate.assertEquals("int x=0;", t.toString());
    }

    public void testIFCondWithParensDollarDelimsTemplate() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "$if(map.(type))$$type$ $prop$=$map.(type)$;$endif$");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("int", "0");
        t.setAttribute("map", map);
        t.setAttribute("prop", "x");
        t.setAttribute("type", "int");
        TestStringTemplate.assertEquals("int x=0;", t.toString());
    }

    public void testIFBoolean() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "$if(b)$x$endif$ $if(!b)$y$endif$");
        t.setAttribute("b", new Boolean(true));
        TestStringTemplate.assertEquals(t.toString(), "x ");
        t = t.getInstanceOf();
        t.setAttribute("b", new Boolean(false));
        TestStringTemplate.assertEquals(" y", t.toString());
    }

    public void testNestedIFTemplate() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate t = new StringTemplate(group, "ack<if(a)>" + newline + "foo" + newline + "<if(!b)>stuff<endif>" + newline + "<if(b)>no<endif>" + newline + "junk" + newline + "<endif>");
        t.setAttribute("a", "blort");
        String expecting = "ackfoo" + newline + "stuff" + newline + "junk";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testObjectPropertyReference() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "<b>Name: $p.firstName$ $p.lastName$</b><br>" + newline + "<b>Email: $p.email$</b><br>" + newline + "$p.bio$");
        t.setAttribute("p", new Connector());
        String expecting = "<b>Name: Terence Parr</b><br>" + newline + "<b>Email: parrt@jguru.com</b><br>" + newline + "Superhero by night...";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testApplyRepeatedAnonymousTemplateWithForeignTemplateRefToMultiValuedAttribute() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        group.defineTemplate("link", "<a href=\"$url$\"><b>$title$</b></a>");
        StringTemplate duh = new StringTemplate(group, "start|$p:{$link(url=\"/member/view?ID=\"+it.ID, title=it.firstName)$ $if(it.canEdit)$canEdit$endif$}:{$it$<br>\n}$|end");
        duh.setAttribute("p", new Connector());
        duh.setAttribute("p", new Connector2());
        String expecting = "start|<a href=\"/member/view?ID=1\"><b>Terence</b></a> <br>" + newline + "<a href=\"/member/view?ID=2\"><b>Tom</b></a> canEdit<br>" + newline + "|end";
        TestStringTemplate.assertEquals(expecting, duh.toString());
    }

    public void testRecursion() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        group.defineTemplate("tree", "<if(it.firstChild)>( <it.text> <it.children:tree(); separator=\" \"> )<else><it.text><endif>");
        StringTemplate tree = group.getInstanceOf("tree");
        Tree root = new Tree("a");
        root.addChild(new Tree("b"));
        Tree subtree = new Tree("c");
        subtree.addChild(new Tree("d"));
        root.addChild(subtree);
        root.addChild(new Tree("e"));
        tree.setAttribute("it", root);
        String expecting = "( a b ( c d ) e )";
        TestStringTemplate.assertEquals(expecting, tree.toString());
    }

    public void testNestedAnonymousTemplates() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "$A:{" + newline + "<i>$it:{" + newline + "<b>$it$</b>" + newline + "}$</i>" + newline + "}$");
        t.setAttribute("A", "parrt");
        String expecting = newline + "<i>" + newline + "<b>parrt</b>" + newline + "</i>" + newline;
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testAnonymousTemplateAccessToEnclosingAttributes() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "$A:{" + newline + "<i>$it:{" + newline + "<b>$it$, $B$</b>" + newline + "}$</i>" + newline + "}$");
        t.setAttribute("A", "parrt");
        t.setAttribute("B", "tombu");
        String expecting = newline + "<i>" + newline + "<b>parrt, tombu</b>" + newline + "</i>" + newline;
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testNestedAnonymousTemplatesAgain() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "<table>" + newline + "$names:{<tr>$it:{<td>$it:{<b>$it$</b>}$</td>}$</tr>}$" + newline + "</table>" + newline);
        t.setAttribute("names", "parrt");
        t.setAttribute("names", "tombu");
        String expecting = "<table>" + newline + "<tr><td><b>parrt</b></td></tr><tr><td><b>tombu</b></td></tr>" + newline + "</table>" + newline;
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testEscapes() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        group.defineTemplate("foo", "$x$ && $it$");
        StringTemplate t = new StringTemplate(group, "$A:foo(x=\"dog\\\"\\\"\")$");
        StringTemplate u = new StringTemplate(group, "$A:foo(x=\"dog\\\"g\")$");
        StringTemplate v = new StringTemplate(group, "$A:{$it:foo(x=\"\\{dog\\}\\\"\")$ is cool}$");
        t.setAttribute("A", "ick");
        u.setAttribute("A", "ick");
        v.setAttribute("A", "ick");
        String expecting = "dog\"\" && ick";
        TestStringTemplate.assertEquals(expecting, t.toString());
        expecting = "dog\"g && ick";
        TestStringTemplate.assertEquals(expecting, u.toString());
        expecting = "{dog}\" && ick is cool";
        TestStringTemplate.assertEquals(expecting, v.toString());
    }

    public void testEscapesOutsideExpressions() throws Exception {
        StringTemplate b = new StringTemplate("It\\'s ok...\\$; $a:{\\'hi\\', $it$}$");
        b.setAttribute("a", "Ter");
        String expecting = "It\\'s ok...$; \\'hi\\', Ter";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testElseClause() throws Exception {
        StringTemplate e = new StringTemplate("$if(title)$" + newline + "foo" + newline + "$else$" + newline + "bar" + newline + "$endif$");
        e.setAttribute("title", "sample");
        String expecting = "foo";
        TestStringTemplate.assertEquals(expecting, e.toString());
        e = e.getInstanceOf();
        expecting = "bar";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testNestedIF() throws Exception {
        StringTemplate e = new StringTemplate("$if(title)$" + newline + "foo" + newline + "$else$" + newline + "$if(header)$" + newline + "bar" + newline + "$else$" + newline + "blort" + newline + "$endif$" + newline + "$endif$");
        e.setAttribute("title", "sample");
        String expecting = "foo";
        TestStringTemplate.assertEquals(expecting, e.toString());
        e = e.getInstanceOf();
        e.setAttribute("header", "more");
        expecting = "bar";
        TestStringTemplate.assertEquals(expecting, e.toString());
        e = e.getInstanceOf();
        expecting = "blort";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testEmbeddedMultiLineIF() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate main = new StringTemplate(group, "$sub$");
        StringTemplate sub = new StringTemplate(group, "begin" + newline + "$if(foo)$" + newline + "$foo$" + newline + "$else$" + newline + "blort" + newline + "$endif$" + newline);
        sub.setAttribute("foo", "stuff");
        main.setAttribute("sub", sub);
        String expecting = "begin" + newline + "stuff";
        TestStringTemplate.assertEquals(expecting, main.toString());
        main = new StringTemplate(group, "$sub$");
        sub = sub.getInstanceOf();
        main.setAttribute("sub", sub);
        expecting = "begin" + newline + "blort";
        TestStringTemplate.assertEquals(expecting, main.toString());
    }

    public void testSimpleIndentOfAttributeList() throws Exception {
        String templates = "group test;" + newline + "list(names) ::= <<" + "  $names; separator=\"\n\"$" + newline + ">>" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        StringTemplate t = group.getInstanceOf("list");
        t.setAttribute("names", "Terence");
        t.setAttribute("names", "Jim");
        t.setAttribute("names", "Sriram");
        String expecting = "  Terence" + newline + "  Jim" + newline + "  Sriram";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testIndentOfMultilineAttributes() throws Exception {
        String templates = "group test;" + newline + "list(names) ::= <<" + "  $names; separator=\"\n\"$" + newline + ">>" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        StringTemplate t = group.getInstanceOf("list");
        t.setAttribute("names", "Terence\nis\na\nmaniac");
        t.setAttribute("names", "Jim");
        t.setAttribute("names", "Sriram\nis\ncool");
        String expecting = "  Terence" + newline + "  is" + newline + "  a" + newline + "  maniac" + newline + "  Jim" + newline + "  Sriram" + newline + "  is" + newline + "  cool";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testIndentOfMultipleBlankLines() throws Exception {
        String templates = "group test;" + newline + "list(names) ::= <<" + "  $names$" + newline + ">>" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        StringTemplate t = group.getInstanceOf("list");
        t.setAttribute("names", "Terence\n\nis a maniac");
        String expecting = "  Terence" + newline + "" + newline + "  is a maniac";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testIndentBetweenLeftJustifiedLiterals() throws Exception {
        String templates = "group test;" + newline + "list(names) ::= <<" + "Before:" + newline + "  $names; separator=\"\\n\"$" + newline + "after" + newline + ">>" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        StringTemplate t = group.getInstanceOf("list");
        t.setAttribute("names", "Terence");
        t.setAttribute("names", "Jim");
        t.setAttribute("names", "Sriram");
        String expecting = "Before:" + newline + "  Terence" + newline + "  Jim" + newline + "  Sriram" + newline + "after";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testNestedIndent() throws Exception {
        String templates = "group test;" + newline + "method(name,stats) ::= <<" + "void $name$() {" + newline + "\t$stats; separator=\"\\n\"$" + newline + "}" + newline + ">>" + newline + "ifstat(expr,stats) ::= <<" + newline + "if ($expr$) {" + newline + "  $stats; separator=\"\\n\"$" + newline + "}" + ">>" + newline + "assign(lhs,expr) ::= <<$lhs$=$expr$;>>" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        StringTemplate t = group.getInstanceOf("method");
        t.setAttribute("name", "foo");
        StringTemplate s1 = group.getInstanceOf("assign");
        s1.setAttribute("lhs", "x");
        s1.setAttribute("expr", "0");
        StringTemplate s2 = group.getInstanceOf("ifstat");
        s2.setAttribute("expr", "x>0");
        StringTemplate s2a = group.getInstanceOf("assign");
        s2a.setAttribute("lhs", "y");
        s2a.setAttribute("expr", "x+y");
        StringTemplate s2b = group.getInstanceOf("assign");
        s2b.setAttribute("lhs", "z");
        s2b.setAttribute("expr", "4");
        s2.setAttribute("stats", s2a);
        s2.setAttribute("stats", s2b);
        t.setAttribute("stats", s1);
        t.setAttribute("stats", s2);
        String expecting = "void foo() {" + newline + "\tx=0;" + newline + "\tif (x>0) {" + newline + "\t  y=x+y;" + newline + "\t  z=4;" + newline + "\t}" + newline + "}";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testAlternativeWriter() throws Exception {
        final StringBuffer buf = new StringBuffer();
        StringTemplateWriter w = new StringTemplateWriter(){

            public void pushIndentation(String indent) {
            }

            public String popIndentation() {
                return null;
            }

            public void pushAnchorPoint() {
            }

            public void popAnchorPoint() {
            }

            public void setLineWidth(int lineWidth) {
            }

            public int write(String str, String wrap) throws IOException {
                return 0;
            }

            public int write(String str) throws IOException {
                buf.append(str);
                return str.length();
            }

            public int writeWrapSeparator(String wrap) throws IOException {
                return 0;
            }

            public int writeSeparator(String str) throws IOException {
                return this.write(str);
            }
        };
        StringTemplateGroup group = new StringTemplateGroup("test");
        group.defineTemplate("bold", "<b>$x$</b>");
        StringTemplate name = new StringTemplate(group, "$name:bold(x=name)$");
        name.setAttribute("name", "Terence");
        name.write(w);
        TestStringTemplate.assertEquals("<b>Terence</b>", buf.toString());
    }

    public void testApplyAnonymousTemplateToMapAndSet() throws Exception {
        StringTemplate st = new StringTemplate("$items:{<li>$it$</li>}$");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "1");
        m.put("b", "2");
        m.put("c", "3");
        st.setAttribute("items", m);
        String expecting = "<li>1</li><li>3</li><li>2</li>";
        TestStringTemplate.assertEquals(expecting, st.toString());
        st = st.getInstanceOf();
        HashSet<String> s = new HashSet<String>();
        s.add("1");
        s.add("2");
        s.add("3");
        st.setAttribute("items", s);
        expecting = "<li>3</li><li>2</li><li>1</li>";
        TestStringTemplate.assertEquals(expecting, st.toString());
    }

    public void testDumpMapAndSet() throws Exception {
        StringTemplate st = new StringTemplate("$items; separator=\",\"$");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "1");
        m.put("b", "2");
        m.put("c", "3");
        st.setAttribute("items", m);
        String expecting = "1,3,2";
        TestStringTemplate.assertEquals(expecting, st.toString());
        st = st.getInstanceOf();
        HashSet<String> s = new HashSet<String>();
        s.add("1");
        s.add("2");
        s.add("3");
        st.setAttribute("items", s);
        expecting = "3,2,1";
        TestStringTemplate.assertEquals(expecting, st.toString());
    }

    public void testApplyAnonymousTemplateToArrayAndMapProperty() throws Exception {
        StringTemplate st = new StringTemplate("$x.values:{<li>$it$</li>}$");
        st.setAttribute("x", new Connector3());
        String expecting = "<li>1</li><li>2</li><li>3</li>";
        TestStringTemplate.assertEquals(expecting, st.toString());
        st = new StringTemplate("$x.stuff:{<li>$it$</li>}$");
        st.setAttribute("x", new Connector3());
        expecting = "<li>1</li><li>2</li>";
        TestStringTemplate.assertEquals(expecting, st.toString());
    }

    public void testSuperTemplateRef() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("super");
        StringTemplateGroup subGroup = new StringTemplateGroup("sub");
        subGroup.setSuperGroup(group);
        group.defineTemplate("page", "$font()$:text");
        group.defineTemplate("font", "Helvetica");
        subGroup.defineTemplate("font", "$super.font()$ and Times");
        StringTemplate st = subGroup.getInstanceOf("page");
        String expecting = "Helvetica and Times:text";
        TestStringTemplate.assertEquals(expecting, st.toString());
    }

    public void testApplySuperTemplateRef() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("super");
        StringTemplateGroup subGroup = new StringTemplateGroup("sub");
        subGroup.setSuperGroup(group);
        group.defineTemplate("bold", "<b>$it$</b>");
        subGroup.defineTemplate("bold", "<strong>$it$</strong>");
        subGroup.defineTemplate("page", "$name:super.bold()$");
        StringTemplate st = subGroup.getInstanceOf("page");
        st.setAttribute("name", "Ter");
        String expecting = "<b>Ter</b>";
        TestStringTemplate.assertEquals(expecting, st.toString());
    }

    public void testLazyEvalOfSuperInApplySuperTemplateRef() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("base");
        StringTemplateGroup subGroup = new StringTemplateGroup("sub");
        subGroup.setSuperGroup(group);
        group.defineTemplate("bold", "<b>$it$</b>");
        subGroup.defineTemplate("bold", "<strong>$it$</strong>");
        group.defineTemplate("page", "$name:super.bold()$");
        StringTemplate st = subGroup.getInstanceOf("page");
        st.setAttribute("name", "Ter");
        String error = null;
        try {
            st.toString();
        }
        catch (IllegalArgumentException iae) {
            error = iae.getMessage();
        }
        String expectingError = "base has no super group; invalid template: super.bold";
        TestStringTemplate.assertEquals(expectingError, error);
    }

    public void testTemplatePolymorphism() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("super");
        StringTemplateGroup subGroup = new StringTemplateGroup("sub");
        subGroup.setSuperGroup(group);
        group.defineTemplate("bold", "<b>$it$</b>");
        group.defineTemplate("page", "$name:bold()$");
        subGroup.defineTemplate("bold", "<strong>$it$</strong>");
        StringTemplate st = subGroup.getInstanceOf("page");
        st.setAttribute("name", "Ter");
        String expecting = "<strong>Ter</strong>";
        TestStringTemplate.assertEquals(expecting, st.toString());
    }

    public void testListOfEmbeddedTemplateSeesEnclosingAttributes() throws Exception {
        String templates = "group test;" + newline + "output(cond,items) ::= <<page: $items$>>" + newline + "mybody() ::= <<$font()$stuff>>" + newline + "font() ::= <<$if(cond)$this$else$that$endif$>>";
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        StringTemplate outputST = group.getInstanceOf("output");
        StringTemplate bodyST1 = group.getInstanceOf("mybody");
        StringTemplate bodyST2 = group.getInstanceOf("mybody");
        StringTemplate bodyST3 = group.getInstanceOf("mybody");
        outputST.setAttribute("items", bodyST1);
        outputST.setAttribute("items", bodyST2);
        outputST.setAttribute("items", bodyST3);
        String expecting = "page: thatstuffthatstuffthatstuff";
        TestStringTemplate.assertEquals(expecting, outputST.toString());
    }

    public void testInheritArgumentFromRecursiveTemplateApplication() throws Exception {
        String templates = "group test;" + newline + "block(stats) ::= \"<stats>\"" + "ifstat(stats) ::= \"IF true then <stats>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("block");
        b.setAttribute("stats", group.getInstanceOf("ifstat"));
        b.setAttribute("stats", group.getInstanceOf("ifstat"));
        String expecting = "IF true then IF true then ";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testDeliberateRecursiveTemplateApplication() throws Exception {
        String templates = "group test;" + newline + "block(stats) ::= \"<stats>\"" + "ifstat(stats) ::= \"IF true then <stats>\"" + newline;
        StringTemplate.setLintMode(true);
        StringTemplate.resetTemplateCounter();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("block");
        StringTemplate ifstat = group.getInstanceOf("ifstat");
        b.setAttribute("stats", ifstat);
        ifstat.setAttribute("stats", b);
        String expectingError = "infinite recursion to <ifstat([stats])@4> referenced in <block([stats])@3>; stack trace:" + newline + "<ifstat([stats])@4>, attributes=[stats=<block()@3>]>" + newline + "<block([stats])@3>, attributes=[stats=<ifstat()@4>], references=[stats]>" + newline + "<ifstat([stats])@4> (start of recursive cycle)" + newline + "...";
        String errors = "";
        try {
            b.toString();
        }
        catch (IllegalStateException ise) {
            errors = ise.getMessage();
        }
        StringTemplate.setLintMode(false);
        TestStringTemplate.assertEquals(expectingError, errors);
    }

    public void testImmediateTemplateAsAttributeLoop() throws Exception {
        String templates = "group test;" + newline + "block(stats) ::= \"{<stats>}\"";
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("block");
        b.setAttribute("stats", group.getInstanceOf("block"));
        String expecting = "{{}}";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testTemplateAlias() throws Exception {
        String templates = "group test;" + newline + "page(name) ::= \"name is <name>\"" + "other ::= page" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("other");
        b.setAttribute("name", "Ter");
        String expecting = "name is Ter";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testTemplateGetPropertyGetsAttribute() throws Exception {
        String templates = "group test;" + newline + "Cfile(funcs) ::= <<" + newline + "#include \\<stdio.h>" + newline + "<funcs:{public void <it.name>(<it.args>);}; separator=\"\\n\">" + newline + "<funcs; separator=\"\\n\">" + newline + ">>" + newline + "func(name,args,body) ::= <<" + newline + "public void <name>(<args>) {<body>}" + newline + ">>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("Cfile");
        StringTemplate f1 = group.getInstanceOf("func");
        StringTemplate f2 = group.getInstanceOf("func");
        f1.setAttribute("name", "f");
        f1.setAttribute("args", "");
        f1.setAttribute("body", "i=1;");
        f2.setAttribute("name", "g");
        f2.setAttribute("args", "int arg");
        f2.setAttribute("body", "y=1;");
        b.setAttribute("funcs", f1);
        b.setAttribute("funcs", f2);
        String expecting = "#include <stdio.h>" + newline + "public void f();" + newline + "public void g(int arg);" + newline + "public void f() {i=1;}" + newline + "public void g(int arg) {y=1;}";
        TestStringTemplate.assertEquals(expecting, b.toString());
    }

    public void testComplicatedIndirectTemplateApplication() throws Exception {
        String templates = "group Java;" + newline + "" + newline + "file(variables) ::= <<" + "<variables:{ v | <v.decl:(v.format)()>}; separator=\"\\n\">" + newline + ">>" + newline + "intdecl(decl) ::= \"int <decl.name> = 0;\"" + newline + "intarray(decl) ::= \"int[] <decl.name> = null;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate f = group.getInstanceOf("file");
        f.setAttribute("variables.{decl,format}", new Decl("i", "int"), "intdecl");
        f.setAttribute("variables.{decl,format}", new Decl("a", "int-array"), "intarray");
        String expecting = "int i = 0;" + newline + "int[] a = null;";
        TestStringTemplate.assertEquals(expecting, f.toString());
    }

    public void testIndirectTemplateApplication() throws Exception {
        String templates = "group dork;" + newline + "" + newline + "test(name) ::= <<" + "<(name)()>" + newline + ">>" + newline + "first() ::= \"the first\"" + newline + "second() ::= \"the second\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate f = group.getInstanceOf("test");
        f.setAttribute("name", "first");
        String expecting = "the first";
        TestStringTemplate.assertEquals(expecting, f.toString());
    }

    public void testIndirectTemplateWithArgsApplication() throws Exception {
        String templates = "group dork;" + newline + "" + newline + "test(name) ::= <<" + "<(name)(a=\"foo\")>" + newline + ">>" + newline + "first(a) ::= \"the first: <a>\"" + newline + "second(a) ::= \"the second <a>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate f = group.getInstanceOf("test");
        f.setAttribute("name", "first");
        String expecting = "the first: foo";
        TestStringTemplate.assertEquals(f.toString(), expecting);
    }

    public void testNullIndirectTemplateApplication() throws Exception {
        String templates = "group dork;" + newline + "" + newline + "test(names) ::= <<" + "<names:(ind)()>" + newline + ">>" + newline + "ind() ::= \"[<it>]\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate f = group.getInstanceOf("test");
        f.setAttribute("names", "me");
        f.setAttribute("names", "you");
        String expecting = "";
        TestStringTemplate.assertEquals(expecting, f.toString());
    }

    public void testNullIndirectTemplate() throws Exception {
        String templates = "group dork;" + newline + "" + newline + "test(name) ::= <<" + "<(name)()>" + newline + ">>" + newline + "first() ::= \"the first\"" + newline + "second() ::= \"the second\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate f = group.getInstanceOf("test");
        String expecting = "";
        TestStringTemplate.assertEquals(expecting, f.toString());
    }

    public void testHashMapPropertyFetch() throws Exception {
        StringTemplate a = new StringTemplate("$stuff.prop$");
        HashMap<String, String> map = new HashMap<String, String>();
        a.setAttribute("stuff", map);
        map.put("prop", "Terence");
        String results = a.toString();
        String expecting = "Terence";
        TestStringTemplate.assertEquals(expecting, results);
    }

    public void testHashMapPropertyFetchEmbeddedStringTemplate() throws Exception {
        StringTemplate a = new StringTemplate("$stuff.prop$");
        HashMap<String, StringTemplate> map = new HashMap<String, StringTemplate>();
        a.setAttribute("stuff", map);
        a.setAttribute("title", "ST rocks");
        map.put("prop", new StringTemplate("embedded refers to $title$"));
        String results = a.toString();
        String expecting = "embedded refers to ST rocks";
        TestStringTemplate.assertEquals(expecting, results);
    }

    public void testEmbeddedComments() throws Exception {
        StringTemplate st = new StringTemplate("Foo $! ignore !$bar" + newline);
        String expecting = "Foo bar" + newline;
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
        st = new StringTemplate("Foo $! ignore" + newline + " and a line break!$" + newline + "bar" + newline);
        expecting = "Foo " + newline + "bar" + newline;
        result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
        st = new StringTemplate("$! start of line $ and $! ick" + newline + "!$boo" + newline);
        expecting = "boo" + newline;
        result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
        st = new StringTemplate("$! start of line !$" + newline + "$! another to ignore !$" + newline + "$! ick" + newline + "!$boo" + newline);
        expecting = "boo" + newline;
        result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
        st = new StringTemplate("$! back !$$! to back !$" + newline + "$! ick" + newline + "!$boo" + newline);
        expecting = newline + "boo" + newline;
        result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmbeddedCommentsAngleBracketed() throws Exception {
        StringTemplate st = new StringTemplate("Foo <! ignore !>bar" + newline, AngleBracketTemplateLexer.class);
        String expecting = "Foo bar" + newline;
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
        st = new StringTemplate("Foo <! ignore" + newline + " and a line break!>" + newline + "bar" + newline, AngleBracketTemplateLexer.class);
        expecting = "Foo " + newline + "bar" + newline;
        result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
        st = new StringTemplate("<! start of line $ and <! ick" + newline + "!>boo" + newline, AngleBracketTemplateLexer.class);
        expecting = "boo" + newline;
        result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
        st = new StringTemplate("<! start of line !><! another to ignore !><! ick" + newline + "!>boo" + newline, AngleBracketTemplateLexer.class);
        expecting = "boo" + newline;
        result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
        st = new StringTemplate("<! back !><! to back !>" + newline + "<! ick" + newline + "!>boo" + newline, AngleBracketTemplateLexer.class);
        expecting = newline + "boo" + newline;
        result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testCharLiterals() throws Exception {
        StringTemplate st = new StringTemplate("Foo <\\n><\\t> bar" + newline, AngleBracketTemplateLexer.class);
        String expecting = "Foo " + newline + "\t bar" + newline;
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
        st = new StringTemplate("Foo $\\n$$\\t$ bar" + newline);
        expecting = "Foo " + newline + "\t bar" + newline;
        result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
        st = new StringTemplate("Foo$\\ $bar$\\n$");
        expecting = "Foo bar" + newline;
        result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmptyIteratedValueGetsSeparator() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "$names; separator=\",\"$");
        t.setAttribute("names", "Terence");
        t.setAttribute("names", "");
        t.setAttribute("names", "");
        t.setAttribute("names", "Tom");
        t.setAttribute("names", "Frank");
        t.setAttribute("names", "");
        String expecting = "Terence,,,Tom,Frank,";
        String result = t.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmptyIteratedConditionalValueGetsSeparator() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "$users:{$if(it.ok)$$it.name$$endif$}; separator=\",\"$");
        t.setAttribute("users.{name,ok}", "Terence", new Boolean(true));
        t.setAttribute("users.{name,ok}", "Tom", new Boolean(false));
        t.setAttribute("users.{name,ok}", "Frank", new Boolean(true));
        t.setAttribute("users.{name,ok}", "Johnny", new Boolean(false));
        String expecting = "Terence,,Frank,";
        String result = t.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmptyIteratedConditionalWithElseValueGetsSeparator() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "$users:{$if(it.ok)$$it.name$$else$$endif$}; separator=\",\"$");
        t.setAttribute("users.{name,ok}", "Terence", new Boolean(true));
        t.setAttribute("users.{name,ok}", "Tom", new Boolean(false));
        t.setAttribute("users.{name,ok}", "Frank", new Boolean(true));
        t.setAttribute("users.{name,ok}", "Johnny", new Boolean(false));
        String expecting = "Terence,,Frank,";
        String result = t.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testWhiteSpaceAtEndOfTemplate() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("group");
        StringTemplate pageST = group.getInstanceOf("org/antlr/stringtemplate/test/page");
        StringTemplate listST = group.getInstanceOf("org/antlr/stringtemplate/test/users_list");
        listST.setAttribute("users", new Connector());
        listST.setAttribute("users", new Connector2());
        pageST.setAttribute("title", "some title");
        pageST.setAttribute("body", listST);
        String expecting = "some title" + newline + "Terence parrt@jguru.comTom tombu@jguru.com";
        String result = pageST.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testSizeZeroButNonNullListGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "begin\n$duh.users:{name: $it$}; separator=\", \"$\nend\n");
        t.setAttribute("duh", new Duh());
        String expecting = "begin\nend\n";
        String result = t.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testNullListGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "begin\n$users:{name: $it$}; separator=\", \"$\nend\n");
        String expecting = "begin\nend\n";
        String result = t.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmptyListGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "begin\n$users:{name: $it$}; separator=\", \"$\nend\n");
        t.setAttribute("users", new ArrayList());
        String expecting = "begin\nend\n";
        String result = t.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmptyListNoIteratorGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "begin\n$users; separator=\", \"$\nend\n");
        t.setAttribute("users", new ArrayList());
        String expecting = "begin\nend\n";
        String result = t.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmptyExprAsFirstLineGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        group.defineTemplate("bold", "<b>$it$</b>");
        StringTemplate t = new StringTemplate(group, "$users$\nend\n");
        String expecting = "end\n";
        String result = t.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testSizeZeroOnLineByItselfGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "begin\n$name$\n$users:{name: $it$}$\n$users:{name: $it$}; separator=\", \"$\nend\n");
        String expecting = "begin\nend\n";
        String result = t.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testSizeZeroOnLineWithIndentGetsNoOutput() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "begin\n  $name$\n\t$users:{name: $it$}$\n\t$users:{name: $it$$\\n$}$\nend\n");
        String expecting = "begin\nend\n";
        String result = t.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testSimpleAutoIndent() throws Exception {
        StringTemplate a = new StringTemplate("$title$: {\n\t$name; separator=\"\n\"$\n}");
        a.setAttribute("title", "foo");
        a.setAttribute("name", "Terence");
        a.setAttribute("name", "Frank");
        String results = a.toString();
        String expecting = "foo: {\n\tTerence\n\tFrank\n}";
        TestStringTemplate.assertEquals(results, expecting);
    }

    public void testComputedPropertyName() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        ErrorBuffer errors = new ErrorBuffer();
        group.setErrorListener(errors);
        StringTemplate t = new StringTemplate(group, "variable property $propName$=$v.(propName)$");
        t.setAttribute("v", new Decl("i", "int"));
        t.setAttribute("propName", "type");
        String expecting = "variable property type=int";
        String result = t.toString();
        TestStringTemplate.assertEquals("", ((Object)errors).toString());
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testNonNullButEmptyIteratorTestsFalse() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate t = new StringTemplate(group, "$if(users)$\nUsers: $users:{$it.name$ }$\n$endif$");
        t.setAttribute("users", new LinkedList());
        String expecting = "";
        String result = t.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testDoNotInheritAttributesThroughFormalArgs() throws Exception {
        String templates = "group test;" + newline + "method(name) ::= \"<stat()>\"" + newline + "stat(name) ::= \"x=y; // <name>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        String expecting = "x=y; // ";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testArgEvaluationContext() throws Exception {
        String templates = "group test;" + newline + "method(name) ::= \"<stat(name=name)>\"" + newline + "stat(name) ::= \"x=y; // <name>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        String expecting = "x=y; // foo";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testPassThroughAttributes() throws Exception {
        String templates = "group test;" + newline + "method(name) ::= \"<stat(...)>\"" + newline + "stat(name) ::= \"x=y; // <name>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        String expecting = "x=y; // foo";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testPassThroughAttributes2() throws Exception {
        String templates = "group test;" + newline + "method(name) ::= <<" + newline + "<stat(value=\"34\",...)>" + newline + ">>" + newline + "stat(name,value) ::= \"x=<value>; // <name>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        String expecting = "x=34; // foo";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testDefaultArgument() throws Exception {
        String templates = "group test;" + newline + "method(name) ::= <<" + newline + "<stat(...)>" + newline + ">>" + newline + "stat(name,value=\"99\") ::= \"x=<value>; // <name>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        String expecting = "x=99; // foo";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testDefaultArgument2() throws Exception {
        String templates = "group test;" + newline + "stat(name,value=\"99\") ::= \"x=<value>; // <name>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("stat");
        b.setAttribute("name", "foo");
        String expecting = "x=99; // foo";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testDefaultArgumentAsTemplate() throws Exception {
        String templates = "group test;" + newline + "method(name,size) ::= <<" + newline + "<stat(...)>" + newline + ">>" + newline + "stat(name,value={<name>}) ::= \"x=<value>; // <name>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        b.setAttribute("size", "2");
        String expecting = "x=foo; // foo";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testDefaultArgumentAsTemplate2() throws Exception {
        String templates = "group test;" + newline + "method(name,size) ::= <<" + newline + "<stat(...)>" + newline + ">>" + newline + "stat(name,value={ [<name>] }) ::= \"x=<value>; // <name>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        b.setAttribute("size", "2");
        String expecting = "x= [foo] ; // foo";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testDoNotUseDefaultArgument() throws Exception {
        String templates = "group test;" + newline + "method(name) ::= <<" + newline + "<stat(value=\"34\",...)>" + newline + ">>" + newline + "stat(name,value=\"99\") ::= \"x=<value>; // <name>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        String expecting = "x=34; // foo";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testArgumentsAsTemplates() throws Exception {
        String templates = "group test;" + newline + "method(name,size) ::= <<" + newline + "<stat(value={<size>})>" + newline + ">>" + newline + "stat(value) ::= \"x=<value>;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        b.setAttribute("size", "34");
        String expecting = "x=34;";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testArgumentsAsTemplatesDefaultDelimiters() throws Exception {
        String templates = "group test;" + newline + "method(name,size) ::= <<" + newline + "$stat(value={$size$})$" + newline + ">>" + newline + "stat(value) ::= \"x=$value$;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate b = group.getInstanceOf("method");
        b.setAttribute("name", "foo");
        b.setAttribute("size", "34");
        String expecting = "x=34;";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testDefaultArgsWhenNotInvoked() throws Exception {
        String templates = "group test;" + newline + "b(name=\"foo\") ::= \".<name>.\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate b = group.getInstanceOf("b");
        String expecting = ".foo.";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testRendererForST() throws Exception {
        StringTemplate st = new StringTemplate("date: <created>", AngleBracketTemplateLexer.class);
        st.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        st.registerRenderer(GregorianCalendar.class, new DateRenderer());
        String expecting = "date: 2005.07.05";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testRendererWithFormat() throws Exception {
        StringTemplate st = new StringTemplate("date: <created; format=\"yyyy.MM.dd\">", AngleBracketTemplateLexer.class);
        st.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        st.registerRenderer(GregorianCalendar.class, new DateRenderer3());
        String expecting = "date: 2005.07.05";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testRendererWithFormatAndList() throws Exception {
        StringTemplate st = new StringTemplate("The names: <names; format=\"upper\">", AngleBracketTemplateLexer.class);
        st.setAttribute("names", "ter");
        st.setAttribute("names", "tom");
        st.setAttribute("names", "sriram");
        st.registerRenderer(String.class, new StringRenderer());
        String expecting = "The names: TERTOMSRIRAM";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testRendererWithFormatAndSeparator() throws Exception {
        StringTemplate st = new StringTemplate("The names: <names; separator=\" and \", format=\"upper\">", AngleBracketTemplateLexer.class);
        st.setAttribute("names", "ter");
        st.setAttribute("names", "tom");
        st.setAttribute("names", "sriram");
        st.registerRenderer(String.class, new StringRenderer());
        String expecting = "The names: TER and TOM and SRIRAM";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testRendererWithFormatAndSeparatorAndNull() throws Exception {
        StringTemplate st = new StringTemplate("The names: <names; separator=\" and \", null=\"n/a\", format=\"upper\">", AngleBracketTemplateLexer.class);
        ArrayList<String> names = new ArrayList<String>();
        names.add("ter");
        names.add(null);
        names.add("sriram");
        st.setAttribute("names", names);
        st.registerRenderer(String.class, new StringRenderer());
        String expecting = "The names: TER and N/A and SRIRAM";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmbeddedRendererSeesEnclosing() throws Exception {
        StringTemplate outer = new StringTemplate("X: <x>", AngleBracketTemplateLexer.class);
        StringTemplate st = new StringTemplate("date: <created>", AngleBracketTemplateLexer.class);
        st.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        outer.setAttribute("x", st);
        outer.registerRenderer(GregorianCalendar.class, new DateRenderer());
        String expecting = "X: date: 2005.07.05";
        String result = outer.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testRendererForGroup() throws Exception {
        String templates = "group test;" + newline + "dateThing(created) ::= \"date: <created>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("dateThing");
        st.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        group.registerRenderer(GregorianCalendar.class, new DateRenderer());
        String expecting = "date: 2005.07.05";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testOverriddenRenderer() throws Exception {
        String templates = "group test;" + newline + "dateThing(created) ::= \"date: <created>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("dateThing");
        st.setAttribute("created", new GregorianCalendar(2005, 6, 5));
        group.registerRenderer(GregorianCalendar.class, new DateRenderer());
        st.registerRenderer(GregorianCalendar.class, new DateRenderer2());
        String expecting = "date: 07/05/2005";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMap() throws Exception {
        String templates = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("type", "int");
        st.setAttribute("name", "x");
        String expecting = "int x = 0;";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMapValuesAreTemplates() throws Exception {
        String templates = "group test;" + newline + "typeInit ::= [\"int\":\"0<w>\", \"float\":\"0.0<w>\"] " + newline + "var(type,w,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("w", "L");
        st.setAttribute("type", "int");
        st.setAttribute("name", "x");
        String expecting = "int x = 0L;";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMapMissingDefaultValueIsEmpty() throws Exception {
        String templates = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + newline + "var(type,w,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("w", "L");
        st.setAttribute("type", "double");
        st.setAttribute("name", "x");
        String expecting = "double x = ;";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMapHiddenByFormalArg() throws Exception {
        String templates = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + newline + "var(typeInit,type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("type", "int");
        st.setAttribute("name", "x");
        String expecting = "int x = ;";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMapEmptyValueAndAngleBracketStrings() throws Exception {
        String templates = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"float\":, \"double\":<<0.0L>>] " + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("type", "float");
        st.setAttribute("name", "x");
        String expecting = "float x = ;";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMapDefaultValue() throws Exception {
        String templates = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"default\":\"null\"] " + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("type", "UserRecord");
        st.setAttribute("name", "x");
        String expecting = "UserRecord x = null;";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMapEmptyDefaultValue() throws Exception {
        String templates = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"default\":] " + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("type", "UserRecord");
        st.setAttribute("name", "x");
        String expecting = "UserRecord x = ;";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMapEmptyDefaultValueIsKey() throws Exception {
        String templates = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"default\":key] " + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("type", "UserRecord");
        st.setAttribute("name", "x");
        String expecting = "UserRecord x = UserRecord;";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMapEmptyDefaultOnlyEntry() throws Exception {
        String templates = "group test;" + newline + "typeInit ::= [\"default\":key] " + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("var");
        st.setAttribute("type", "UserRecord");
        st.setAttribute("name", "x");
        String expecting = "UserRecord x = UserRecord;";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMapEmptyDefaultDefaultEntry() throws Exception {
        String templates = "group test;" + newline + "map ::= [default: \"default\"] " + newline + "t1() ::= \"<map.(1)>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("t1");
        String expecting = "default";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMapViaEnclosingTemplates() throws Exception {
        String templates = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + newline + "intermediate(type,name) ::= \"<var(...)>\"" + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("intermediate");
        st.setAttribute("type", "int");
        st.setAttribute("name", "x");
        String expecting = "int x = 0;";
        String result = st.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testMapViaEnclosingTemplates2() throws Exception {
        String templates = "group test;" + newline + "typeInit ::= [\"int\":\"0\", \"float\":\"0.0\"] " + newline + "intermediate(stuff) ::= \"<stuff>\"" + newline + "var(type,name) ::= \"<type> <name> = <typeInit.(type)>;\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate interm = group.getInstanceOf("intermediate");
        StringTemplate var = group.getInstanceOf("var");
        var.setAttribute("type", "int");
        var.setAttribute("name", "x");
        interm.setAttribute("stuff", var);
        String expecting = "int x = 0;";
        String result = interm.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmptyGroupTemplate() throws Exception {
        String templates = "group test;" + newline + "foo() ::= \"\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("foo");
        String expecting = "";
        String result = a.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmptyStringAndEmptyAnonTemplateAsParameterUsingAngleBracketLexer() throws Exception {
        String templates = "group test;" + newline + "top() ::= <<<x(a=\"\", b={})\\>>>" + newline + "x(a,b) ::= \"a=<a>, b=<b>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("top");
        String expecting = "a=, b=";
        String result = a.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testEmptyStringAndEmptyAnonTemplateAsParameterUsingDollarLexer() throws Exception {
        String templates = "group test;" + newline + "top() ::= <<$x(a=\"\", b={})$>>" + newline + "x(a,b) ::= \"a=$a$, b=$b$\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate a = group.getInstanceOf("top");
        String expecting = "a=, b=";
        String result = a.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void test8BitEuroChars() throws Exception {
        StringTemplate e = new StringTemplate("Danish: \u0143 char");
        e = e.getInstanceOf();
        String expecting = "Danish: \u0143 char";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void test16BitUnicodeChar() throws Exception {
        StringTemplate e = new StringTemplate("DINGBAT CIRCLED SANS-SERIF DIGIT ONE: \u2780");
        e = e.getInstanceOf();
        String expecting = "DINGBAT CIRCLED SANS-SERIF DIGIT ONE: \u2780";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testFirstOp() throws Exception {
        StringTemplate e = new StringTemplate("$first(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("names", "Sriram");
        String expecting = "Ter";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testRestOp() throws Exception {
        StringTemplate e = new StringTemplate("$rest(names); separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("names", "Sriram");
        String expecting = "Tom, Sriram";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testLastOp() throws Exception {
        StringTemplate e = new StringTemplate("$last(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("names", "Sriram");
        String expecting = "Sriram";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testCombinedOp() throws Exception {
        StringTemplate e = new StringTemplate("$[first(mine),rest(yours)]; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("mine", "1");
        e.setAttribute("mine", "2");
        e.setAttribute("mine", "3");
        e.setAttribute("yours", "a");
        e.setAttribute("yours", "b");
        String expecting = "1, b";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testCatListAndSingleAttribute() throws Exception {
        StringTemplate e = new StringTemplate("$[mine,yours]; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("mine", "1");
        e.setAttribute("mine", "2");
        e.setAttribute("mine", "3");
        e.setAttribute("yours", "a");
        String expecting = "1, 2, 3, a";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testCatListAndEmptyAttributes() throws Exception {
        StringTemplate e = new StringTemplate("$[x,mine,y,yours,z]; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("mine", "1");
        e.setAttribute("mine", "2");
        e.setAttribute("mine", "3");
        e.setAttribute("yours", "a");
        String expecting = "1, 2, 3, a";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testNestedOp() throws Exception {
        StringTemplate e = new StringTemplate("$first(rest(names))$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("names", "Sriram");
        String expecting = "Tom";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testFirstWithOneAttributeOp() throws Exception {
        StringTemplate e = new StringTemplate("$first(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        String expecting = "Ter";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testLastWithOneAttributeOp() throws Exception {
        StringTemplate e = new StringTemplate("$last(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        String expecting = "Ter";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testLastWithLengthOneListAttributeOp() throws Exception {
        StringTemplate e = new StringTemplate("$last(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", new ArrayList(){
            {
                this.add("Ter");
            }
        });
        String expecting = "Ter";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testRestWithOneAttributeOp() throws Exception {
        StringTemplate e = new StringTemplate("$rest(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        String expecting = "";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testRestWithLengthOneListAttributeOp() throws Exception {
        StringTemplate e = new StringTemplate("$rest(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", new ArrayList(){
            {
                this.add("Ter");
            }
        });
        String expecting = "";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testRepeatedRestOp() throws Exception {
        StringTemplate e = new StringTemplate("$rest(names)$, $rest(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "Tom, Tom";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testRepeatedIteratedAttrFromArg() throws Exception {
        String templates = "group test;" + newline + "root(names) ::= \"$other(names)$\"" + newline + "other(x) ::= \"$x$, $x$\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate e = group.getInstanceOf("root");
        ArrayList<String> names = new ArrayList<String>();
        names.add("Ter");
        names.add("Tom");
        e.setAttribute("names", names.iterator());
        String expecting = "TerTom, ";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testRepeatedRestOpAsArg() throws Exception {
        String templates = "group test;" + newline + "root(names) ::= \"$other(rest(names))$\"" + newline + "other(x) ::= \"$x$, $x$\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate e = group.getInstanceOf("root");
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "Tom, Tom";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testIncomingLists() throws Exception {
        StringTemplate e = new StringTemplate("$rest(names)$, $rest(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "Tom, Tom";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testIncomingListsAreNotModified() throws Exception {
        StringTemplate e = new StringTemplate("$names; separator=\", \"$");
        e = e.getInstanceOf();
        ArrayList<String> names = new ArrayList<String>();
        names.add("Ter");
        names.add("Tom");
        e.setAttribute("names", names);
        e.setAttribute("names", "Sriram");
        String expecting = "Ter, Tom, Sriram";
        TestStringTemplate.assertEquals(expecting, e.toString());
        TestStringTemplate.assertEquals((int)names.size(), (int)2);
    }

    public void testIncomingListsAreNotModified2() throws Exception {
        StringTemplate e = new StringTemplate("$names; separator=\", \"$");
        e = e.getInstanceOf();
        ArrayList<String> names = new ArrayList<String>();
        names.add("Ter");
        names.add("Tom");
        e.setAttribute("names", "Sriram");
        e.setAttribute("names", names);
        String expecting = "Sriram, Ter, Tom";
        TestStringTemplate.assertEquals(expecting, e.toString());
        TestStringTemplate.assertEquals((int)names.size(), (int)2);
    }

    public void testIncomingArraysAreOk() throws Exception {
        StringTemplate e = new StringTemplate("$names; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", (Object)new String[]{"Ter", "Tom"});
        e.setAttribute("names", "Sriram");
        String expecting = "Ter, Tom, Sriram";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testApplyTemplateWithSingleFormalArgs() throws Exception {
        String templates = "group test;" + newline + "test(names) ::= <<<names:bold(item=it); separator=\", \"> >>" + newline + "bold(item) ::= <<*<item>*>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "*Ter*, *Tom* ";
        String result = e.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testApplyTemplateWithNoFormalArgs() throws Exception {
        String templates = "group test;" + newline + "test(names) ::= <<<names:bold(); separator=\", \"> >>" + newline + "bold() ::= <<*<it>*>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), AngleBracketTemplateLexer.class);
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "*Ter*, *Tom* ";
        String result = e.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testAnonTemplateArgs() throws Exception {
        StringTemplate e = new StringTemplate("$names:{n| $n$}; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "Ter, Tom";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testAnonTemplateWithArgHasNoITArg() throws Exception {
        StringTemplate e = new StringTemplate("$names:{n| $n$:$it$}; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String error = null;
        try {
            e.toString();
        }
        catch (NoSuchElementException nse) {
            error = nse.getMessage();
        }
        String expecting = "no such attribute: it in template context [anonymous anonymous]";
        TestStringTemplate.assertEquals(error, expecting);
    }

    public void testAnonTemplateArgs2() throws Exception {
        StringTemplate e = new StringTemplate("$names:{n| .$n$.}:{ n | _$n$_}; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "_.Ter._, _.Tom._";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testFirstWithCatAttribute() throws Exception {
        StringTemplate e = new StringTemplate("$first([names,phones])$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        String expecting = "Ter";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testJustCat() throws Exception {
        StringTemplate e = new StringTemplate("$[names,phones]$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        String expecting = "TerTom12";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testCat2Attributes() throws Exception {
        StringTemplate e = new StringTemplate("$[names,phones]; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        String expecting = "Ter, Tom, 1, 2";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testCat2AttributesWithApply() throws Exception {
        StringTemplate e = new StringTemplate("$[names,phones]:{a|$a$.}$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        String expecting = "Ter.Tom.1.2.";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testCat3Attributes() throws Exception {
        StringTemplate e = new StringTemplate("$[names,phones,salaries]; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        e.setAttribute("salaries", "big");
        e.setAttribute("salaries", "huge");
        String expecting = "Ter, Tom, 1, 2, big, huge";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testListAsTemplateArgument() throws Exception {
        String templates = "group test;" + newline + "test(names,phones) ::= \"<foo([names,phones])>\"" + newline + "foo(items) ::= \"<items:{a | *<a>*}>\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), AngleBracketTemplateLexer.class);
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        String expecting = "*Ter**Tom**1**2*";
        String result = e.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testSingleExprTemplateArgument() throws Exception {
        String templates = "group test;" + newline + "test(name) ::= \"<bold(name)>\"" + newline + "bold(item) ::= \"*<item>*\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), AngleBracketTemplateLexer.class);
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("name", "Ter");
        String expecting = "*Ter*";
        String result = e.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testSingleExprTemplateArgumentInApply() throws Exception {
        String templates = "group test;" + newline + "test(names,x) ::= \"<names:bold(x)>\"" + newline + "bold(item) ::= \"*<item>*\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), AngleBracketTemplateLexer.class);
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("x", "ick");
        String expecting = "*ick**ick*";
        String result = e.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testSoleFormalTemplateArgumentInMultiApply() throws Exception {
        String templates = "group test;" + newline + "test(names) ::= \"<names:bold(),italics()>\"" + newline + "bold(x) ::= \"*<x>*\"" + newline + "italics(y) ::= \"_<y>_\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), AngleBracketTemplateLexer.class);
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        String expecting = "*Ter*_Tom_";
        String result = e.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testSingleExprTemplateArgumentError() throws Exception {
        String templates = "group test;" + newline + "test(name) ::= \"<bold(name)>\"" + newline + "bold(item,ick) ::= \"*<item>*\"" + newline;
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates), AngleBracketTemplateLexer.class, errors);
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("name", "Ter");
        e.toString();
        String expecting = "template bold must have exactly one formal arg in template context [test <invoke bold arg context>]";
        TestStringTemplate.assertEquals(((Object)errors).toString(), expecting);
    }

    public void testInvokeIndirectTemplateWithSingleFormalArgs() throws Exception {
        String templates = "group test;" + newline + "test(templateName,arg) ::= \"<(templateName)(arg)>\"" + newline + "bold(x) ::= <<*<x>*>>" + newline + "italics(y) ::= <<_<y>_>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate e = group.getInstanceOf("test");
        e.setAttribute("templateName", "italics");
        e.setAttribute("arg", "Ter");
        String expecting = "_Ter_";
        String result = e.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testParallelAttributeIteration() throws Exception {
        StringTemplate e = new StringTemplate("$names,phones,salaries:{n,p,s | $n$@$p$: $s$\n}$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        e.setAttribute("salaries", "big");
        e.setAttribute("salaries", "huge");
        String expecting = "Ter@1: big" + newline + "Tom@2: huge" + newline;
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testParallelAttributeIterationHasI() throws Exception {
        StringTemplate e = new StringTemplate("$names,phones,salaries:{n,p,s | $i0$. $n$@$p$: $s$\n}$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        e.setAttribute("salaries", "big");
        e.setAttribute("salaries", "huge");
        String expecting = "0. Ter@1: big" + newline + "1. Tom@2: huge" + newline;
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testParallelAttributeIterationWithDifferentSizes() throws Exception {
        StringTemplate e = new StringTemplate("$names,phones,salaries:{n,p,s | $n$@$p$: $s$}; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("names", "Sriram");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        e.setAttribute("salaries", "big");
        String expecting = "Ter@1: big, Tom@2: , Sriram@: ";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testParallelAttributeIterationWithSingletons() throws Exception {
        StringTemplate e = new StringTemplate("$names,phones,salaries:{n,p,s | $n$@$p$: $s$}; separator=\", \"$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("phones", "1");
        e.setAttribute("salaries", "big");
        String expecting = "Ter@1: big";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testParallelAttributeIterationWithMismatchArgListSizes() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplate e = new StringTemplate("$names,phones,salaries:{n,p | $n$@$p$}; separator=\", \"$");
        e.setErrorListener(errors);
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "1");
        e.setAttribute("phones", "2");
        e.setAttribute("salaries", "big");
        String expecting = "Ter@1, Tom@2";
        TestStringTemplate.assertEquals(expecting, e.toString());
        String errorExpecting = "number of arguments [n, p] mismatch between attribute list and anonymous template in context [anonymous]";
        TestStringTemplate.assertEquals(errorExpecting, ((Object)errors).toString());
    }

    public void testParallelAttributeIterationWithMissingArgs() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        StringTemplate e = new StringTemplate("$names,phones,salaries:{$n$@$p$}; separator=\", \"$");
        e.setErrorListener(errors);
        e = e.getInstanceOf();
        e.setAttribute("names", "Tom");
        e.setAttribute("phones", "2");
        e.setAttribute("salaries", "big");
        e.toString();
        String errorExpecting = "missing arguments in anonymous template in context [anonymous]";
        TestStringTemplate.assertEquals(errorExpecting, ((Object)errors).toString());
    }

    public void testParallelAttributeIterationWithDifferentSizesTemplateRefInsideToo() throws Exception {
        String templates = "group test;" + newline + "page(names,phones,salaries) ::= " + newline + "\t<<$names,phones,salaries:{n,p,s | $value(n)$@$value(p)$: $value(s)$}; separator=\", \"$>>" + newline + "value(x=\"n/a\") ::= \"$x$\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup((Reader)new StringReader(templates), DefaultTemplateLexer.class);
        StringTemplate p = group.getInstanceOf("page");
        p.setAttribute("names", "Ter");
        p.setAttribute("names", "Tom");
        p.setAttribute("names", "Sriram");
        p.setAttribute("phones", "1");
        p.setAttribute("phones", "2");
        p.setAttribute("salaries", "big");
        String expecting = "Ter@1: big, Tom@2: n/a, Sriram@n/a: n/a";
        TestStringTemplate.assertEquals(expecting, p.toString());
    }

    public void testAnonTemplateOnLeftOfApply() throws Exception {
        StringTemplate e = new StringTemplate("${foo}:{($it$)}$");
        String expecting = "(foo)";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testOverrideThroughConditional() throws Exception {
        String templates = "group base;" + newline + "body(ick) ::= \"<if(ick)>ick<f()><else><f()><endif>\"" + "f() ::= \"foo\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        String templates2 = "group sub;" + newline + "f() ::= \"bar\"" + newline;
        StringTemplateGroup subgroup = new StringTemplateGroup(new StringReader(templates2), AngleBracketTemplateLexer.class, null, group);
        StringTemplate b = subgroup.getInstanceOf("body");
        String expecting = "bar";
        String result = b.toString();
        TestStringTemplate.assertEquals(expecting, result);
    }

    public void testNonPublicPropertyAccess() throws Exception {
        StringTemplate st = new StringTemplate("$x.foo$:$x.bar$");
        Object o = new Object(){
            public int foo = 9;

            public int getBar() {
                return 34;
            }
        };
        st.setAttribute("x", o);
        String expecting = "9:34";
        TestStringTemplate.assertEquals(expecting, st.toString());
    }

    public void testIndexVar() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "$A:{$i$. $it$}; separator=\"\\n\"$");
        t.setAttribute("A", "parrt");
        t.setAttribute("A", "tombu");
        String expecting = "1. parrt" + newline + "2. tombu";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testIndex0Var() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "$A:{$i0$. $it$}; separator=\"\\n\"$");
        t.setAttribute("A", "parrt");
        t.setAttribute("A", "tombu");
        String expecting = "0. parrt" + newline + "1. tombu";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testIndexVarWithMultipleExprs() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "$A,B:{a,b|$i$. $a$@$b$}; separator=\"\\n\"$");
        t.setAttribute("A", "parrt");
        t.setAttribute("A", "tombu");
        t.setAttribute("B", "x5707");
        t.setAttribute("B", "x5000");
        String expecting = "1. parrt@x5707" + newline + "2. tombu@x5000";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testIndex0VarWithMultipleExprs() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "$A,B:{a,b|$i0$. $a$@$b$}; separator=\"\\n\"$");
        t.setAttribute("A", "parrt");
        t.setAttribute("A", "tombu");
        t.setAttribute("B", "x5707");
        t.setAttribute("B", "x5000");
        String expecting = "0. parrt@x5707" + newline + "1. tombu@x5000";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testArgumentContext() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate main = group.defineTemplate("main", "$foo(t={Hi, $name$}, name=\"parrt\")$");
        group.defineTemplate("foo", "$t$");
        String expecting = "Hi, parrt";
        TestStringTemplate.assertEquals(expecting, main.toString());
    }

    public void testNoDotsInAttributeNames() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".");
        StringTemplate t = new StringTemplate(group, "$user.Name$");
        String error = null;
        try {
            t.setAttribute("user.Name", "Kunle");
        }
        catch (IllegalArgumentException e) {
            error = e.getMessage();
        }
        String expecting = "cannot have '.' in attribute names";
        TestStringTemplate.assertEquals(expecting, error);
    }

    public void testNoDotsInTemplateNames() throws Exception {
        ErrorBuffer errors = new ErrorBuffer();
        String templates = "group test;" + newline + "a.b() ::= <<foo>>" + newline;
        new StringTemplateGroup(new StringReader(templates), DefaultTemplateLexer.class, errors);
        String expecting = "template group parse error: line 2:1: unexpected token:";
        TestStringTemplate.assertTrue((boolean)((Object)errors).toString().startsWith(expecting));
    }

    public void testLineWrap() throws Exception {
        String templates = "group test;" + newline + "array(values) ::= <<int[] a = { <values; wrap=\"\\n\", separator=\",\"> };>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("array");
        a.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 6, 32, 5, 6, 77, 3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 1, 6, 32, 5});
        String expecting = "int[] a = { 3,9,20,2,1,4,6,32,5,6,77,888,\n2,1,6,32,5,6,77,4,9,20,2,1,4,63,9,20,2,1,\n4,6,32,5,6,77,6,32,5,6,77,3,9,20,2,1,4,6,\n32,5,6,77,888,1,6,32,5 };";
        TestStringTemplate.assertEquals(expecting, a.toString(40));
    }

    public void testLineWrapAnchored() throws Exception {
        String templates = "group test;" + newline + "array(values) ::= <<int[] a = { <values; anchor, wrap=\"\\n\", separator=\",\"> };>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("array");
        a.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 6, 32, 5, 6, 77, 3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 1, 6, 32, 5});
        String expecting = "int[] a = { 3,9,20,2,1,4,6,32,5,6,77,888,\n            2,1,6,32,5,6,77,4,9,20,2,1,4,\n            63,9,20,2,1,4,6,32,5,6,77,6,\n            32,5,6,77,3,9,20,2,1,4,6,32,\n            5,6,77,888,1,6,32,5 };";
        TestStringTemplate.assertEquals(expecting, a.toString(40));
    }

    public void testFortranLineWrap() throws Exception {
        String templates = "group test;" + newline + "func(args) ::= <<       FUNCTION line( <args; wrap=\"\\n      c\", separator=\",\"> )>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("func");
        a.setAttribute("args", (Object)new String[]{"a", "b", "c", "d", "e", "f"});
        String expecting = "       FUNCTION line( a,b,c,d,\n      ce,f )";
        TestStringTemplate.assertEquals(expecting, a.toString(30));
    }

    public void testLineWrapWithDiffAnchor() throws Exception {
        String templates = "group test;" + newline + "array(values) ::= <<int[] a = { <{1,9,2,<values; wrap, separator=\",\">}; anchor> };>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("array");
        a.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6});
        String expecting = "int[] a = { 1,9,2,3,9,20,2,1,4,\n            6,32,5,6,77,888,2,\n            1,6,32,5,6,77,4,9,\n            20,2,1,4,63,9,20,2,\n            1,4,6 };";
        TestStringTemplate.assertEquals(expecting, a.toString(30));
    }

    public void testLineWrapEdgeCase() throws Exception {
        String templates = "group test;" + newline + "duh(chars) ::= <<<chars; wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        String expecting = "abc\nde";
        TestStringTemplate.assertEquals(expecting, a.toString(3));
    }

    public void testLineWrapLastCharIsNewline() throws Exception {
        String templates = "group test;" + newline + "duh(chars) ::= <<<chars; wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("chars", (Object)new String[]{"a", "b", "\n", "d", "e"});
        String expecting = "ab\nde";
        TestStringTemplate.assertEquals(expecting, a.toString(3));
    }

    public void testLineWrapCharAfterWrapIsNewline() throws Exception {
        String templates = "group test;" + newline + "duh(chars) ::= <<<chars; wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("chars", (Object)new String[]{"a", "b", "c", "\n", "d", "e"});
        String expecting = "abc\n\nde";
        TestStringTemplate.assertEquals(expecting, a.toString(3));
    }

    public void testLineWrapForAnonTemplate() throws Exception {
        String templates = "group test;" + newline + "duh(data) ::= <<!<data:{v|[<v>]}; wrap>!>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("data", (Object)new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        String expecting = "![1][2][3]\n[4][5][6]\n[7][8][9]!";
        TestStringTemplate.assertEquals(expecting, a.toString(9));
    }

    public void testLineWrapForAnonTemplateAnchored() throws Exception {
        String templates = "group test;" + newline + "duh(data) ::= <<!<data:{v|[<v>]}; anchor, wrap>!>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("data", (Object)new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        String expecting = "![1][2][3]\n [4][5][6]\n [7][8][9]!";
        TestStringTemplate.assertEquals(expecting, a.toString(9));
    }

    public void testLineWrapForAnonTemplateComplicatedWrap() throws Exception {
        String templates = "group test;" + newline + "top(s) ::= <<  <s>.>>" + "str(data) ::= <<!<data:{v|[<v>]}; wrap=\"!+\\n!\">!>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate t = group.getInstanceOf("top");
        StringTemplate s = group.getInstanceOf("str");
        s.setAttribute("data", (Object)new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        t.setAttribute("s", s);
        String expecting = "  ![1][2]!+\n  ![3][4]!+\n  ![5][6]!+\n  ![7][8]!+\n  ![9]!.";
        TestStringTemplate.assertEquals(expecting, t.toString(9));
    }

    public void testIndentBeyondLineWidth() throws Exception {
        String templates = "group test;" + newline + "duh(chars) ::= <<    <chars; wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        String expecting = "    a\n    b\n    c\n    d\n    e";
        TestStringTemplate.assertEquals(expecting, a.toString(2));
    }

    public void testIndentedExpr() throws Exception {
        String templates = "group test;" + newline + "duh(chars) ::= <<    <chars; wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("duh");
        a.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        String expecting = "    ab\n    cd\n    e";
        TestStringTemplate.assertEquals(expecting, a.toString(6));
    }

    public void testNestedIndentedExpr() throws Exception {
        String templates = "group test;" + newline + "top(d) ::= <<  <d>!>>" + newline + "duh(chars) ::= <<  <chars; wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate top = group.getInstanceOf("top");
        StringTemplate duh = group.getInstanceOf("duh");
        duh.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        top.setAttribute("d", duh);
        String expecting = "    ab\n    cd\n    e!";
        TestStringTemplate.assertEquals(expecting, top.toString(6));
    }

    public void testNestedWithIndentAndTrackStartOfExpr() throws Exception {
        String templates = "group test;" + newline + "top(d) ::= <<  <d>!>>" + newline + "duh(chars) ::= <<x: <chars; anchor, wrap=\"\\n\"\\>>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate top = group.getInstanceOf("top");
        StringTemplate duh = group.getInstanceOf("duh");
        duh.setAttribute("chars", (Object)new String[]{"a", "b", "c", "d", "e"});
        top.setAttribute("d", duh);
        String expecting = "  x: ab\n     cd\n     e!";
        TestStringTemplate.assertEquals(expecting, top.toString(7));
    }

    public void testLineDoesNotWrapDueToLiteral() throws Exception {
        String templates = "group test;" + newline + "m(args,body) ::= <<public void foo(<args; wrap=\"\\n\",separator=\", \">) throws Ick { <body> }>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate a = group.getInstanceOf("m");
        a.setAttribute("args", (Object)new String[]{"a", "b", "c"});
        a.setAttribute("body", "i=3;");
        int n = "public void foo(a, b, c".length();
        String expecting = "public void foo(a, b, c) throws Ick { i=3; }";
        TestStringTemplate.assertEquals(expecting, a.toString(n));
    }

    public void testSingleValueWrap() throws Exception {
        String templates = "group test;" + newline + "m(args,body) ::= <<{ <body; anchor, wrap=\"\\n\"> }>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate m = group.getInstanceOf("m");
        m.setAttribute("body", "i=3;");
        String expecting = "{ \n  i=3; }";
        TestStringTemplate.assertEquals(expecting, m.toString(2));
    }

    public void testLineWrapInNestedExpr() throws Exception {
        String templates = "group test;" + newline + "top(arrays) ::= <<Arrays: <arrays>done>>" + newline + "array(values) ::= <<int[] a = { <values; anchor, wrap=\"\\n\", separator=\",\"> };<\\n\\>>>" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate top = group.getInstanceOf("top");
        StringTemplate a = group.getInstanceOf("array");
        a.setAttribute("values", (Object)new int[]{3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 2, 1, 6, 32, 5, 6, 77, 4, 9, 20, 2, 1, 4, 63, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 6, 32, 5, 6, 77, 3, 9, 20, 2, 1, 4, 6, 32, 5, 6, 77, 888, 1, 6, 32, 5});
        top.setAttribute("arrays", a);
        top.setAttribute("arrays", a);
        String expecting = "Arrays: int[] a = { 3,9,20,2,1,4,6,32,5,\n                    6,77,888,2,1,6,32,5,\n                    6,77,4,9,20,2,1,4,63,\n                    9,20,2,1,4,6,32,5,6,\n                    77,6,32,5,6,77,3,9,20,\n                    2,1,4,6,32,5,6,77,888,\n                    1,6,32,5 };\nint[] a = { 3,9,20,2,1,4,6,32,5,6,77,888,\n            2,1,6,32,5,6,77,4,9,20,2,1,4,\n            63,9,20,2,1,4,6,32,5,6,77,6,\n            32,5,6,77,3,9,20,2,1,4,6,32,\n            5,6,77,888,1,6,32,5 };\ndone";
        TestStringTemplate.assertEquals(expecting, top.toString(40));
    }

    public void testEscapeEscape() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test");
        StringTemplate t = group.defineTemplate("t", "\\\\$v$");
        t.setAttribute("v", "Joe");
        String expecting = "\\Joe";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testEscapeEscapeNestedAngle() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<v:{a|\\\\<a>}>");
        t.setAttribute("v", "Joe");
        String expecting = "\\Joe";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testListOfIntArrays() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data:array()>");
        group.defineTemplate("array", "[<it:element(); separator=\",\">]");
        group.defineTemplate("element", "<it>");
        ArrayList<int[]> data = new ArrayList<int[]>();
        data.add(new int[]{1, 2, 3});
        data.add(new int[]{10, 20, 30});
        t.setAttribute("data", data);
        String expecting = "[1,2,3][10,20,30]";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testNullOptionSingleNullValue() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data; null=\"0\">");
        String expecting = "0";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testNullOptionHasEmptyNullValue() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data; null=\"\", separator=\", \">");
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(null);
        data.add(new Integer(1));
        t.setAttribute("data", data);
        String expecting = ", 1";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testNullOptionSingleNullValueInList() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data; null=\"0\">");
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(null);
        t.setAttribute("data", data);
        String expecting = "0";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testNullValueInList() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data; null=\"-1\", separator=\", \">");
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(null);
        data.add(new Integer(1));
        data.add(null);
        data.add(new Integer(3));
        data.add(new Integer(4));
        data.add(null);
        t.setAttribute("data", data);
        String expecting = "-1, 1, -1, 3, 4, -1";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testNullValueInListNoNullOption() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data; separator=\", \">");
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(null);
        data.add(new Integer(1));
        data.add(null);
        data.add(new Integer(3));
        data.add(new Integer(4));
        data.add(null);
        t.setAttribute("data", data);
        String expecting = "1, 3, 4";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testNullValueInListWithTemplateApply() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        group.defineTemplate("array", "<it>");
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(new Integer(0));
        data.add(null);
        data.add(new Integer(2));
        data.add(null);
        t.setAttribute("data", data);
        String expecting = "0, -1, 2, -1";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testNullValueInListWithTemplateApplyNullFirstValue() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        group.defineTemplate("array", "<it>");
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(null);
        data.add(new Integer(0));
        data.add(null);
        data.add(new Integer(2));
        t.setAttribute("data", data);
        String expecting = "-1, 0, -1, 2";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testNullSingleValueInListWithTemplateApply() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        group.defineTemplate("array", "<it>");
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(null);
        t.setAttribute("data", data);
        String expecting = "-1";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testNullSingleValueWithTemplateApply() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("test", AngleBracketTemplateLexer.class);
        StringTemplate t = group.defineTemplate("t", "<data:array(); null=\"-1\", separator=\", \">");
        group.defineTemplate("array", "<it>");
        String expecting = "-1";
        TestStringTemplate.assertEquals(expecting, t.toString());
    }

    public void testLengthOp() throws Exception {
        StringTemplate e = new StringTemplate("$length(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        e.setAttribute("names", "Tom");
        e.setAttribute("names", "Sriram");
        String expecting = "3";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testLengthOpWithMap() throws Exception {
        StringTemplate e = new StringTemplate("$length(names)$");
        e = e.getInstanceOf();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("Tom", "foo");
        m.put("Sriram", "foo");
        m.put("Doug", "foo");
        e.setAttribute("names", m);
        String expecting = "3";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testLengthOpWithSet() throws Exception {
        StringTemplate e = new StringTemplate("$length(names)$");
        e = e.getInstanceOf();
        HashSet<String> m = new HashSet<String>();
        m.add("Tom");
        m.add("Sriram");
        m.add("Doug");
        e.setAttribute("names", m);
        String expecting = "3";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testLengthOpNull() throws Exception {
        StringTemplate e = new StringTemplate("$length(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", (Object)null);
        String expecting = "0";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testLengthOpSingleValue() throws Exception {
        StringTemplate e = new StringTemplate("$length(names)$");
        e = e.getInstanceOf();
        e.setAttribute("names", "Ter");
        String expecting = "1";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testLengthOpPrimitive() throws Exception {
        StringTemplate e = new StringTemplate("$length(ints)$");
        e = e.getInstanceOf();
        e.setAttribute("ints", (Object)new int[]{1, 2, 3, 4});
        String expecting = "4";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testLengthOpOfListWithNulls() throws Exception {
        StringTemplate e = new StringTemplate("$length(data)$");
        e = e.getInstanceOf();
        ArrayList<String> data = new ArrayList<String>();
        data.add("Hi");
        data.add(null);
        data.add("mom");
        data.add(null);
        e.setAttribute("data", data);
        String expecting = "4";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testStripOpOfListWithNulls() throws Exception {
        StringTemplate e = new StringTemplate("$strip(data)$");
        e = e.getInstanceOf();
        ArrayList<String> data = new ArrayList<String>();
        data.add("Hi");
        data.add(null);
        data.add("mom");
        data.add(null);
        e.setAttribute("data", data);
        String expecting = "Himom";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testStripOpOfListOfListsWithNulls() throws Exception {
        StringTemplate e = new StringTemplate("$strip(data):{list | $strip(list)$}; separator=\",\"$");
        e = e.getInstanceOf();
        ArrayList data = new ArrayList();
        ArrayList<String> dataOne = new ArrayList<String>();
        dataOne.add("Hi");
        dataOne.add("mom");
        data.add(dataOne);
        data.add(null);
        ArrayList<String> dataTwo = new ArrayList<String>();
        dataTwo.add("Hi");
        dataTwo.add(null);
        dataTwo.add("dad");
        dataTwo.add(null);
        data.add(dataTwo);
        e.setAttribute("data", data);
        String expecting = "Himom,Hidad";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testStripOpOfSingleAlt() throws Exception {
        StringTemplate e = new StringTemplate("$strip(data)$");
        e = e.getInstanceOf();
        e.setAttribute("data", "hi");
        String expecting = "hi";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testStripOpOfNull() throws Exception {
        StringTemplate e = new StringTemplate("$strip(data)$");
        e = e.getInstanceOf();
        String expecting = "";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testLengthOpOfStrippedListWithNulls() throws Exception {
        StringTemplate e = new StringTemplate("$length(strip(data))$");
        e = e.getInstanceOf();
        ArrayList<String> data = new ArrayList<String>();
        data.add("Hi");
        data.add(null);
        data.add("mom");
        data.add(null);
        e.setAttribute("data", data);
        String expecting = "2";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testLengthOpOfStrippedListWithNullsFrontAndBack() throws Exception {
        StringTemplate e = new StringTemplate("$length(strip(data))$");
        e = e.getInstanceOf();
        ArrayList<String> data = new ArrayList<String>();
        data.add(null);
        data.add(null);
        data.add(null);
        data.add("Hi");
        data.add(null);
        data.add(null);
        data.add(null);
        data.add("mom");
        data.add(null);
        data.add(null);
        data.add(null);
        e.setAttribute("data", data);
        String expecting = "2";
        TestStringTemplate.assertEquals(expecting, e.toString());
    }

    public void testMapKeys() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate t = new StringTemplate(group, "<aMap.keys:{k|<k>:<aMap.(k)>}; separator=\", \">");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("int", "0");
        map.put("float", "0.0");
        t.setAttribute("aMap", map);
        TestStringTemplate.assertEquals("int:0, float:0.0", t.toString());
    }

    public void testMapValues() throws Exception {
        StringTemplateGroup group = new StringTemplateGroup("dummy", ".", AngleBracketTemplateLexer.class);
        StringTemplate t = new StringTemplate(group, "<aMap.values; separator=\", \">");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("int", "0");
        map.put("float", "0.0");
        t.setAttribute("aMap", map);
        TestStringTemplate.assertEquals("0, 0.0", t.toString());
    }

    public void testGroupTrailingSemiColon() throws Exception {
        String templates = "group test;" + newline + "t1()::=\"R1\"; " + newline + "t2() ::= \"R2\"" + newline;
        StringTemplateGroup group = new StringTemplateGroup(new StringReader(templates));
        StringTemplate st = group.getInstanceOf("t1");
        TestStringTemplate.assertEquals("R1", st.toString());
        st = group.getInstanceOf("t2");
        TestStringTemplate.assertEquals("R2", st.toString());
        TestStringTemplate.fail((String)"A parse error should have been generated");
    }

    public static void writeFile(String dir, String fileName, String content) {
        try {
            File f = new File(dir, fileName);
            FileWriter w = new FileWriter(f);
            BufferedWriter bw = new BufferedWriter(w);
            bw.write(content);
            bw.close();
            w.close();
        }
        catch (IOException ioe) {
            System.err.println("can't write file");
            ioe.printStackTrace(System.err);
        }
    }

    public static class NonPublicProperty {
    }

    public class StringRenderer
    implements AttributeRenderer {
        public String toString(Object o) {
            return (String)o;
        }

        public String toString(Object o, String formatString) {
            if (formatString.equals("upper")) {
                return ((String)o).toUpperCase();
            }
            return this.toString(o);
        }
    }

    public class DateRenderer3
    implements AttributeRenderer {
        public String toString(Object o) {
            SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy");
            return f.format(((Calendar)o).getTime());
        }

        public String toString(Object o, String formatString) {
            SimpleDateFormat f = new SimpleDateFormat(formatString);
            return f.format(((Calendar)o).getTime());
        }
    }

    public class DateRenderer2
    implements AttributeRenderer {
        public String toString(Object o) {
            SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy");
            return f.format(((Calendar)o).getTime());
        }

        public String toString(Object o, String formatString) {
            return this.toString(o);
        }
    }

    public class DateRenderer
    implements AttributeRenderer {
        public String toString(Object o) {
            SimpleDateFormat f = new SimpleDateFormat("yyyy.MM.dd");
            return f.format(((Calendar)o).getTime());
        }

        public String toString(Object o, String formatString) {
            return this.toString(o);
        }
    }

    static class Duh {
        public List users = new ArrayList();

        Duh() {
        }
    }

    public static class Decl {
        String name;
        String type;

        public Decl(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public class Connector3 {
        public int[] getValues() {
            return new int[]{1, 2, 3};
        }

        public Map getStuff() {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("a", "1");
            m.put("b", "2");
            return m;
        }
    }

    public static class Tree {
        protected List children = new LinkedList();
        protected String text;

        public Tree(String t) {
            this.text = t;
        }

        public String getText() {
            return this.text;
        }

        public void addChild(Tree c) {
            this.children.add(c);
        }

        public Tree getFirstChild() {
            if (this.children.size() == 0) {
                return null;
            }
            return (Tree)this.children.get(0);
        }

        public List getChildren() {
            return this.children;
        }
    }

    public class Connector2 {
        public int getID() {
            return 2;
        }

        public String getFirstName() {
            return "Tom";
        }

        public String getLastName() {
            return "Burns";
        }

        public String getEmail() {
            return "tombu@jguru.com";
        }

        public String getBio() {
            return "Superhero by day...";
        }

        public Boolean getCanEdit() {
            return new Boolean(true);
        }
    }

    public class Connector {
        public int getID() {
            return 1;
        }

        public String getFirstName() {
            return "Terence";
        }

        public String getLastName() {
            return "Parr";
        }

        public String getEmail() {
            return "parrt@jguru.com";
        }

        public String getBio() {
            return "Superhero by night...";
        }

        public boolean getCanEdit() {
            return false;
        }
    }

    static class ErrorBuffer
    implements StringTemplateErrorListener {
        StringBuffer errorOutput = new StringBuffer(500);
        int n = 0;

        ErrorBuffer() {
        }

        public void error(String msg, Throwable e) {
            ++this.n;
            if (this.n > 1) {
                this.errorOutput.append('\n');
            }
            if (e != null) {
                StringWriter duh = new StringWriter();
                e.printStackTrace(new PrintWriter(duh));
                this.errorOutput.append(msg + ": " + duh.toString());
            } else {
                this.errorOutput.append(msg);
            }
        }

        public void warning(String msg) {
            ++this.n;
            this.errorOutput.append(msg);
        }

        public boolean equals(Object o) {
            String me = this.toString();
            String them = o.toString();
            return me.equals(them);
        }

        public String toString() {
            return this.errorOutput.toString();
        }
    }
}

