/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import javax.swing.Icon;

public class GrayedIcon
implements Icon {
    private Icon icon;
    private Image grayedImg;

    public GrayedIcon(Icon icon) {
        this.icon = icon;
    }

    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Image tmpImg;
        if (this.grayedImg == null && (tmpImg = c.createImage(this.getIconWidth(), this.getIconHeight())) != null) {
            Graphics g2 = tmpImg.getGraphics();
            if (g != null) {
                g2.setColor(new Color(-15584170));
                g2.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
                this.icon.paintIcon(c, g2, 0, 0);
                g2.dispose();
                this.grayedImg = IconGrayFilter.createDisabledImage(tmpImg);
            }
        }
        if (this.grayedImg != null) {
            g.drawImage(this.grayedImg, x, y, null);
        }
    }

    static class IconGrayFilter
    extends RGBImageFilter {
        private boolean brighter;
        private int percent;

        public static Image createDisabledImage(Image i) {
            IconGrayFilter filter = new IconGrayFilter(true, 50);
            FilteredImageSource prod = new FilteredImageSource(i.getSource(), filter);
            Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
            return grayImage;
        }

        public IconGrayFilter(boolean b, int p) {
            this.brighter = b;
            this.percent = p;
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            if ((rgb & 0xFFFFFF) == 1193046) {
                return 0xFF0000;
            }
            int gray = (int)((0.3 * (double)(rgb >> 16 & 0xFF) + 0.59 * (double)(rgb >> 8 & 0xFF) + 0.11 * (double)(rgb & 0xFF)) / 3.0);
            gray = this.brighter ? 255 - (255 - gray) * (100 - this.percent) / 100 : gray * (100 - this.percent) / 100;
            if (gray < 0) {
                gray = 0;
            }
            if (gray > 255) {
                gray = 255;
            }
            return rgb & 0xFF000000 | gray << 16 | gray << 8 | gray << 0;
        }
    }
}

