/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

public class IntSet {
    private int[] elements = new int[0];

    public IntSet() {
    }

    private IntSet(IntSet set) {
        this.elements = (int[])set.elements.clone();
    }

    public void and(IntSet set) {
        if (set == this) {
            return;
        }
        int length = 0;
        int l = 0;
        int r = 0;
        while (l < this.elements.length && r < set.elements.length) {
            if (this.elements[l] < set.elements[r]) {
                ++l;
                continue;
            }
            if (this.elements[l] == set.elements[r]) {
                ++length;
                ++l;
                ++r;
                continue;
            }
            ++r;
        }
        int[] old = this.elements;
        this.elements = new int[length];
        r = 0;
        l = 0;
        length = 0;
        while (l < old.length && r < set.elements.length) {
            if (old[l] < set.elements[r]) {
                ++l;
                continue;
            }
            if (old[l] == set.elements[r]) {
                this.elements[length++] = old[l];
                ++l;
                ++r;
                continue;
            }
            ++r;
        }
    }

    public void clear(int bit) {
        this.elements = new int[0];
    }

    public Object clone() {
        return new IntSet(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntSet)) {
            return false;
        }
        IntSet set = (IntSet)obj;
        if (this.elements.length != set.elements.length) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == set.elements[i]) continue;
            return false;
        }
        return true;
    }

    public boolean get(int bit) {
        int low = 0;
        int high = this.elements.length - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            if (bit < this.elements[middle]) {
                high = middle - 1;
                continue;
            }
            if (bit == this.elements[middle]) {
                return true;
            }
            low = middle + 1;
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            result += this.elements[i];
        }
        return result;
    }

    public void or(IntSet set) {
        if (set == this) {
            return;
        }
        int length = 0;
        int l = 0;
        int r = 0;
        while (l < this.elements.length || r < set.elements.length) {
            if (r == set.elements.length || l != this.elements.length && this.elements[l] < set.elements[r]) {
                ++length;
                ++l;
                continue;
            }
            if (l == this.elements.length || this.elements[l] > set.elements[r]) {
                ++length;
                ++r;
                continue;
            }
            ++length;
            ++l;
            ++r;
        }
        int[] old = this.elements;
        this.elements = new int[length];
        r = 0;
        l = 0;
        length = 0;
        while (l < old.length || r < set.elements.length) {
            if (r == set.elements.length || l != old.length && old[l] < set.elements[r]) {
                this.elements[length++] = old[l];
                ++l;
                continue;
            }
            if (l == old.length || old[l] > set.elements[r]) {
                this.elements[length++] = set.elements[r];
                ++r;
                continue;
            }
            this.elements[length++] = old[l];
            ++l;
            ++r;
        }
    }

    public void set(int bit) {
        if (!this.get(bit)) {
            int[] old = this.elements;
            this.elements = new int[old.length + 1];
            int old_pos = 0;
            boolean bit_inserted = false;
            int pos = 0;
            while (pos < this.elements.length) {
                if (!bit_inserted) {
                    if (old_pos < old.length) {
                        if (bit < old[old_pos]) {
                            this.elements[pos++] = bit;
                            bit_inserted = true;
                            continue;
                        }
                        this.elements[pos++] = old[old_pos++];
                        continue;
                    }
                    this.elements[pos++] = bit;
                    bit_inserted = true;
                    continue;
                }
                this.elements[pos++] = old[old_pos++];
            }
        }
    }

    public int size() {
        if (this.elements.length == 0) {
            return 0;
        }
        return this.elements[this.elements.length - 1] + 1;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{");
        boolean comma = false;
        for (int i = 0; i < this.elements.length; ++i) {
            if (comma) {
                s.append(", ");
            } else {
                comma = true;
            }
            s.append(this.elements[i]);
        }
        s.append("}");
        return s.toString();
    }

    public void xor(IntSet set) {
        if (set == this) {
            set = (IntSet)set.clone();
        }
        int length = 0;
        int l = 0;
        int r = 0;
        while (l < this.elements.length || r < set.elements.length) {
            if (r == set.elements.length || l != this.elements.length && this.elements[l] < set.elements[r]) {
                ++length;
                ++l;
                continue;
            }
            if (l == this.elements.length || this.elements[l] > set.elements[r]) {
                ++length;
                ++r;
                continue;
            }
            ++l;
            ++r;
        }
        int[] old = this.elements;
        this.elements = new int[length];
        r = 0;
        l = 0;
        length = 0;
        while (l < old.length || r < set.elements.length) {
            if (r == set.elements.length || l != old.length && old[l] < set.elements[r]) {
                this.elements[length++] = old[l];
                ++l;
                continue;
            }
            if (l == old.length || old[l] > set.elements[r]) {
                this.elements[length++] = set.elements[r];
                ++r;
                continue;
            }
            ++l;
            ++r;
        }
    }

    public int[] elements() {
        return this.elements;
    }
}

