/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class StringUtil {
    public static final String[] STRING_ARRAY = new String[0];

    private StringUtil() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static String getNullStrIfNull(String str) {
        return str == null ? "" : str;
    }

    public static String implode(String glue, String[] pieces) {
        StringBuilder sb = new StringBuilder();
        int last = pieces.length;
        int count = 1;
        for (String str : pieces) {
            sb.append(str);
            if (count < last && glue != null) {
                sb.append(glue);
            }
            ++count;
        }
        return sb.toString();
    }

    public static String implode(String[] pieces) {
        return StringUtil.implode(null, pieces);
    }

    public static String implode(String glue, Collection<String> pieces) {
        return StringUtil.implode(glue, pieces.toArray(STRING_ARRAY));
    }

    public static String implode(Collection<String> pieces) {
        return StringUtil.implode(pieces.toArray(STRING_ARRAY));
    }

    public static List<String> explode(String delimiter, String str) {
        String sub;
        ArrayList<String> out = new ArrayList<String>();
        int len = delimiter.length();
        int startIndex = 0;
        int currIndex = 0;
        while ((currIndex = str.indexOf(delimiter, startIndex)) != -1) {
            sub = str.substring(startIndex, currIndex);
            out.add(sub);
            startIndex = currIndex + len;
        }
        sub = str.substring(startIndex);
        out.add(sub);
        return out;
    }

    public static List<String> explodeFirst(String delimiter, String str) {
        ArrayList<String> out = new ArrayList<String>(2);
        int beginIndex = str.indexOf(delimiter);
        if (beginIndex != -1) {
            String subFirst = str.substring(0, beginIndex);
            String subLast = str.substring(beginIndex + delimiter.length());
            out.add(subFirst);
            out.add(subLast);
        }
        return out;
    }

    public static List<String> explodeLast(String delimiter, String str) {
        ArrayList<String> out = new ArrayList<String>(2);
        int lastIndex = str.lastIndexOf(delimiter);
        if (lastIndex != -1) {
            String subFirst = str.substring(0, lastIndex);
            String subLast = str.substring(lastIndex + delimiter.length());
            out.add(subFirst);
            out.add(subLast);
        }
        return out;
    }

    public static String capatilizeFirstLetter(String str) {
        char[] c = str.toCharArray();
        if (c.length > 0) {
            c[0] = Character.toUpperCase(c[0]);
        }
        return String.valueOf(c);
    }

    public static String capatilizeFirstLetterEachWord(String str) {
        char[] c = str.toLowerCase().toCharArray();
        boolean found = false;
        for (int i = 0; i < c.length; ++i) {
            if (!found && Character.isLetter(c[i])) {
                c[i] = Character.toUpperCase(c[i]);
                found = true;
                continue;
            }
            if (!Character.isWhitespace(c[i]) && c[i] != '.' && c[i] != '\'') continue;
            found = false;
        }
        return String.valueOf(c);
    }

    public static String reverseCapitalization(String str) {
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (!Character.isLetter(c[i])) continue;
            c[i] = Character.isLowerCase(c[i]) ? Character.toUpperCase(c[i]) : Character.toLowerCase(c[i]);
        }
        return String.valueOf(c);
    }

    public static String languageTrim(String str, int length) {
        if (length < 2) {
            throw new IllegalArgumentException("Length should not be less than 2.");
        }
        if (str.length() <= length) {
            return str;
        }
        char[] arr = str.toCharArray();
        int lastSpaceCharacter = -1;
        for (int i = length; i > -1; --i) {
            if (!Character.isWhitespace(arr[i])) continue;
            lastSpaceCharacter = i;
            break;
        }
        if (lastSpaceCharacter <= 0) {
            return new String(arr, 0, length);
        }
        return new String(arr, 0, lastSpaceCharacter);
    }
}

