/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.management.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import org.opensolaris.opengrok.management.OGAgent;

public class SettingsPersistence {
    public static final String HOST = "org.opensolaris.opengrok.management.host";
    public static final String JMXPORT = "org.opensolaris.opengrok.management.port";
    public static final String RMIPORT = "org.opensolaris.opengrok.management.rmi.port";
    public static final String JMXURL = "org.opensolaris.opengrok.management.url";
    public static final String INDEXTIMEOUTKEY = "org.opensolaris.opengrok.management.indextimeout";
    public static final String CONNECTIONTIMEOUTKEY = "org.opensolaris.opengrok.management.connectiontimeout";
    public static final String LOGGINGPATHKEY = "org.opensolaris.opengrok.management.logging.path";
    public static final String FILELOGLEVELKEY = "org.opensolaris.opengrok.management.logging.filelevel";
    public static final String CONSOLELOGLEVELKEY = "org.opensolaris.opengrok.management.logging.consolelevel";
    private final Properties ogcProperties = new Properties();
    private File propertyFile;
    private boolean existingSettings = false;

    public SettingsPersistence(String cfgfile) throws IOException {
        try (InputStream in = OGAgent.class.getResourceAsStream("oga.properties");){
            if (in != null) {
                this.ogcProperties.load(in);
            }
        }
        if (cfgfile != null) {
            this.propertyFile = new File(cfgfile);
            var3_5 = null;
            try (FileInputStream is = new FileInputStream(this.propertyFile);){
                this.ogcProperties.load(is);
            }
            catch (Throwable throwable) {
                var3_5 = throwable;
                throw throwable;
            }
        }
    }

    public String getAgentUrl() {
        String url = this.ogcProperties.getProperty(JMXURL);
        if (url == null) {
            String host = this.ogcProperties.getProperty(HOST, "localhost");
            int jmxport = Integer.parseInt(this.ogcProperties.getProperty(JMXPORT, "9292"));
            int rmiport = Integer.parseInt(this.ogcProperties.getProperty(RMIPORT, String.valueOf(jmxport + 1)));
            url = "service:jmx:rmi://" + host + ":" + jmxport + "/jndi/rmi://" + host + ":" + rmiport + "/opengrok";
        }
        return url;
    }

    public boolean hasExistingSettings() {
        return this.existingSettings;
    }

    public String getProperty(String key) {
        return this.ogcProperties.getProperty(key);
    }

    public void setProperty(String key, String val) {
        this.ogcProperties.setProperty(key, val);
    }

    public Level getFileLogLevel() {
        return Level.parse(this.ogcProperties.getProperty(FILELOGLEVELKEY));
    }

    public Level getConsoleLogLevel() {
        return Level.parse(this.ogcProperties.getProperty(CONSOLELOGLEVELKEY));
    }
}

