/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.rcs.Archive;
import org.apache.commons.jrcs.rcs.InvalidFileFormatException;
import org.apache.commons.jrcs.rcs.Node;
import org.apache.commons.jrcs.rcs.ParseException;
import org.apache.commons.jrcs.rcs.Version;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.RCSHistoryParser;
import org.opensolaris.opengrok.history.RCSget;
import org.opensolaris.opengrok.history.Repository;

public class RCSRepository
extends Repository {
    private static final long serialVersionUID = 1L;

    public RCSRepository() {
        this.working = Boolean.TRUE;
        this.type = "RCS";
    }

    @Override
    boolean fileHasHistory(File file) {
        return this.getRCSFile(file) != null;
    }

    @Override
    InputStream getHistoryGet(String parent, String basename, String rev) {
        try {
            File file = new File(parent, basename);
            File rcsFile = this.getRCSFile(file);
            return new RCSget(rcsFile.getPath(), rev);
        }
        catch (IOException ioe) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to retrieve revision " + rev + " of " + basename, ioe);
            return null;
        }
    }

    @Override
    boolean fileHasAnnotation(File file) {
        return this.fileHasHistory(file);
    }

    @Override
    Annotation annotate(File file, String revision) throws IOException {
        File rcsFile = this.getRCSFile(file);
        return rcsFile == null ? null : RCSRepository.annotate(file, revision, rcsFile);
    }

    static Annotation annotate(File file, String revision, File rcsFile) throws IOException {
        try {
            Archive archive = new Archive(rcsFile.getPath());
            Version version = revision == null ? archive.getRevisionVersion() : archive.getRevisionVersion(revision);
            archive.getRevision(version, true);
            Annotation a = new Annotation(file.getName());
            for (Node n : archive.getRevisionNodes()) {
                String rev = n.getVersion().toString();
                String author = n.getAuthor();
                a.addLine(rev, author, true);
            }
            return a;
        }
        catch (ParseException pe) {
            throw RCSRepository.wrapInIOException("Parse exception annotating RCS repository", pe);
        }
        catch (InvalidFileFormatException iffe) {
            throw RCSRepository.wrapInIOException("File format exception annotating RCS repository", iffe);
        }
        catch (PatchFailedException pfe) {
            throw RCSRepository.wrapInIOException("Patch failed exception annotating RCS repository", pfe);
        }
    }

    static IOException wrapInIOException(String message, Throwable t) {
        IOException ioe = new IOException(message + ": " + t.getMessage());
        ioe.initCause(t);
        return ioe;
    }

    @Override
    void update() throws IOException {
        throw new IOException("Not supported yet.");
    }

    @Override
    boolean isRepositoryFor(File file) {
        File rcsDir = new File(file, "RCS");
        return rcsDir.isDirectory();
    }

    File getRCSFile(File file) {
        String baseName;
        File dir = new File(file.getParentFile(), "RCS");
        File rcsFile = new File(dir, (baseName = file.getName()) + ",v");
        return rcsFile.exists() ? rcsFile : null;
    }

    @Override
    boolean hasHistoryForDirectories() {
        return false;
    }

    @Override
    History getHistory(File file) throws HistoryException {
        return new RCSHistoryParser().parse(file, this);
    }
}

