/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.HistoryGuru;
import org.opensolaris.opengrok.history.MercurialHistoryParser;
import org.opensolaris.opengrok.history.MercurialTagEntry;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.Executor;
import org.opensolaris.opengrok.web.Util;

public class MercurialRepository
extends Repository {
    private static final long serialVersionUID = 1L;
    public static final String CMD_PROPERTY_KEY = "org.opensolaris.opengrok.history.Mercurial";
    public static final String CMD_FALLBACK = "hg";
    private String branch = null;
    public static final String NOFOREST_PROPERTY_KEY = "org.opensolaris.opengrok.history.mercurial.disableForest";
    static final String CHANGESET = "changeset: ";
    static final String USER = "user: ";
    static final String DATE = "date: ";
    static final String DESCRIPTION = "description: ";
    static final String FILE_COPIES = "file_copies: ";
    static final String FILES = "files: ";
    static final String END_OF_ENTRY = "mercurial_history_end_of_entry";
    private static final String TEMPLATE_STUB = "changeset: {rev}:{node|short}\\nuser: {author}\\ndate: {date|isodate}\\ndescription: {desc|strip|obfuscate}\\n";
    private static final String FILE_LIST = "files: {files}\\n";
    private static final String FILE_TEMPLATE = "changeset: {rev}:{node|short}\\nuser: {author}\\ndate: {date|isodate}\\ndescription: {desc|strip|obfuscate}\\nmercurial_history_end_of_entry\\n";
    private static final String FILE_TEMPLATE_LIST = "changeset: {rev}:{node|short}\\nuser: {author}\\ndate: {date|isodate}\\ndescription: {desc|strip|obfuscate}\\nfiles: {files}\\nmercurial_history_end_of_entry\\n";
    private static final String DIR_TEMPLATE_RENAMED = "changeset: {rev}:{node|short}\\nuser: {author}\\ndate: {date|isodate}\\ndescription: {desc|strip|obfuscate}\\nfiles: {files}\\nfile_copies: {file_copies}\\nmercurial_history_end_of_entry\\n";
    private static final String DIR_TEMPLATE = "changeset: {rev}:{node|short}\\nuser: {author}\\ndate: {date|isodate}\\ndescription: {desc|strip|obfuscate}\\nfiles: {files}\\nmercurial_history_end_of_entry\\n";
    private static final Pattern ANNOTATION_PATTERN = Pattern.compile("^\\s*(\\d+):");
    private static final Pattern LOG_COPIES_PATTERN = Pattern.compile("^(\\d+):(.*)");

    public MercurialRepository() {
        this.type = "Mercurial";
        this.datePattern = "yyyy-MM-dd hh:mm ZZZZ";
    }

    private String getBranch() {
        if (this.branch == null) {
            ArrayList<String> cmd = new ArrayList<String>();
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            cmd.add(this.cmd);
            cmd.add("branch");
            Executor e = new Executor(cmd, new File(this.directoryName));
            e.exec();
            String output = e.getOutputString();
            this.branch = output.trim();
        }
        return this.branch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Executor getHistoryLogExecutor(File file, String changeset) throws HistoryException, IOException {
        String abs = file.getCanonicalPath();
        String filename = "";
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        if (abs.length() > this.directoryName.length()) {
            filename = abs.substring(this.directoryName.length() + 1);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("log");
        if (!file.isDirectory()) {
            cmd.add("-f");
        }
        if (changeset != null) {
            cmd.add("-r");
            String[] parts = changeset.split(":");
            if (parts.length != 2) throw new HistoryException("Don't know how to parse changeset identifier: " + changeset);
            cmd.add("reverse(" + parts[0] + "::'" + this.getBranch() + "')");
        } else {
            cmd.add("-r");
            cmd.add("reverse(0::'" + this.getBranch() + "')");
        }
        cmd.add("--template");
        if (file.isDirectory()) {
            cmd.add(RuntimeEnvironment.isRenamedFilesEnabled() ? DIR_TEMPLATE_RENAMED : "changeset: {rev}:{node|short}\\nuser: {author}\\ndate: {date|isodate}\\ndescription: {desc|strip|obfuscate}\\nfiles: {files}\\nmercurial_history_end_of_entry\\n");
        } else {
            cmd.add(env.storeHistoryCacheInDB() ? "changeset: {rev}:{node|short}\\nuser: {author}\\ndate: {date|isodate}\\ndescription: {desc|strip|obfuscate}\\nfiles: {files}\\nmercurial_history_end_of_entry\\n" : FILE_TEMPLATE);
        }
        if (filename.isEmpty()) return new Executor(cmd, new File(this.directoryName));
        cmd.add(filename);
        return new Executor(cmd, new File(this.directoryName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getHistoryRev(String fullpath, String rev) {
        ByteArrayInputStream ret = null;
        File directory = new File(this.directoryName);
        Process process = null;
        String revision = rev;
        if (rev.indexOf(58) != -1) {
            revision = rev.substring(0, rev.indexOf(58));
        }
        try {
            String filename = fullpath.substring(this.directoryName.length() + 1);
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            String[] argv = new String[]{this.cmd, "cat", "-r", revision, filename};
            process = Runtime.getRuntime().exec(argv, null, directory);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[32768];
            try (InputStream in = process.getInputStream();){
                int len;
                while ((len = in.read(buffer)) != -1) {
                    if (len <= 0) continue;
                    out.write(buffer, 0, len);
                }
            }
            ret = process.waitFor() == 0 ? new ByteArrayInputStream(out.toByteArray()) : null;
        }
        catch (Exception exp) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get history: " + exp.getClass().toString());
        }
        finally {
            if (process != null) {
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException exp) {
                    process.destroy();
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findOriginalName(String fullpath, String full_rev_to_find) throws IOException {
        Matcher matcher = LOG_COPIES_PATTERN.matcher("");
        String file = fullpath.substring(this.directoryName.length() + 1);
        ArrayList<String> argv = new ArrayList<String>();
        String[] rev_array = full_rev_to_find.split(":");
        String rev_to_find = rev_array[0];
        if (rev_to_find.isEmpty()) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Invalid revision string: {0}", full_rev_to_find);
            return null;
        }
        argv.add(this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK));
        argv.add("log");
        argv.add("-f");
        argv.add("-r");
        argv.add("reverse(" + rev_to_find + ":)");
        argv.add("--template");
        argv.add("{rev}:{file_copies}\\n");
        argv.add(fullpath);
        ProcessBuilder pb = new ProcessBuilder(argv);
        Process process = null;
        try {
            process = pb.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    matcher.reset(line);
                    if (!matcher.find()) {
                        OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to match: {0}", line);
                        String string = null;
                        return string;
                    }
                    String rev = matcher.group(1);
                    String content = matcher.group(2);
                    if (rev.equals(rev_to_find)) {
                    } else {
                        if (!content.isEmpty()) {
                            String[] splitArray;
                            for (String s : splitArray = content.split("\\)")) {
                                String[] move = s.split(" \\(");
                                if (!file.equals(move[0])) continue;
                                file = move[1];
                                break;
                            }
                        }
                        if (!rev.equals(rev_to_find)) continue;
                    }
                    break;
                }
            }
        }
        finally {
            if (process != null) {
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    process.destroy();
                }
            }
        }
        return fullpath.substring(0, this.directoryName.length() + 1) + file;
    }

    @Override
    public InputStream getHistoryGet(String parent, String basename, String rev) {
        String fullpath;
        try {
            fullpath = new File(parent, basename).getCanonicalPath();
        }
        catch (IOException exp) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get canonical path: {0}", exp.getClass().toString());
            return null;
        }
        InputStream ret = this.getHistoryRev(fullpath, rev);
        if (ret == null) {
            String origpath;
            try {
                origpath = this.findOriginalName(fullpath, rev);
            }
            catch (IOException exp) {
                OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get original revision: {0}", exp.getClass().toString());
                return null;
            }
            if (origpath != null) {
                ret = this.getHistoryRev(origpath, rev);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation annotate(File file, String revision) throws IOException {
        ArrayList<String> argv = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        argv.add(this.cmd);
        argv.add("annotate");
        argv.add("-n");
        if (revision != null) {
            argv.add("-r");
            if (revision.indexOf(58) == -1) {
                argv.add(revision);
            } else {
                argv.add(revision.substring(0, revision.indexOf(58)));
            }
        }
        argv.add(file.getName());
        ProcessBuilder pb = new ProcessBuilder(argv);
        pb.directory(file.getParentFile());
        Process process = null;
        Annotation ret = null;
        HashMap<String, HistoryEntry> revs = new HashMap<String, HistoryEntry>();
        try {
            History hist = HistoryGuru.getInstance().getHistory(file, false);
            for (HistoryEntry e : hist.getHistoryEntries()) {
                revs.put(e.getRevision().replaceFirst(":[a-f0-9]+", ""), e);
            }
        }
        catch (HistoryException he) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Error: cannot get history for file " + file);
            return null;
        }
        try {
            process = pb.start();
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Object object = null;
            try {
                String line;
                ret = new Annotation(file.getName());
                int lineno = 0;
                Matcher matcher = ANNOTATION_PATTERN.matcher("");
                while ((line = in.readLine()) != null) {
                    ++lineno;
                    matcher.reset(line);
                    if (matcher.find()) {
                        String rev = matcher.group(1);
                        String author = "N/A";
                        if (revs.get(rev) != null) {
                            author = ((HistoryEntry)revs.get(rev)).getAuthor();
                        }
                        ret.addLine(rev, Util.getEmail(author.trim()), true);
                        continue;
                    }
                    OpenGrokLogger.getLogger().log(Level.SEVERE, "Error: did not find annotation in line " + lineno + ": [" + line + "]");
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        finally {
            if (process != null) {
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    process.destroy();
                }
            }
        }
        return ret;
    }

    @Override
    protected String getRevisionForAnnotate(String history_revision) {
        String[] brev = history_revision.split(":");
        return brev[0];
    }

    @Override
    public boolean fileHasAnnotation(File file) {
        return true;
    }

    @Override
    public void update() throws IOException {
        File directory = new File(this.directoryName);
        ArrayList<String> cmd = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        cmd.add(this.cmd);
        cmd.add("showconfig");
        Executor executor = new Executor(cmd, directory);
        if (executor.exec() != 0) {
            throw new IOException(executor.getErrorString());
        }
        if (executor.getOutputString().indexOf("paths.default=") != -1) {
            cmd.clear();
            cmd.add(this.cmd);
            cmd.add("pull");
            cmd.add("-u");
            executor = new Executor(cmd, directory);
            if (executor.exec() != 0) {
                throw new IOException(executor.getErrorString());
            }
        }
    }

    @Override
    public boolean fileHasHistory(File file) {
        return true;
    }

    @Override
    boolean isRepositoryFor(File file) {
        if (file.isDirectory()) {
            File f = new File(file, ".hg");
            return f.exists() && f.isDirectory();
        }
        return false;
    }

    @Override
    boolean supportsSubRepositories() {
        String val = System.getenv(NOFOREST_PROPERTY_KEY);
        return !(val != null ? Boolean.parseBoolean(val) : Boolean.getBoolean(NOFOREST_PROPERTY_KEY));
    }

    @Override
    public boolean isWorking() {
        if (this.working == null) {
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            this.working = MercurialRepository.checkCmd(this.cmd);
        }
        return this.working;
    }

    @Override
    boolean hasHistoryForDirectories() {
        return true;
    }

    @Override
    History getHistory(File file) throws HistoryException {
        return this.getHistory(file, null);
    }

    @Override
    History getHistory(File file, String sinceRevision) throws HistoryException {
        RuntimeEnvironment env = RuntimeEnvironment.getInstance();
        History result = new MercurialHistoryParser(this).parse(file, sinceRevision);
        if (env.isTagsEnabled()) {
            this.assignTagsInHistory(result);
        }
        return result;
    }

    @Override
    boolean hasFileBasedTags() {
        return true;
    }

    @Override
    protected void buildTagList(File directory) {
        this.tagList = new TreeSet();
        ArrayList<String> argv = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        argv.add(this.cmd);
        argv.add("tags");
        ProcessBuilder pb = new ProcessBuilder(argv);
        pb.directory(directory);
        Process process = null;
        try {
            process = pb.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    String[] parts = line.split("  *");
                    if (parts.length < 2) {
                        OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to parse tag list: {0}", "Tag line contains more than 2 columns: " + line);
                        this.tagList = null;
                        break;
                    }
                    String tag = parts[0];
                    for (int i = 1; i < parts.length - 1; ++i) {
                        tag.concat(" ");
                        tag.concat(parts[i]);
                    }
                    if (tag.contentEquals("tip")) continue;
                    String[] revParts = parts[parts.length - 1].split(":");
                    if (revParts.length != 2) {
                        OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to parse tag list: {0}", "Mercurial revision parsing error: " + parts[parts.length - 1]);
                        this.tagList = null;
                        break;
                    }
                    MercurialTagEntry tagEntry = new MercurialTagEntry(Integer.parseInt(revParts[0]), tag);
                    this.tagList.add(tagEntry);
                }
            }
        }
        catch (IOException e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to read tag list: {0}", e.getMessage());
            this.tagList = null;
        }
        if (process != null) {
            try {
                process.exitValue();
            }
            catch (IllegalThreadStateException e) {
                process.destroy();
            }
        }
    }
}

