/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.animation;

import java.awt.Graphics2D;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uk.ac.ic.doc.scenebeans.CompositeNode;
import uk.ac.ic.doc.scenebeans.Layered;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.SceneGraphProcessor;
import uk.ac.ic.doc.scenebeans.activity.Activity;
import uk.ac.ic.doc.scenebeans.activity.ActivityBase;
import uk.ac.ic.doc.scenebeans.activity.ActivityList;
import uk.ac.ic.doc.scenebeans.activity.ActivityRunner;
import uk.ac.ic.doc.scenebeans.animation.Command;
import uk.ac.ic.doc.scenebeans.animation.CommandException;

public class Animation
extends ActivityBase
implements CompositeNode,
Serializable,
ActivityRunner {
    private ActivityList _activities = ActivityList.EMPTY;
    private Layered _layers = new Layered();
    private Map _commands = new HashMap();
    private Set _event_names = new HashSet();
    private double _width = 0.0;
    private double _height = 0.0;
    private boolean _is_animated = false;
    private boolean _is_dirty = false;

    public double getWidth() {
        return this._width;
    }

    public void setWidth(double d) {
        this._width = d;
    }

    public double getHeight() {
        return this._height;
    }

    public void setHeight(double d) {
        this._height = d;
    }

    public boolean isDirty() {
        return this._is_dirty;
    }

    public void setDirty(boolean bl) {
        this._is_dirty = bl;
    }

    public void accept(SceneGraphProcessor sceneGraphProcessor) {
        sceneGraphProcessor.process(this);
    }

    public int getSubgraphCount() {
        return this._layers.getSubgraphCount();
    }

    public SceneGraph getSubgraph(int n) {
        return this._layers.getSubgraph(n);
    }

    public int getVisibleSubgraphCount() {
        return this._layers.getVisibleSubgraphCount();
    }

    public SceneGraph getVisibleSubgraph(int n) {
        return this._layers.getVisibleSubgraph(n);
    }

    public int getLastDrawnSubgraphCount() {
        return this._layers.getLastDrawnSubgraphCount();
    }

    public SceneGraph getLastDrawnSubgraph(int n) {
        return this._layers.getLastDrawnSubgraph(n);
    }

    public void addSubgraph(SceneGraph sceneGraph) {
        this._layers.addSubgraph(sceneGraph);
    }

    public void removeSubgraph(SceneGraph sceneGraph) {
        this._layers.removeSubgraph(sceneGraph);
    }

    public void removeSubgraph(int n) {
        this._layers.removeSubgraph(n);
    }

    public void draw(Graphics2D graphics2D) {
        this._layers.draw(graphics2D);
    }

    public synchronized void addActivity(Activity activity) {
        if (activity.getActivityRunner() != this) {
            activity.setActivityRunner(this);
            this._activities = this._activities.add(activity);
        }
    }

    public synchronized void removeActivity(Activity activity) {
        if (activity.getActivityRunner() == this) {
            activity.setActivityRunner(null);
            this._activities = this._activities.remove(activity);
        }
    }

    public boolean isFinite() {
        return false;
    }

    public void reset() {
        Iterator iterator = this._activities.iterator();
        while (iterator.hasNext()) {
            ((Activity)iterator.next()).reset();
        }
    }

    public void performActivity(double d) {
        this._activities.performActivities(d);
    }

    public synchronized void addCommand(String string, Command command) {
        this._commands.put(string, command);
    }

    public synchronized void removeCommand(String string) {
        this._commands.remove(string);
    }

    public synchronized Set getCommandNames() {
        return Collections.unmodifiableSet(this._commands.keySet());
    }

    public synchronized Command getCommand(String string) {
        return (Command)this._commands.get(string);
    }

    public synchronized void invokeCommand(String string) throws CommandException {
        Command command = (Command)this._commands.get(string);
        if (command == null) {
            throw new CommandException("unknown command \"" + string + "\"");
        }
        command.invoke();
    }

    public Set getEventNames() {
        return Collections.unmodifiableSet(this._event_names);
    }

    public void addEventName(String string) {
        this._event_names.add(string);
    }

    public void removeEventName(String string) {
        this._event_names.remove(string);
    }

    final void announceAnimationEvent(String string) {
        this.postActivityComplete(string);
    }
}

