/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class DateTimeFunction
extends BaseDateTimeFunction {
    private final DateTimeProcessor.DateTimeExtractor extractor;

    DateTimeFunction(Source source, Expression field, ZoneId zoneId, DateTimeProcessor.DateTimeExtractor extractor) {
        super(source, field, zoneId);
        this.extractor = extractor;
    }

    @Override
    protected Object doFold(ZonedDateTime dateTime) {
        return DateTimeFunction.dateTimeChrono(dateTime, this.extractor.chronoField());
    }

    public static Integer dateTimeChrono(ZonedDateTime dateTime, String tzId, String chronoName) {
        ZonedDateTime zdt = dateTime.withZoneSameInstant(ZoneId.of(tzId));
        return DateTimeFunction.dateTimeChrono(zdt, ChronoField.valueOf(chronoName));
    }

    private static Integer dateTimeChrono(ZonedDateTime dateTime, ChronoField field) {
        return dateTime.get(field);
    }

    @Override
    public ScriptTemplate asScript() {
        ParamsBuilder params = ParamsBuilder.paramsBuilder();
        ScriptTemplate script = super.asScript();
        String template = this.formatTemplate("{sql}.dateTimeChrono(" + script.template() + ", {}, {})");
        params.script(script.params()).variable(this.zoneId().getId()).variable(this.extractor.chronoField().name());
        return new ScriptTemplate(template, params.build(), this.dataType());
    }

    @Override
    protected Processor makeProcessor() {
        return new DateTimeProcessor(this.extractor, this.zoneId());
    }

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }

    public abstract String dateTimeFormat();
}

