/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TrustStoreTrustManager
implements X509TrustManager,
Serializable {
    private static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    private static final long serialVersionUID = -4093869102727719415L;
    private final boolean examineValidityDates;
    private final char[] trustStorePIN;
    private final String trustStoreFile;
    private final String trustStoreFormat;

    public TrustStoreTrustManager(File trustStoreFile) {
        this(trustStoreFile.getAbsolutePath(), null, null, true);
    }

    public TrustStoreTrustManager(String trustStoreFile) {
        this(trustStoreFile, null, null, true);
    }

    public TrustStoreTrustManager(File trustStoreFile, char[] trustStorePIN, String trustStoreFormat, boolean examineValidityDates) {
        this(trustStoreFile.getAbsolutePath(), trustStorePIN, trustStoreFormat, examineValidityDates);
    }

    public TrustStoreTrustManager(String trustStoreFile, char[] trustStorePIN, String trustStoreFormat, boolean examineValidityDates) {
        Validator.ensureNotNull(trustStoreFile);
        this.trustStoreFile = trustStoreFile;
        this.trustStorePIN = trustStorePIN;
        this.examineValidityDates = examineValidityDates;
        this.trustStoreFormat = trustStoreFormat == null ? KeyStore.getDefaultType() : trustStoreFormat;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public String getTrustStoreFormat() {
        return this.trustStoreFormat;
    }

    public boolean examineValidityDates() {
        return this.examineValidityDates;
    }

    private synchronized X509TrustManager[] getTrustManagers(X509Certificate[] chain) throws CertificateException {
        KeyStore ks;
        File f;
        if (this.examineValidityDates) {
            Date d = new Date();
            for (X509Certificate c : chain) {
                c.checkValidity(d);
            }
        }
        if (!(f = new File(this.trustStoreFile)).exists()) {
            throw new CertificateException(SSLMessages.ERR_TRUSTSTORE_NO_SUCH_FILE.get(this.trustStoreFile));
        }
        try {
            ks = KeyStore.getInstance(this.trustStoreFormat);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertificateException(SSLMessages.ERR_TRUSTSTORE_UNSUPPORTED_FORMAT.get(this.trustStoreFormat), e);
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(f);
            ks.load(inputStream, this.trustStorePIN);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertificateException(SSLMessages.ERR_TRUSTSTORE_CANNOT_LOAD.get(this.trustStoreFile, this.trustStoreFormat, StaticUtils.getExceptionMessage(e)), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(ks);
            TrustManager[] trustManagers = factory.getTrustManagers();
            X509TrustManager[] x509TrustManagers = new X509TrustManager[trustManagers.length];
            for (int i = 0; i < trustManagers.length; ++i) {
                x509TrustManagers[i] = (X509TrustManager)trustManagers[i];
            }
            return x509TrustManagers;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new CertificateException(SSLMessages.ERR_TRUSTSTORE_CANNOT_GET_TRUST_MANAGERS.get(this.trustStoreFile, this.trustStoreFormat, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public synchronized void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager m : this.getTrustManagers(chain)) {
            m.checkClientTrusted(chain, authType);
        }
    }

    @Override
    public synchronized void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509TrustManager m : this.getTrustManagers(chain)) {
            m.checkServerTrusted(chain, authType);
        }
    }

    @Override
    public synchronized X509Certificate[] getAcceptedIssuers() {
        return NO_CERTIFICATES;
    }
}

