/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.ExportException;

public abstract class ExportBulk {
    protected final String name;
    protected final ThreadContext threadContext;
    private final AtomicBoolean closed = new AtomicBoolean();

    public ExportBulk(String name, ThreadContext threadContext) {
        this.name = Objects.requireNonNull(name);
        this.threadContext = Objects.requireNonNull(threadContext);
    }

    public String getName() {
        return this.name;
    }

    public void add(Collection<MonitoringDoc> docs) throws ExportException {
        if (!this.closed.get()) {
            this.doAdd(docs);
        }
    }

    protected abstract void doAdd(Collection<MonitoringDoc> var1) throws ExportException;

    public void flush(ActionListener<Void> listener) {
        if (this.closed.compareAndSet(false, true)) {
            this.doFlush(listener);
        } else {
            listener.onResponse(null);
        }
    }

    protected abstract void doFlush(ActionListener<Void> var1);

    public static class Compound
    extends ExportBulk {
        private final List<ExportBulk> bulks;

        public Compound(List<ExportBulk> bulks, ThreadContext threadContext) {
            super("all", threadContext);
            this.bulks = bulks;
        }

        @Override
        protected void doAdd(Collection<MonitoringDoc> docs) throws ExportException {
            ExportException exception = null;
            for (ExportBulk bulk : this.bulks) {
                try {
                    bulk.add(docs);
                }
                catch (ExportException e) {
                    if (exception == null) {
                        exception = new ExportException("failed to add documents to export bulks", new Object[0]);
                    }
                    exception.addExportException(e);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }

        @Override
        protected void doFlush(ActionListener<Void> listener) {
            SetOnce exceptionRef = new SetOnce();
            BiConsumer<ExportBulk, ActionListener> bulkBiConsumer = (exportBulk, iteratingListener) -> exportBulk.flush((ActionListener<Void>)ActionListener.wrap(arg_0 -> ((ActionListener)iteratingListener).onResponse(arg_0), e -> {
                if (exceptionRef.get() == null) {
                    exceptionRef.set((Object)new ExportException("failed to flush export bulks", (Throwable)e, new Object[0]));
                } else if (e instanceof ExportException) {
                    ((ExportException)exceptionRef.get()).addExportException((ExportException)((Object)e));
                } else {
                    ((ExportException)exceptionRef.get()).addSuppressed((Throwable)e);
                }
                iteratingListener.onResponse(null);
            }));
            IteratingActionListener iteratingActionListener = new IteratingActionListener(Compound.newExceptionHandlingListener((SetOnce<ExportException>)exceptionRef, listener), bulkBiConsumer, this.bulks, this.threadContext);
            iteratingActionListener.run();
        }

        private static ActionListener<Void> newExceptionHandlingListener(SetOnce<ExportException> exceptionRef, ActionListener<Void> listener) {
            return ActionListener.wrap(r -> {
                if (exceptionRef.get() == null) {
                    listener.onResponse(null);
                } else {
                    listener.onFailure((Exception)exceptionRef.get());
                }
            }, arg_0 -> listener.onFailure(arg_0));
        }
    }
}

