/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.Multicaster;
import org.igoweb.util.swing.APopupMenu;

public class AList<T>
extends JScrollPane {
    private final InnerList<T> list;
    private EventListener listener;

    public AList(ListCellRenderer<T> cellRenderer, int minRows) {
        this(cellRenderer, minRows, null, null);
    }

    public AList(ListCellRenderer<? super T> cellRenderer, int minRows, EventListener newListener) {
        this(cellRenderer, minRows, newListener, null);
    }

    public AList(ListCellRenderer<? super T> cellRenderer, int minRows, ListModel<T> model) {
        this(cellRenderer, minRows, null, model);
    }

    public AList(ListCellRenderer<? super T> cellRenderer, int minRows, EventListener newListener, ListModel<T> model) {
        this(cellRenderer, minRows, newListener, model, true);
    }

    public AList(ListCellRenderer<? super T> cellRenderer, int minRows, EventListener newListener, ListModel<T> model, boolean fixedCellSize) {
        super(22, 31);
        this.list = new InnerList<T>(minRows, model);
        this.listener = newListener;
        this.setViewportView(this.list);
        this.list.setCellRenderer(cellRenderer);
        if (fixedCellSize) {
            Dimension cellSize = ((Component)((Object)cellRenderer)).getMinimumSize();
            this.list.setFixedCellHeight(cellSize.height);
            this.list.setFixedCellWidth(cellSize.width);
        }
    }

    @Override
    public void setEnabled(boolean val) {
        super.setEnabled(val);
        this.list.setEnabled(val);
    }

    public void addListener(EventListener newListener) {
        this.listener = Multicaster.add(this.listener, newListener);
    }

    public void setListModel(ListModel<T> model) {
        this.list.setModel(model);
    }

    public ListModel<T> getListModel() {
        return this.list.getModel();
    }

    public final void addPopup(APopupMenu pop) {
        this.list.menu = pop;
    }

    public JList getInnerList() {
        return this.list;
    }

    protected void handleClick(Object pressObj) {
        if (this.listener != null) {
            this.listener.handleEvent(new Event(this, 0, pressObj));
        }
    }

    public class InnerList<TT>
    extends JList<TT>
    implements MouseListener,
    MouseMotionListener {
        public APopupMenu menu;
        private int mouseUnder;
        private Object pressObj;

        public InnerList(int minRows, ListModel<TT> model) {
            super(model == null ? new DefaultListModel() : model);
            this.menu = null;
            this.mouseUnder = -1;
            this.pressObj = null;
            this.setBackground(UIManager.getColor("org.igoweb.inputBg"));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setVisibleRowCount(minRows);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
            this.setMouseUnder(-1);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (this.isEnabled()) {
                if (event.isPopupTrigger()) {
                    this.pressObj = null;
                    this.popup(event);
                } else {
                    this.pressObj = this.mouseUnder();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (this.isEnabled()) {
                if (event.isPopupTrigger()) {
                    this.popup(event);
                } else if (this.pressObj != null && this.mouseUnder() == this.pressObj) {
                    AList.this.handleClick(this.pressObj);
                }
                this.pressObj = null;
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (this.isEnabled()) {
                int x = event.getX();
                int y = event.getY();
                int index = this.locationToIndex(new Point(x, y));
                int listSize = this.getModel().getSize();
                if (index < 0 || index >= listSize || index == listSize - 1 && !this.getCellBounds(index, index).contains(x, y)) {
                    this.setMouseUnder(-1);
                } else {
                    this.setMouseUnder(index);
                }
            }
        }

        private void setMouseUnder(int newMouseUnder) {
            if (newMouseUnder != this.mouseUnder) {
                int oldMouseUnder = this.mouseUnder;
                this.mouseUnder = newMouseUnder;
                this.repaintIndex(oldMouseUnder);
                this.repaintIndex(this.mouseUnder);
            }
        }

        private void repaintIndex(int index) {
            if (index != -1) {
                Point corner;
                int last = this.getLastVisibleIndex();
                if (index >= this.getFirstVisibleIndex() && (last == -1 || index <= this.getLastVisibleIndex()) && (corner = this.indexToLocation(index)) != null) {
                    this.repaint(corner.x, corner.y, this.getWidth(), this.getHeight());
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            this.mouseMoved(event);
        }

        private void popup(MouseEvent event) {
            if (this.menu == null) {
                return;
            }
            this.mouseMoved(event);
            this.menu.show(this, event.getX(), event.getY(), this.mouseUnder == -1 ? null : this.getModel().getElementAt(this.mouseUnder));
        }

        public Object mouseUnder() {
            Object result = null;
            if (this.mouseUnder != -1) {
                try {
                    result = this.getModel().getElementAt(this.mouseUnder);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (this.pressObj != null && this.pressObj != result) {
                result = null;
            }
            return result;
        }

        @Override
        public void setEnabled(boolean val) {
            super.setEnabled(val);
            this.setBackground(UIManager.getColor(val ? "org.igoweb.inputBg" : "org.igoweb.outputBg"));
            if (!val) {
                this.clearSelection();
            }
        }
    }
}

