package org.cdavies.itunes;

import org.cdavies.itunes.hash.*;
import org.cdavies.itunes.request.*;

public class Itunes4Connection implements ItunesConnection {
	
	private String _serverName;
	private int _port;
	private String _serverTitle;
	private boolean _connected;
	
	private Database[] _dbs;
	private Track[][] _tls;
	
	private int _sessionId;
	private ItunesHash _hash;
	private int _requestId;
	
	public Itunes4Connection(String server, int port, String serverTitle) {
		
		_serverName = server;
		_port = port;
		
		_connected = false;
		_requestId = 0;
		
		_serverTitle = serverTitle;
		
	}
	
	public boolean isConnected() {
		
		return _connected;
		
	}
	
	public void disconnect() {
		
		if (!_connected)
			return;
		
		_connected = false;
		
		try {
			
			LogoutRequest lr = new LegacyLogoutRequest(_serverName, _port, _sessionId);
			executeRequest(lr);
			
		}
		catch (NoServerPermissionException _e) {
			
			/* Non-fatal. Who cares if we failed to logout properly? */
			
			System.err.println("Non-Fatal Error: Failed to logout of server " + _serverName);
			
		}
		
	}
	
	private void executeRequest(GenericRequest req) throws NoServerPermissionException {
		
		req.setHash(_hash);
		req.constructQuery();
		req.runQuery();
		req.process();
		
	}
	
	public void connect() throws NoServerPermissionException {
		
		if (_connected)
			return;
		
		try {
			
			_hash = new Itunes4Hash();
			
		}
		catch (java.security.NoSuchAlgorithmException _e) {
			
			/* Extremely unlikely, but... */
			System.err.println("Java Environment is distributed without MD5 hash. Cannot Browse DAAP");
			return;
			
		}
		
		/* Connect and grab database details, and tracklists */
		
		LoginRequest lr = new LegacyLoginRequest(_serverName, _port);
		executeRequest(lr);
		_sessionId = lr.getSessionId();
		
		DatabaseRequest dr = new LegacyDatabaseRequest(_serverName, _port, _sessionId);
		executeRequest(dr);
		_dbs = dr.getDatabases();
		
		_tls = new Track[_dbs.length][];
		
		for (int _i = 0; _i < _dbs.length; _i++) {
			
			TracklistRequest tlr = new LegacyTracklistRequest(_serverName, _port, _sessionId, _dbs[_i].getId());
			executeRequest(tlr);
			_tls[_i] = tlr.getTracklist();
			
			for (int _j = 0; _j < _tls[_i].length; _j++) {
				
				_tls[_i][_j].setItunesConnection(this);
				_tls[_i][_j].setItunesHash(_hash);
				
			}
			
		}
		
		_connected = true;
		
		
	}
	
	public int getRequestNumber() {
		
		return ++_requestId;
		
	}
	
	public Database[] getDatabases() {
		
		return _dbs;
		
	}
	
	public Track[] getTracklist(int databaseId) {
		
		for (int _i = 0; _i < _dbs.length; _i++) {
			
			if (databaseId == _dbs[_i].getId())
				return _tls[_i];
			
		}
		
		return null;
		
	}
	
	public String toString() {
		
		return _serverTitle;
		
	}
	
	public String getServerName() {
		
		return _serverName;
		
	}
	
	public int getPort() {
		
		return _port;
		
	}
	
	public int getSessionId() {
		
		return _sessionId;
		
	}
	
}
