/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.command;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.activemq.apollo.openwire.command.ActiveMQMessage;
import org.apache.activemq.apollo.openwire.command.Message;
import org.apache.activemq.apollo.openwire.support.OpenwireException;
import org.apache.activemq.apollo.openwire.support.Settings;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.BufferEditor;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.fusesource.hawtbuf.ByteArrayOutputStream;

public class ActiveMQBytesMessage
extends ActiveMQMessage {
    public static final byte DATA_STRUCTURE_TYPE = 24;
    protected transient DataOutputStream dataOut;
    protected transient ByteArrayOutputStream bytesOut;
    protected transient DataInputStream dataIn;
    protected transient int length;

    public Message copy() {
        ActiveMQBytesMessage copy = new ActiveMQBytesMessage();
        this.copy(copy);
        return copy;
    }

    private void copy(ActiveMQBytesMessage copy) {
        this.storeContent();
        super.copy(copy);
        copy.dataOut = null;
        copy.bytesOut = null;
        copy.dataIn = null;
    }

    public void onSend() throws OpenwireException {
        super.onSend();
        this.storeContent();
    }

    private void storeContent() {
        try {
            if (this.dataOut != null) {
                this.dataOut.close();
                Buffer bs = this.bytesOut.toBuffer();
                if (this.compressed) {
                    int pos = bs.offset;
                    bs.offset = 0;
                    BufferEditor e = BufferEditor.big((Buffer)bs);
                    e.writeInt(this.length);
                    bs.offset = pos;
                }
                this.setContent(bs);
                this.bytesOut = null;
                this.dataOut = null;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage(), ioe);
        }
    }

    public byte getDataStructureType() {
        return 24;
    }

    public String getJMSXMimeType() {
        return "jms/bytes-message";
    }

    public void clearBody() throws OpenwireException {
        super.clearBody();
        this.dataOut = null;
        this.dataIn = null;
        this.bytesOut = null;
    }

    public long getBodyLength() throws OpenwireException {
        this.initializeReading();
        return this.length;
    }

    public boolean readBoolean() throws OpenwireException {
        this.initializeReading();
        try {
            return this.dataIn.readBoolean();
        }
        catch (EOFException e) {
            throw new OpenwireException(e);
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public byte readByte() throws OpenwireException {
        this.initializeReading();
        try {
            return this.dataIn.readByte();
        }
        catch (EOFException e) {
            throw new OpenwireException(e);
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public int readUnsignedByte() throws OpenwireException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedByte();
        }
        catch (EOFException e) {
            throw new OpenwireException(e);
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public short readShort() throws OpenwireException {
        this.initializeReading();
        try {
            return this.dataIn.readShort();
        }
        catch (EOFException e) {
            throw new OpenwireException(e);
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public int readUnsignedShort() throws OpenwireException {
        this.initializeReading();
        try {
            return this.dataIn.readUnsignedShort();
        }
        catch (EOFException e) {
            throw new OpenwireException(e);
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public char readChar() throws OpenwireException {
        this.initializeReading();
        try {
            return this.dataIn.readChar();
        }
        catch (EOFException e) {
            throw new OpenwireException(e);
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public int readInt() throws OpenwireException {
        this.initializeReading();
        try {
            return this.dataIn.readInt();
        }
        catch (EOFException e) {
            throw new OpenwireException(e);
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public long readLong() throws OpenwireException {
        this.initializeReading();
        try {
            return this.dataIn.readLong();
        }
        catch (EOFException e) {
            throw new OpenwireException(e);
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public float readFloat() throws OpenwireException {
        this.initializeReading();
        try {
            return this.dataIn.readFloat();
        }
        catch (EOFException e) {
            throw new OpenwireException(e);
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public double readDouble() throws OpenwireException {
        this.initializeReading();
        try {
            return this.dataIn.readDouble();
        }
        catch (EOFException e) {
            throw new OpenwireException(e);
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public String readUTF() throws OpenwireException {
        this.initializeReading();
        try {
            return this.dataIn.readUTF();
        }
        catch (EOFException e) {
            throw new OpenwireException(e);
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public int readBytes(byte[] value) throws OpenwireException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws OpenwireException {
        this.initializeReading();
        try {
            int n;
            int count;
            for (n = 0; n < length && (count = this.dataIn.read(value, n, length - n)) >= 0; n += count) {
            }
            if (n == 0 && length > 0) {
                n = -1;
            }
            return n;
        }
        catch (EOFException e) {
            throw new OpenwireException(e);
        }
        catch (IOException e) {
            throw new OpenwireException(e);
        }
    }

    public void writeBoolean(boolean value) throws OpenwireException {
        this.initializeWriting();
        try {
            this.dataOut.writeBoolean(value);
        }
        catch (IOException ioe) {
            throw new OpenwireException(ioe);
        }
    }

    public void writeByte(byte value) throws OpenwireException {
        this.initializeWriting();
        try {
            this.dataOut.writeByte(value);
        }
        catch (IOException ioe) {
            throw new OpenwireException(ioe);
        }
    }

    public void writeShort(short value) throws OpenwireException {
        this.initializeWriting();
        try {
            this.dataOut.writeShort(value);
        }
        catch (IOException ioe) {
            throw new OpenwireException(ioe);
        }
    }

    public void writeChar(char value) throws OpenwireException {
        this.initializeWriting();
        try {
            this.dataOut.writeChar(value);
        }
        catch (IOException ioe) {
            throw new OpenwireException(ioe);
        }
    }

    public void writeInt(int value) throws OpenwireException {
        this.initializeWriting();
        try {
            this.dataOut.writeInt(value);
        }
        catch (IOException ioe) {
            throw new OpenwireException(ioe);
        }
    }

    public void writeLong(long value) throws OpenwireException {
        this.initializeWriting();
        try {
            this.dataOut.writeLong(value);
        }
        catch (IOException ioe) {
            throw new OpenwireException(ioe);
        }
    }

    public void writeFloat(float value) throws OpenwireException {
        this.initializeWriting();
        try {
            this.dataOut.writeFloat(value);
        }
        catch (IOException ioe) {
            throw new OpenwireException(ioe);
        }
    }

    public void writeDouble(double value) throws OpenwireException {
        this.initializeWriting();
        try {
            this.dataOut.writeDouble(value);
        }
        catch (IOException ioe) {
            throw new OpenwireException(ioe);
        }
    }

    public void writeUTF(String value) throws OpenwireException {
        this.initializeWriting();
        try {
            this.dataOut.writeUTF(value);
        }
        catch (IOException ioe) {
            throw new OpenwireException(ioe);
        }
    }

    public void writeBytes(byte[] value) throws OpenwireException {
        this.initializeWriting();
        try {
            this.dataOut.write(value);
        }
        catch (IOException ioe) {
            throw new OpenwireException(ioe);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws OpenwireException {
        this.initializeWriting();
        try {
            this.dataOut.write(value, offset, length);
        }
        catch (IOException ioe) {
            throw new OpenwireException(ioe);
        }
    }

    public void writeObject(Object value) throws OpenwireException {
        if (value == null) {
            throw new NullPointerException();
        }
        this.initializeWriting();
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF(value.toString());
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new OpenwireException("Cannot write non-primitive type:" + value.getClass());
        }
    }

    public void reset() throws OpenwireException {
        this.storeContent();
        this.bytesOut = null;
        this.dataIn = null;
        this.dataOut = null;
        this.setReadOnlyBody(true);
    }

    private void initializeWriting() throws OpenwireException {
        this.checkReadOnlyBody();
        if (this.dataOut == null) {
            Object os = this.bytesOut = new ByteArrayOutputStream();
            if (Settings.enable_compression()) {
                try {
                    os.write(new byte[4]);
                }
                catch (IOException e) {
                    throw new OpenwireException(e);
                }
                this.length = 0;
                this.compressed = true;
                final Deflater deflater = new Deflater(1);
                os = new FilterOutputStream(new DeflaterOutputStream((OutputStream)os, deflater)){

                    public void write(byte[] arg0) throws IOException {
                        ActiveMQBytesMessage.this.length += arg0.length;
                        this.out.write(arg0);
                    }

                    public void write(byte[] arg0, int arg1, int arg2) throws IOException {
                        ActiveMQBytesMessage.this.length += arg2;
                        this.out.write(arg0, arg1, arg2);
                    }

                    public void write(int arg0) throws IOException {
                        ++ActiveMQBytesMessage.this.length;
                        this.out.write(arg0);
                    }

                    public void close() throws IOException {
                        super.close();
                        deflater.end();
                    }
                };
            }
            this.dataOut = new DataOutputStream((OutputStream)os);
        }
    }

    protected void checkWriteOnlyBody() throws OpenwireException {
        if (!this.readOnlyBody) {
            throw new OpenwireException("Message body is write-only");
        }
    }

    private void initializeReading() throws OpenwireException {
        this.checkWriteOnlyBody();
        if (this.dataIn == null) {
            Buffer data = this.getContent();
            if (data == null) {
                data = new Buffer(new byte[0], 0, 0);
            }
            Object is = new ByteArrayInputStream(data);
            if (this.isCompressed()) {
                try {
                    DataInputStream dis = new DataInputStream((InputStream)is);
                    this.length = dis.readInt();
                    dis.close();
                }
                catch (IOException e) {
                    throw new OpenwireException(e);
                }
                is = new InflaterInputStream((InputStream)is);
            } else {
                this.length = data.getLength();
            }
            this.dataIn = new DataInputStream((InputStream)is);
        }
    }

    public void setObjectProperty(String name, Object value) throws OpenwireException {
        this.initializeWriting();
        super.setObjectProperty(name, value);
    }

    public String toString() {
        return super.toString() + " ActiveMQBytesMessage{ " + "bytesOut = " + this.bytesOut + ", dataOut = " + this.dataOut + ", dataIn = " + this.dataIn + " }";
    }
}

