/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import com.google.common.base.Function;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import org.apache.cassandra.cache.CacheProvider;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.Memory;
import org.apache.cassandra.utils.Pair;
import org.caffinitas.ohc.CacheSerializer;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.OHCacheBuilder;

public class OHCProvider
implements CacheProvider<RowCacheKey, IRowCacheEntry> {
    @Override
    public ICache<RowCacheKey, IRowCacheEntry> create() {
        OHCacheBuilder builder = OHCacheBuilder.newBuilder();
        builder.capacity(DatabaseDescriptor.getRowCacheSizeInMB() * 1024L * 1024L).keySerializer((CacheSerializer)new KeySerializer()).valueSerializer((CacheSerializer)new ValueSerializer()).throwOOME(true);
        return new OHCacheAdapter((OHCache<RowCacheKey, IRowCacheEntry>)builder.build());
    }

    static class DataOutputPlusAdapter
    implements DataOutputPlus {
        private final DataOutput out;

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.out.writeBoolean(v);
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.out.writeByte(v);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            this.out.writeBytes(s);
        }

        @Override
        public void writeChar(int v) throws IOException {
            this.out.writeChar(v);
        }

        @Override
        public void writeChars(String s) throws IOException {
            this.out.writeChars(s);
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.out.writeDouble(v);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.out.writeFloat(v);
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.out.writeInt(v);
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.out.writeLong(v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.out.writeShort(v);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            this.out.writeUTF(s);
        }

        public DataOutputPlusAdapter(DataOutput out) {
            this.out = out;
        }

        @Override
        public void write(ByteBuffer buffer) throws IOException {
            if (!buffer.hasArray()) {
                throw new UnsupportedOperationException("IMPLEMENT ME");
            }
            this.out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        }

        @Override
        public void write(Memory memory, long offset, long length) throws IOException {
            throw new UnsupportedOperationException("IMPLEMENT ME");
        }

        @Override
        public <R> R applyToChannel(Function<WritableByteChannel, R> c) throws IOException {
            throw new UnsupportedOperationException("IMPLEMENT ME");
        }
    }

    private static class ValueSerializer
    implements CacheSerializer<IRowCacheEntry> {
        private ValueSerializer() {
        }

        public void serialize(IRowCacheEntry entry, DataOutput out) throws IOException {
            assert (entry != null);
            boolean isSentinel = entry instanceof RowCacheSentinel;
            out.writeBoolean(isSentinel);
            if (isSentinel) {
                out.writeLong(((RowCacheSentinel)entry).sentinelId);
            } else {
                ColumnFamily.serializer.serialize((ColumnFamily)entry, (DataOutputPlus)new DataOutputPlusAdapter(out), 9);
            }
        }

        public IRowCacheEntry deserialize(DataInput in) throws IOException {
            boolean isSentinel = in.readBoolean();
            if (isSentinel) {
                return new RowCacheSentinel(in.readLong());
            }
            return ColumnFamily.serializer.deserialize(in, 9);
        }

        public int serializedSize(IRowCacheEntry entry) {
            TypeSizes typeSizes = TypeSizes.NATIVE;
            int size = typeSizes.sizeof(true);
            size = entry instanceof RowCacheSentinel ? (size += typeSizes.sizeof(((RowCacheSentinel)entry).sentinelId)) : (int)((long)size + ColumnFamily.serializer.serializedSize((ColumnFamily)entry, typeSizes, 9));
            return size;
        }
    }

    private static class KeySerializer
    implements CacheSerializer<RowCacheKey> {
        private KeySerializer() {
        }

        public void serialize(RowCacheKey rowCacheKey, DataOutput dataOutput) throws IOException {
            dataOutput.writeUTF((String)rowCacheKey.ksAndCFName.left);
            dataOutput.writeUTF((String)rowCacheKey.ksAndCFName.right);
            dataOutput.writeInt(rowCacheKey.key.length);
            dataOutput.write(rowCacheKey.key);
        }

        public RowCacheKey deserialize(DataInput dataInput) throws IOException {
            String ksName = dataInput.readUTF();
            String cfName = dataInput.readUTF();
            byte[] key = new byte[dataInput.readInt()];
            dataInput.readFully(key);
            return new RowCacheKey(Pair.create(ksName, cfName), key);
        }

        public int serializedSize(RowCacheKey rowCacheKey) {
            return TypeSizes.NATIVE.sizeof((String)rowCacheKey.ksAndCFName.left) + TypeSizes.NATIVE.sizeof((String)rowCacheKey.ksAndCFName.right) + 4 + rowCacheKey.key.length;
        }
    }

    private static class OHCacheAdapter
    implements ICache<RowCacheKey, IRowCacheEntry> {
        private final OHCache<RowCacheKey, IRowCacheEntry> ohCache;

        public OHCacheAdapter(OHCache<RowCacheKey, IRowCacheEntry> ohCache) {
            this.ohCache = ohCache;
        }

        @Override
        public long capacity() {
            return this.ohCache.capacity();
        }

        @Override
        public void setCapacity(long capacity) {
            this.ohCache.setCapacity(capacity);
        }

        @Override
        public void put(RowCacheKey key, IRowCacheEntry value) {
            this.ohCache.put((Object)key, (Object)value);
        }

        @Override
        public boolean putIfAbsent(RowCacheKey key, IRowCacheEntry value) {
            return this.ohCache.putIfAbsent((Object)key, (Object)value);
        }

        @Override
        public boolean replace(RowCacheKey key, IRowCacheEntry old, IRowCacheEntry value) {
            return this.ohCache.addOrReplace((Object)key, (Object)old, (Object)value);
        }

        @Override
        public IRowCacheEntry get(RowCacheKey key) {
            return (IRowCacheEntry)this.ohCache.get((Object)key);
        }

        @Override
        public void remove(RowCacheKey key) {
            this.ohCache.remove((Object)key);
        }

        @Override
        public int size() {
            return (int)this.ohCache.size();
        }

        @Override
        public long weightedSize() {
            return this.ohCache.memUsed();
        }

        @Override
        public void clear() {
            this.ohCache.clear();
        }

        @Override
        public Iterator<RowCacheKey> hotKeyIterator(int n) {
            return this.ohCache.hotKeyIterator(n);
        }

        @Override
        public Iterator<RowCacheKey> keyIterator() {
            return this.ohCache.keyIterator();
        }

        @Override
        public boolean containsKey(RowCacheKey key) {
            return this.ohCache.containsKey((Object)key);
        }
    }
}

