/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.FloatBuffer;

final class FloatBufferImpl
extends FloatBuffer {
    private boolean readOnly;

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final FloatBuffer slice() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public final FloatBuffer duplicate() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public final FloatBuffer asReadOnlyBuffer() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public final FloatBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int copied = 0;
        while (this.remaining() > 0) {
            this.put(copied, this.get());
            ++copied;
        }
        this.position(copied);
        this.limit(this.capacity());
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final float get() {
        this.checkForUnderflow();
        float result = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return result;
    }

    public final FloatBuffer put(float value) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        this.backing_buffer[this.position()] = value;
        this.position(this.position() + 1);
        return this;
    }

    public final float get(int index) {
        this.checkIndex(index);
        return this.backing_buffer[index];
    }

    public final FloatBuffer put(int index, float value) {
        this.checkIfReadOnly();
        this.checkIndex(index);
        this.backing_buffer[index] = value;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    FloatBufferImpl(int capacity) {
        this(new float[capacity], 0, capacity, capacity, 0, -1, false);
    }

    FloatBufferImpl(float[] buffer, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(capacity, limit, position, mark);
        this.backing_buffer = buffer;
        this.array_offset = offset;
        this.readOnly = readOnly;
    }
}

