/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre.core.time;

import com.projectlibre.core.time.DefaultTimeInterval;
import com.projectlibre.core.time.TimeInterval;
import com.projectlibre.core.time.TimeIntervals;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;

public class DefaultTimeIntervals
implements TimeIntervals {
    protected static long EMPTY_START = -1L;
    protected static long EMPTY_END = -1L;
    protected TreeSet<TimeInterval> intervals = new TreeSet<TimeInterval>(new Comparator<TimeInterval>(){

        @Override
        public int compare(TimeInterval timeInterval, TimeInterval timeInterval2) {
            if (timeInterval.getStart() < timeInterval2.getStart()) {
                return -1;
            }
            if (timeInterval.getStart() == timeInterval2.getStart()) {
                return 0;
            }
            return 1;
        }
    });

    public DefaultTimeIntervals() {
    }

    public DefaultTimeIntervals(long l, long l2) {
        this();
        this.intervals.add(new DefaultTimeInterval(l, l2));
    }

    @Override
    public long getStart() {
        return this.intervals.isEmpty() ? EMPTY_START : this.intervals.first().getStart();
    }

    @Override
    public void setStart(long l) {
        TimeInterval timeInterval = this.isEmpty() ? new DefaultTimeInterval() : this.intervals.first();
        timeInterval.setStart(l);
    }

    @Override
    public long getEnd() {
        return this.isEmpty() ? EMPTY_END : this.intervals.last().getEnd();
    }

    @Override
    public void setEnd(long l) {
        TimeInterval timeInterval = this.isEmpty() ? new DefaultTimeInterval() : this.intervals.last();
        timeInterval.setEnd(l);
    }

    @Override
    public Collection<TimeInterval> getIntervals() {
        return this.intervals;
    }

    @Override
    public void addInterval(TimeInterval timeInterval) {
        this.intervals.add(timeInterval);
    }

    @Override
    public Iterator<TimeInterval> iterator() {
        return this.intervals.iterator();
    }

    @Override
    public void clear() {
        this.intervals.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    @Override
    public int size() {
        return this.intervals.size();
    }

    @Override
    public void union(TimeInterval timeInterval) {
        TimeInterval timeInterval2;
        NavigableSet<TimeInterval> navigableSet;
        TimeInterval timeInterval3 = this.intervals.lower(timeInterval);
        if (timeInterval3 != null && timeInterval.getStart() <= timeInterval3.getEnd()) {
            timeInterval = new DefaultTimeInterval(timeInterval3.getStart(), timeInterval.getEnd());
        }
        if (!(navigableSet = this.intervals.subSet(timeInterval, true, new DefaultTimeInterval(timeInterval.getEnd(), timeInterval.getEnd()), true)).isEmpty() && (timeInterval2 = (TimeInterval)navigableSet.last()) != null && timeInterval.getEnd() <= timeInterval2.getEnd()) {
            timeInterval = new DefaultTimeInterval(timeInterval.getStart(), timeInterval2.getEnd());
        }
        this.intervals.removeAll(navigableSet);
        this.intervals.add(timeInterval);
    }

    @Override
    public void inter(TimeInterval timeInterval) {
    }

    @Override
    public void union(long l, long l2) {
        this.union(new DefaultTimeInterval(l, l2));
    }

    @Override
    public void inter(long l, long l2) {
        this.inter(new DefaultTimeInterval(l, l2));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DefaultTimeIntervals)) {
            return false;
        }
        DefaultTimeIntervals defaultTimeIntervals = (DefaultTimeIntervals)object;
        if (this.size() != defaultTimeIntervals.size()) {
            return false;
        }
        Iterator<TimeInterval> iterator = this.iterator();
        Iterator<TimeInterval> iterator2 = defaultTimeIntervals.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().equals(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (TimeInterval timeInterval : this.intervals) {
            if (n++ != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(timeInterval);
        }
        return stringBuffer.toString();
    }
}

