/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.completion.ClassUsageContext;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.impl.MethodImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassReferenceImpl
extends PhpReferenceImpl
implements ClassReference {
    private static final TokenSet NN = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.IDENTIFIER, PhpTokenTypes.VARIABLE, PhpTokenTypes.kwSTATIC, PhpTokenTypes.kwARRAY});

    public ClassReferenceImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            ClassReferenceImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof PhpElementVisitor) {
            ((PhpElementVisitor)visitor).visitPhpClassReference((ClassReference)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public String getSignature() {
        String className = this.getFQN();
        if (PhpLangUtil.isClassNameSpecial(className)) {
            PhpClass phpClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)this, PhpClass.class);
            className = phpClass != null ? ("parent".equalsIgnoreCase(className) ? (phpClass.isTrait() ? "0" : phpClass.getSuperFQN()) : phpClass.getFQN()) : "";
        }
        String string = PhpTypeSignatureKey.CLASS.sign((CharSequence)className);
        if (string == null) {
            ClassReferenceImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        String name = this.getName();
        String namespaceName = this.getNamespaceName();
        Collection<? extends PhpNamedElement> collection = ClassReferenceImpl.resolveGlobal(this, name, namespaceName, false);
        if (collection == null) {
            ClassReferenceImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public static Collection<? extends PhpNamedElement> resolveGlobal(PhpReference e, String name, String namespaceName, boolean newToClassOnly) {
        PhpClass phpClass;
        THashSet result = new THashSet();
        PhpIndex phpIndex = PhpIndex.getInstance((Project)e.getProject());
        if (StringUtil.isEmpty((String)name)) {
            return Collections.emptySet();
        }
        Collection<Object> classes = new ArrayList<PhpClass>();
        boolean foreign = ClassReferenceImpl.isInForeignFunction(e);
        if (!foreign && ("self".equals(name) || "static".equals(name))) {
            phpClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)e, PhpClass.class);
            if (phpClass != null) {
                classes.add(phpClass);
            }
        } else if (!foreign && "parent".equalsIgnoreCase(name) && (phpClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)e, PhpClass.class)) != null) {
            PhpClass superClass;
            if (phpClass.isTrait()) {
                Collection traitUsagesByName = phpIndex.getNestedTraitUsages(phpClass, null);
                result.addAll(traitUsagesByName);
            } else if (phpClass.getSuperFQN() != null && (superClass = phpClass.getSuperClass()) != null) {
                name = superClass.getName();
                namespaceName = superClass.getNamespaceName();
            }
        }
        PsiElement parent = e.getParent();
        boolean instantiation = parent instanceof NewExpression;
        Set<? extends PhpNamedElement> locals = ClassReferenceImpl.resolveLocal(e, name, namespaceName);
        for (PhpNamedElement phpNamedElement : locals) {
            if (phpNamedElement instanceof PhpUse) {
                PhpReference reference = ((PhpUse)phpNamedElement).getTargetReference();
                if (reference == null) continue;
                name = reference.getName();
                namespaceName = reference.getNamespaceName();
                continue;
            }
            if (!(phpNamedElement instanceof PhpClass)) continue;
            classes.add((PhpClass)phpNamedElement);
        }
        if (result.size() == 0 && classes.size() == 0) {
            String fqn;
            Collection interfaces = phpIndex.filterByNamespace(phpIndex.getInterfacesByName(name), namespaceName);
            result.addAll(interfaces);
            Collection collection = phpIndex.filterByNamespace(phpIndex.getTraitsByName(name), namespaceName);
            result.addAll(collection);
            classes = PhpIndex.getInstance((Project)e.getProject()).filterByNamespace(phpIndex.getClassesByName(name), namespaceName);
            if ((parent instanceof Parameter || parent instanceof PhpReturnType || e instanceof PhpDocType) && "\\object".equalsIgnoreCase(fqn = namespaceName + name) && !PhpLangUtil.isSpecialPrimitiveType(fqn, e.getProject())) {
                classes = PhpIndex.getInstance((Project)e.getProject()).getClassesByFQN("\\___PHPSTORM_HELPERS\\object");
            }
        }
        for (PhpClass phpClass2 : classes) {
            if (!newToClassOnly && instantiation) {
                Method constructor = phpClass2.getConstructor();
                if (constructor != null) {
                    PhpClass containingClass = constructor.getContainingClass();
                    if (containingClass == null) continue;
                    if (constructor.getContainingClass() == phpClass2) {
                        result.add(constructor);
                        continue;
                    }
                    result.add(phpClass2);
                    continue;
                }
                result.add(phpClass2);
                continue;
            }
            result.add(phpClass2);
        }
        if (parent instanceof PhpUse && !((PhpUse)parent).isTraitImport()) {
            result.addAll(phpIndex.getNamespacesByName(e.getNamespaceName() + e.getName()));
        }
        return PhpReferenceImpl.extendedResolve2(e, (Collection<? extends PhpNamedElement>)result);
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        Collection<? extends PhpNamedElement> collection = ClassReferenceImpl.resolveLocal(this);
        if (collection == null) {
            ClassReferenceImpl.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public PhpType resolveLocalType() {
        boolean foreign = ClassReferenceImpl.isInForeignFunction(this);
        if (!foreign && PhpLangUtil.isParentReference(this)) {
            PhpType type = new PhpType();
            PhpClass phpClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)this, PhpClass.class);
            if (phpClass != null) {
                type.add(phpClass.getSuperFQN());
            }
            PhpType phpType = type;
            if (phpType == null) {
                ClassReferenceImpl.$$$reportNull$$$0(4);
            }
            return phpType;
        }
        if (!foreign && PhpLangUtil.isSelfReference(this)) {
            PhpType type = new PhpType();
            PhpClass phpClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)this, PhpClass.class);
            if (phpClass != null) {
                type.add(phpClass.getFQN());
            }
            PhpType phpType = type;
            if (phpType == null) {
                ClassReferenceImpl.$$$reportNull$$$0(5);
            }
            return phpType;
        }
        if (!foreign && PhpLangUtil.isStaticReference(this)) {
            if (this.getParent() instanceof NewExpression) {
                PhpType phpType = PhpType.STATIC;
                if (phpType == null) {
                    ClassReferenceImpl.$$$reportNull$$$0(6);
                }
                return phpType;
            }
            PhpType type = new PhpType();
            PhpClass phpClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)this, PhpClass.class);
            if (phpClass != null) {
                type.add(phpClass.getFQN());
            }
            PhpType phpType = type;
            if (phpType == null) {
                ClassReferenceImpl.$$$reportNull$$$0(7);
            }
            return phpType;
        }
        PhpType phpType = new PhpType().add(this.getFQN());
        if (phpType == null) {
            ClassReferenceImpl.$$$reportNull$$$0(8);
        }
        return phpType;
    }

    public static Collection<? extends PhpNamedElement> resolveLocal(@NotNull ClassReference classReference) {
        if (classReference == null) {
            ClassReferenceImpl.$$$reportNull$$$0(9);
        }
        if (classReference.isAbsolute()) {
            return Collections.emptySet();
        }
        String name = classReference.getName();
        return ClassReferenceImpl.resolveLocal((PhpReference)classReference, name, classReference.getNamespaceName());
    }

    public static Set<? extends PhpNamedElement> resolveLocal(PhpReference e, String name, String currentNamespace) {
        if (name == null) {
            return Collections.emptySet();
        }
        boolean foreign = ClassReferenceImpl.isInForeignFunction(e);
        if (!foreign && ("self".equals(name) || "static".equals(name) || "$this".equals(name))) {
            PhpDocComment comment;
            PhpClass phpClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)e, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (phpClass != null && !phpClass.isTrait()) {
                return Collections.singleton(phpClass);
            }
            if (PhpPsiUtil.isOfType(e.getParent(), (IElementType)PhpDocElementTypes.phpDocMethodType) && (comment = (PhpDocComment)PhpPsiUtil.getParentByCondition((PsiElement)e, true, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF)) != null) {
                PsiElement owner = comment.getOwner();
                return owner instanceof PhpClass ? Collections.singleton((PhpClass)owner) : Collections.emptySet();
            }
        }
        THashSet result = new THashSet();
        String immediateNS = e.getImmediateNamespaceName();
        boolean referenceIsFqn = immediateNS.length() > 0 && immediateNS.charAt(0) == '\\' && !PhpLangUtil.mayBeReferenceToUserDefinedClass(immediateNS + name, e.getProject());
        boolean skipUses = referenceIsFqn || PhpReferenceImpl.isImport((PhpPsiElement)e);
        String fqn = currentNamespace + name;
        PsiFile file = e.getContainingFile();
        if (file instanceof PhpFile) {
            MultiMap map = ((PhpFile)file).getTopLevelDefs();
            Collection its = map.get((Object)fqn);
            for (PhpNamedElement it : its) {
                if (!(it instanceof PhpClass) && (!(it instanceof PhpUse) || skipUses || PhpUseImpl.isOfFunction((PhpUse)it) || PhpUseImpl.isOfConst((PhpUse)it))) continue;
                result.add(it);
            }
        }
        return result;
    }

    private static boolean isInForeignFunction(PhpReference e) {
        Function f = (Function)PsiTreeUtil.getParentOfType((PsiElement)e, Function.class);
        return f != null && !(f instanceof Method) && !f.isClosure();
    }

    @Override
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(NN);
    }

    @Override
    public PsiElement handleElementRename(@NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            ClassReferenceImpl.$$$reportNull$$$0(10);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            ConstantReference constantReference = PhpPsiElementFactory.createConstantReference(this.getProject(), name);
            ASTNode newNameNode = constantReference.getNameNode();
            assert (newNameNode != null);
            nameNode.getTreeParent().replaceChild(nameNode, newNameNode);
        }
        return this;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ClassReferenceImpl.$$$reportNull$$$0(11);
        }
        if (this.isReferenceTo(element)) {
            return this;
        }
        if (element instanceof PsiNamedElement) {
            return this.handleElementRename(((PsiNamedElement)element).getName());
        }
        return this;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ClassReferenceImpl.$$$reportNull$$$0(12);
        }
        if (element instanceof MethodImpl && this.getParent() instanceof NewExpression && ((MethodImpl)element).getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
            PsiElement target = this.resolve();
            if (target instanceof PhpClass) {
                boolean[] hit = new boolean[]{false};
                PhpClassHierarchyUtils.processSuperClasses((PhpClass)((PhpClass)target), (boolean)true, (boolean)false, aClass -> {
                    if (element == null) {
                        ClassReferenceImpl.$$$reportNull$$$0(14);
                    }
                    hit[0] = aClass.getConstructor() == element;
                    return hit[0];
                });
                return hit[0];
            }
            if (target instanceof Method) {
                return target == element;
            }
        }
        if (element instanceof PhpClass || element instanceof Method || element instanceof PhpNamespace || element instanceof PhpUse) {
            if (element instanceof PhpClass) {
                PhpClass c = (PhpClass)element;
                String fqn = this.getFQN();
                if (fqn != null && PhpLangUtil.equalsClassNames(fqn, c.getFQN())) {
                    return true;
                }
            }
            ResolveResult[] results = this.multiResolve(false);
            boolean isReference = false;
            for (ResolveResult result : results) {
                if (!result.isValidResult() || result.getElement() != element) continue;
                isReference = true;
                break;
            }
            if (isReference) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public ClassUsageContext getUsageContext() {
        ClassUsageContext context = new ClassUsageContext(false);
        PsiElement parent = this.getParent();
        if (PhpPsiUtil.isOfType(parent, PhpElementTypes.INSTANCEOF_EXPRESSION)) {
            context.setInInstanceof(true);
        }
        if (PhpPsiUtil.isOfType(parent, PhpElementTypes.EXTENDS_LIST)) {
            context.setInExtends(true);
        }
        if (PhpPsiUtil.isOfType(parent, PhpElementTypes.IMPLEMENTS_LIST)) {
            context.setInImplements(true);
        }
        if (PhpPsiUtil.isOfType(parent, PhpElementTypes.NEW_EXPRESSION)) {
            context.setInNew(true);
        }
        if (PhpPsiUtil.isOfType(parent, PhpStubElementTypes.USE) && PhpPsiUtil.isOfType(parent.getParent().getParent(), PhpStubElementTypes.CLASS)) {
            context.setInClassUse(true);
        }
        ClassUsageContext classUsageContext = context;
        if (classUsageContext == null) {
            ClassReferenceImpl.$$$reportNull$$$0(13);
        }
        return classUsageContext;
    }

    @Override
    @Nullable
    public String getFQN() {
        Collection<? extends PhpNamedElement> elements = ClassReferenceImpl.resolveLocal(this);
        if (elements.size() == 1) {
            return elements.iterator().next().getFQN();
        }
        String className = this.getName();
        if (StringUtil.isEmpty((String)className)) {
            return null;
        }
        return PhpLangUtil.isClassNameSpecial(className) ? className : this.getNamespaceName() + className;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/ClassReferenceImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/ClassReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocal";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isReferenceTo$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

