/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.groupUse;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.intentions.groupUse.PhpConvertUseIntentionBase;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpSplitSelectedGroupUseStatementIntention
extends PhpConvertUseIntentionBase {
    public static final String TEXT = "Split selected group use statement";

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpSplitSelectedGroupUseStatementIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpSplitSelectedGroupUseStatementIntention.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return false;
        }
        PhpUseList useList = PhpUseImpl.getUseList(element);
        if (useList == null || useList.isTraitImport() || PhpPsiUtil.getChildOfType((PsiElement)useList, PhpElementTypes.USE_BRACES) == null) {
            return false;
        }
        return useList.getNamespaceReference() != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            PhpSplitSelectedGroupUseStatementIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpSplitSelectedGroupUseStatementIntention.$$$reportNull$$$0(3);
        }
        PhpUseList useList = PhpUseImpl.getUseList(element);
        assert (useList != null);
        PsiElement useListParent = useList.getParent();
        assert (useListParent != null);
        PhpNamespaceReference namespaceReference = useList.getNamespaceReference();
        assert (namespaceReference != null);
        String basis = PhpLangUtil.toFQN(namespaceReference.getFullName());
        for (PhpUse use : useList.getDeclarations()) {
            String keyword = PhpGroupUseElement.getKeyword(use, useList);
            String fqn = PhpLangUtil.concat(basis, PhpUseImpl.getReferenceText(use));
            String alias = use.getAliasName();
            PhpUseList newUseList = PhpPsiElementFactory.createUseStatementWithKeyword(project, keyword, fqn, alias);
            useListParent.addBefore((PsiElement)newUseList, (PsiElement)useList);
        }
        useList.delete();
    }

    @NotNull
    public String getText() {
        if (TEXT == null) {
            PhpSplitSelectedGroupUseStatementIntention.$$$reportNull$$$0(4);
        }
        return TEXT;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if (TEXT == null) {
            PhpSplitSelectedGroupUseStatementIntention.$$$reportNull$$$0(5);
        }
        return TEXT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/groupUse/PhpSplitSelectedGroupUseStatementIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/groupUse/PhpSplitSelectedGroupUseStatementIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

