/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.psr0;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.roots.PhpNamespaceByPsrProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIllegalPsrClassPathInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIllegalPsrClassPathInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFile(PhpFile file) {
                PsiElement identifier;
                PhpClass clazz = this.findMainClass(FileUtil.getNameWithoutExtension((String)file.getName()), (PsiElement)file);
                if (clazz != null && (identifier = clazz.getNameIdentifier()) != null) {
                    this.processClass(clazz, clazz.getContainingFile(), "", identifier);
                }
            }

            public void visitPhpNamespace(PhpNamespace namespace) {
                PsiFile file = namespace.getContainingFile();
                PhpClass clazz = this.findMainClass(FileUtil.getNameWithoutExtension((String)file.getName()), (PsiElement)namespace);
                if (clazz == null) {
                    return;
                }
                PsiElement identifier = namespace.getNameIdentifier();
                if (identifier == null) {
                    identifier = PhpPsiUtil.getChildOfType((PsiElement)namespace, PhpTokenTypes.kwNAMESPACE);
                }
                if (identifier != null) {
                    this.processClass(clazz, file, StringUtil.notNullize((String)namespace.getFQN()), identifier);
                }
            }

            @Nullable
            private PhpClass findMainClass(@Nullable String fileName, @Nullable PsiElement root) {
                Object group = PhpPsiUtil.getChildByCondition(root, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
                List<PhpClass> classes = PhpPsiUtil.getChildren((PsiElement)(group == null ? root : group), (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                if (classes.isEmpty()) {
                    return null;
                }
                for (PhpClass clazz : classes) {
                    if (!PhpLangUtil.equalsIgnoreCase(clazz.getNameCS(), fileName)) continue;
                    return clazz;
                }
                return classes.iterator().next();
            }

            private void processClass(@NotNull PhpClass clazz, @NotNull PsiFile file, @NotNull String namespace, @Nullable PsiElement namespaceIdentifier) {
                PsiDirectory directory;
                if (clazz == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (namespace == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((directory = file.getContainingDirectory()) == null) {
                    return;
                }
                List<String> namespaces = PhpNamespaceByPsrProvider.INSTANCE.suggestNamespaces(directory);
                if (namespaces.isEmpty()) {
                    return;
                }
                if (namespaces.contains(PhpLangUtil.toPresentableFQN(namespace))) {
                    PsiElement element;
                    String fileName = FileUtil.getNameWithoutExtension((String)file.getName());
                    if (!PhpLangUtil.equals(fileName, clazz.getNameCS()) && (element = clazz.getNameIdentifier()) != null) {
                        holder.registerProblem(element, PhpBundle.message("inspection.illegal.psr.class.path.class.is.not.matched.to.psr0", new Object[0]), new LocalQuickFix[0]);
                    }
                } else if (namespaceIdentifier != null) {
                    holder.registerProblem(namespaceIdentifier, PhpBundle.message("inspection.illegal.psr.class.path.namespace.name.is.not.matched.to.psr0", new Object[0]), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "clazz";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "namespace";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/psr0/PhpIllegalPsrClassPathInspection$1";
                objectArray[2] = "processClass";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (phpElementVisitor == null) {
            PhpIllegalPsrClassPathInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/psr0/PhpIllegalPsrClassPathInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/psr0/PhpIllegalPsrClassPathInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

