/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.ui;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpPredefinedCodeStyleBase;
import com.jetbrains.php.lang.formatter.ui.PhpSmartIndentOptionsEditor;
import com.jetbrains.php.refactoring.PhpNameStyle;
import org.jetbrains.annotations.NotNull;

public class PhpLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    private static final String SPACING_CODE_SAMPLE = "<?php\ndeclare(strict_types=1);\n\nclass Foo\n{\n    function foo($x, $z)\n    {\n        global $k, $s1;\n        $obj->foo()->bar();\n        $arr = array(0 => \"zero\", 1 => \"one\");\n  call_func(function() { return 0; });\n        for ($i = 0; $i < $x; $i++) {\n            $y += ($y ^ 0x123) << 2;\n        }\n        $k = $x > 15 ? 1 : 2;\n        $k = $x ?: 0;\n        $k = $x ?? $z;\n        $k = $x <=> $z;\n        do {\n            try {\n                if (!0 > $x && !$x < 10) {\n                    while ($x != $y) {\n                        $x = f($x * 3 + 5);\n                    }\n                    $z += 2;\n                } elseif ($x > 20) {\n                    $z = $x << 1;\n                } else {\n                    $z = $x | 2;\n                }\n                $j = (int)$z;\n                switch ($j) {\n                    case 0:\n                        $s1 = 'zero';\n                        break;\n                    case 2:\n                        $s1 = 'two';\n                        break;\n                    default:\n                        $s1 = 'other';\n                }\n            } catch (exception $e) {\n                $t = $one[0];\n                $u = $one['str'];\n                $v = $one[$x[1]];\n                echo $val{foo . $num}[$cell{$a}];\n            } finally {\n                // do something\n            }\n        } while ($x < 0);\n    }\n}\nfunction bar() : Foo\n{\n}\n?><div><?=foo()?></div>";
    private static final String GENERAL_CODE_SAMPLE = "<?php\nclass Foo {\n  var $x;\n  var $y;\n\n  \n/* C-style comment */    var $arr;\n\nfunction foo ($x, $z)\n{\nglobal $k,$s1;\n  for ($i = 0; $i < $x; $i++) { /* Another C-style comment */$y += ($y ^ 0x123) <<   2;   }\n\n\n    \n$k = $x > 15 ? 1 : 2;\n      do   {\n  try {if(0 < $x && $x < 10) {\n         while ($x != $y) {$x = f($x * 3 + 5);\n          }\n          $z += 2;}elseif   (   $x > 20    ) { $z = $x << 1;\n        }else {\n    $z = $x | 2;  }\n     $j = (int) $z;\n        switch($j) {   case 0:\n             $s1 = 'zero';         break;\n           case 2:\n              $s1 = 'two';\n            break;\n           default:\n$s1 = 'other';\n        }\n      }catch (exception $e) {\necho $val{         foo.$num      }[$cell{$a}];\n      }\n    }\n    while(true);\n}}?>";
    private static final String BLANK_LINE_CODE_SAMPLE = "<?php\nnamespace Acme\\Package;\nuse Acme\\Foo;\nuse Acme\\Bar;\nclass Foo {\n    var $x;\n    var $y;\n    function foo() {\n\n    }\n}\nclass Bar {\n    const X = 1;\n    const Y = 2;\n    var $a;\n    var $b;\n    function bar() {\n        $a = \"a\";\n\n\n        $b = \"b\";\n\n        \n    }\nfunction bar_2() {\n return this::$a . this::$b;\n}\n\nfunction bar_3() {\necho \"null\";\n return null;\n}\n\n\n\n}\n\n\nfunction function_declaration() {\n\n}\nregister_function('function_declaration');\n?>";
    private static final String WRAPPING_CODE_SAMPLE = "<?php\nuse N\\{ClassName,AnotherClassName,OneMoreClassName};\nnamespace A {\nfunction foo() {return 0;}\n\nfunction bar($x,\n$y, int $z=1) {\n$x = 0;\n// $x = 1\ndo { $y += 1; }\nwhile ($y < 10);\nif (true) $x = 10;\nelseif ($y < 10) $x = 5;\nelse if (true) $x = 5;\nfor($i=0;$i<10;$i++) $yy = $x > 2 ?1:2;\nwhile(true) $x = 0;\ndo {$x += 1;} while (true);\nforeach(array(\"a\"=>0,\"b\"=>1,\n\"c\"=>2) as $e1){echo $e1;}\n$count = 10;\n$x = array(\"x\",\"y\",\narray(1=>\"abc\",\n2=>\"def\",3=>\"ghi\"));\n$zz = array(0.1,0.2,\n0.3,0.4);\n$x = array(\n0 => \"zero\",\n123 => \"one two three\",\n25 => \"two five\"\n);bar(0,bar(1,\n\"b\"));\n}\n\nabstract class Foo extends FooBaseClass implements Bar1, Bar2, Bar3 {\n\n  var $numbers = array(\"one\", \"two\", \"three\", \"four\", \"five\", \"six\");\n var $v = 0;\n public $path = \"root\";\n\nconst FIRST = 'first';\nconst SECOND = 0;const Z = -1;\n\nfunction bar($v,\n$w=\"a\") {\n$y=$w;\n$result = foo(\"arg1\",\n\"arg2\",\n10);\nswitch($v) {\ncase 0:\nreturn 1;\ncase 1:\necho '1';\nbreak;\ncase 2:\nbreak;\ndefault:\n$result = 10;\n}return $result;\n}\n\n  public static function fOne($argA, $argB, $argC, $argD, $argE, $argF, $argG, $argH) {\n    $x = $argA + $argB + $argC + $argD + $argE + $argF + $argG + $argH;\n    list($field1, $field2, $field3, $filed4, $field5, $field6) = explode(\",\", $x);\n    fTwo($argA, $argB, $argC, fThree($argD, $argE, $argF, $argG, $argH));\n    $z = $argA == \"Some string\" ? \"yes\" : \"no\";\n    $colors = array(\"red\", \"green\", \"blue\", \"black\", \"white\", \"gray\");\n    $count = count($colors);\n    for ($i = 0; $i < $count; $i++)\t{\n      $colorString = $colors[$i];\n    }\n  }\n\n  function fTwo($strA, $strB, $strC, $strD) {\n    if ($strA == \"one\" || $strB == \"two\" || $strC == \"three\") {\n      return $strA + $strB + $strC;\n    }\n    $x = $foo->one(\"a\", \"b\")->two(\"c\", \"d\", \"e\")->three(\"fg\")->four();\n    $y = a()->b()->c();\n    return $strD;\n  }\n\n  function fThree($strA, $strB, $strC, $strD, $strE) {\n    try {\n}catch(Exception $e){\nfoo();\n}\nfinally {\n // do something\n}\n    return $strA + $strB + $strC + $strD + $strE;\n  }\n\n  protected abstract function fFour();\n\n}\n}";
    private static final String INDENT_SAMPLE = "<?php\nfunction foo() {\nif($x>5){\necho \"bar\";\n}\nreturn\n\"string\";\n}\n";

    @NotNull
    public Language getLanguage() {
        PhpLanguage phpLanguage = PhpLanguage.INSTANCE;
        if (phpLanguage == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return phpLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        switch (settingsType) {
            case SPACING_SETTINGS: {
                return SPACING_CODE_SAMPLE;
            }
            case BLANK_LINES_SETTINGS: {
                return BLANK_LINE_CODE_SAMPLE;
            }
            case WRAPPING_AND_BRACES_SETTINGS: {
                return WRAPPING_CODE_SAMPLE;
            }
            case INDENT_SETTINGS: {
                return INDENT_SAMPLE;
            }
        }
        return GENERAL_CODE_SAMPLE;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"SPACE_BEFORE_METHOD_CALL_PARENTHESES", "SPACE_BEFORE_METHOD_PARENTHESES", "SPACE_BEFORE_IF_PARENTHESES", "SPACE_BEFORE_WHILE_PARENTHESES", "SPACE_BEFORE_FOR_PARENTHESES", "SPACE_BEFORE_CATCH_PARENTHESES", "SPACE_BEFORE_SWITCH_PARENTHESES", "SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_AROUND_LOGICAL_OPERATORS", "SPACE_AROUND_EQUALITY_OPERATORS", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_AROUND_BITWISE_OPERATORS", "SPACE_AROUND_ADDITIVE_OPERATORS", "SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "SPACE_AROUND_SHIFT_OPERATORS", "SPACE_BEFORE_CLASS_LBRACE", "SPACE_BEFORE_METHOD_LBRACE", "SPACE_BEFORE_IF_LBRACE", "SPACE_BEFORE_ELSE_LBRACE", "SPACE_BEFORE_WHILE_LBRACE", "SPACE_BEFORE_FOR_LBRACE", "SPACE_BEFORE_DO_LBRACE", "SPACE_BEFORE_SWITCH_LBRACE", "SPACE_BEFORE_TRY_LBRACE", "SPACE_BEFORE_CATCH_LBRACE", "SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE", "SPACE_WITHIN_PARENTHESES", "SPACE_WITHIN_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_PARENTHESES", "SPACE_WITHIN_IF_PARENTHESES", "SPACE_WITHIN_WHILE_PARENTHESES", "SPACE_WITHIN_FOR_PARENTHESES", "SPACE_WITHIN_CATCH_PARENTHESES", "SPACE_WITHIN_SWITCH_PARENTHESES", "SPACE_BEFORE_QUEST", "SPACE_AFTER_QUEST", "SPACE_BEFORE_COLON", "SPACE_AFTER_COLON", "SPACE_WITHIN_BRACKETS", "SPACE_WITHIN_ARRAY_INITIALIZER_BRACES", "SPACE_AFTER_COMMA", "SPACE_BEFORE_COMMA", "SPACE_AFTER_SEMICOLON", "SPACE_BEFORE_SEMICOLON", "SPACE_AFTER_TYPE_CAST", "SPACE_AROUND_UNARY_OPERATOR", "SPACE_BEFORE_FINALLY_KEYWORD", "SPACE_BEFORE_FINALLY_LBRACE", "SPACE_BEFORE_ELSE_KEYWORD", "SPACE_BEFORE_WHILE_KEYWORD", "SPACE_BEFORE_CATCH_KEYWORD"});
            consumer.renameStandardOption("SPACE_AROUND_RELATIONAL_OPERATORS", "Relational operators (<, >, <=, >=, <=>)");
            consumer.showCustomOption(PhpCodeStyleSettings.class, "CONCAT_SPACES", "Concatenation (.)", CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACES_AROUND_ARROW", "Object access operator (->)", CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACES_AROUND_NULL_COALESCE_OPERATOR", "Null coalescing operator (??)", CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_AROUND_ASSIGNMENT_IN_DECLARE", "Assignment in declare statement", CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_BEFORE_COLON_IN_RETURN_TYPE", "Before colon in return type", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_AFTER_COLON_IN_RETURN_TYPE", "After colon in return type", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_CALL_PARENTHESES", "Function call parentheses");
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_PARENTHESES", "Function declaration parentheses");
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_CALL_PARENTHESES", "Function call parentheses");
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_PARENTHESES", "Function declaration parentheses");
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_LBRACE", "Function left brace");
            consumer.renameStandardOption("SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE", "Array initializer parentheses");
            consumer.renameStandardOption("SPACE_WITHIN_ARRAY_INITIALIZER_BRACES", "Array initializer parentheses");
            consumer.moveStandardOption("SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE", CodeStyleSettingsCustomizable.SPACES_BEFORE_PARENTHESES);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_BEFORE_UNARY_NOT", "Before unary Not (!)", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_AFTER_UNARY_NOT", "After unary Not (!)", CodeStyleSettingsCustomizable.SPACES_OTHER, new Object[0]);
            consumer.renameStandardOption("SPACE_AROUND_UNARY_OPERATOR", "Unary additive operators (+,-,++,--)");
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_BETWEEN_TERNARY_QUEST_AND_COLON", "Between '?' and ':'", CodeStyleSettingsCustomizable.SPACES_IN_TERNARY_OPERATOR, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACES_AROUND_VAR_WITHIN_BRACKETS", "Brackets around variable/expression", CodeStyleSettingsCustomizable.SPACES_WITHIN, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "SPACE_WITHIN_BRACKETS", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACES_WITHIN_SHORT_ECHO_TAGS", "<?= and ?>", CodeStyleSettingsCustomizable.SPACES_WITHIN, new Object[0]);
            consumer.renameStandardOption("SPACE_AROUND_SHIFT_OPERATORS", "Shift operators (<<,>>)");
            consumer.showCustomOption(PhpCodeStyleSettings.class, "SPACE_BEFORE_CLOSURE_LEFT_PARENTHESIS", "Anonymous function parentheses", CodeStyleSettingsCustomizable.SPACES_BEFORE_PARENTHESES, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "SPACE_BEFORE_METHOD_CALL_PARENTHESES", new Object[0]);
            consumer.renameStandardOption("SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "Multiplicative operators (*, /, %, **)");
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"BLANK_LINES_AROUND_CLASS", "BLANK_LINES_AROUND_FIELD", "BLANK_LINES_AROUND_METHOD", "BLANK_LINES_BEFORE_METHOD_BODY", "BLANK_LINES_AFTER_CLASS_HEADER", "KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_IN_CODE", "KEEP_BLANK_LINES_BEFORE_RBRACE", "BLANK_LINES_BEFORE_PACKAGE", "BLANK_LINES_AFTER_PACKAGE", "BLANK_LINES_BEFORE_IMPORTS", "BLANK_LINES_AFTER_IMPORTS"});
            consumer.renameStandardOption("BLANK_LINES_BEFORE_PACKAGE", "Before namespace:");
            consumer.renameStandardOption("BLANK_LINES_AFTER_PACKAGE", "After namespace:");
            consumer.renameStandardOption("BLANK_LINES_BEFORE_IMPORTS", "Before 'Use' statements:");
            consumer.renameStandardOption("BLANK_LINES_AFTER_IMPORTS", "After 'Use' statements:");
            consumer.showCustomOption(PhpCodeStyleSettings.class, "BLANK_LINES_AROUND_CONSTANTS", "Around class constants:", CodeStyleSettingsCustomizable.BLANK_LINES, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "BLANK_LINES_AFTER_OPENING_TAG", "After opening tag:", CodeStyleSettingsCustomizable.BLANK_LINES, CodeStyleSettingsCustomizable.OptionAnchor.BEFORE, "BLANK_LINES_BEFORE_PACKAGE", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "BLANK_LINES_AFTER_FUNCTION", "After function:", CodeStyleSettingsCustomizable.BLANK_LINES, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "BLANK_LINES_BEFORE_RETURN_STATEMENT", "Before return statement:", CodeStyleSettingsCustomizable.BLANK_LINES, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "BLANK_LINES_BEFORE_METHOD_BODY", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "KEEP_BLANK_LINES_AFTER_LBRACE", "After '{':", CodeStyleSettingsCustomizable.BLANK_LINES_KEEP, CodeStyleSettingsCustomizable.OptionAnchor.BEFORE, "KEEP_BLANK_LINES_BEFORE_RBRACE", new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING", "KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT", "KEEP_CONTROL_STATEMENT_IN_ONE_LINE", "BRACE_STYLE", "CLASS_BRACE_STYLE", "METHOD_BRACE_STYLE", "LAMBDA_BRACE_STYLE", "EXTENDS_LIST_WRAP", "EXTENDS_KEYWORD_WRAP", "CALL_PARAMETERS_WRAP", "CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_WRAP", "METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", "IF_BRACE_FORCE", "DOWHILE_BRACE_FORCE", "WHILE_BRACE_FORCE", "FOR_BRACE_FORCE", "ELSE_ON_NEW_LINE", "WHILE_ON_NEW_LINE", "CATCH_ON_NEW_LINE", "FINALLY_ON_NEW_LINE", "INDENT_CASE_FROM_SWITCH", "ALIGN_MULTILINE_PARAMETERS", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS", "ALIGN_MULTILINE_FOR", "ALIGN_MULTILINE_BINARY_OPERATION", "ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION", "ALIGN_MULTILINE_EXTENDS_LIST", "METHOD_CALL_CHAIN_WRAP", "ALIGN_MULTILINE_CHAINED_METHODS", "FOR_STATEMENT_WRAP", "FOR_STATEMENT_LPAREN_ON_NEXT_LINE", "FOR_STATEMENT_RPAREN_ON_NEXT_LINE", "BINARY_OPERATION_WRAP", "BINARY_OPERATION_SIGN_ON_NEXT_LINE", "TERNARY_OPERATION_WRAP", "TERNARY_OPERATION_SIGNS_ON_NEXT_LINE", "ARRAY_INITIALIZER_WRAP", "ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", "ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", "ASSIGNMENT_WRAP", "PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE", "PARENTHESES_EXPRESSION_LPAREN_WRAP", "PARENTHESES_EXPRESSION_RPAREN_WRAP", "ALIGN_MULTILINE_TERNARY_OPERATION", "MODIFIER_LIST_WRAP", "KEEP_SIMPLE_METHODS_IN_ONE_LINE", "SPECIAL_ELSE_IF_TREATMENT", "ALIGN_GROUP_FIELD_DECLARATIONS", "INDENT_BREAK_FROM_CASE"});
            consumer.renameStandardOption("ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", "New line after '('");
            consumer.renameStandardOption("ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", "Place ')' on new line");
            consumer.showCustomOption(PhpCodeStyleSettings.class, "IF_LPAREN_ON_NEXT_LINE", "New line after '('", CodeStyleSettingsCustomizable.WRAPPING_IF_STATEMENT, CodeStyleSettingsCustomizable.OptionAnchor.BEFORE, "IF_BRACE_FORCE", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "IF_RPAREN_ON_NEXT_LINE", "Place ')' on new line", CodeStyleSettingsCustomizable.WRAPPING_IF_STATEMENT, CodeStyleSettingsCustomizable.OptionAnchor.BEFORE, "IF_BRACE_FORCE", new Object[0]);
            consumer.renameStandardOption("METHOD_BRACE_STYLE", "In function declaration");
            consumer.renameStandardOption("LAMBDA_BRACE_STYLE", "In closure declaration");
            consumer.renameStandardOption("METHOD_PARAMETERS_WRAP", "Function declaration parameters");
            consumer.renameStandardOption("CALL_PARAMETERS_WRAP", "Function/constructor call arguments");
            consumer.showCustomOption(PhpCodeStyleSettings.class, "PLACE_PARENS_FOR_CONSTRUCTOR", "Place '()' for constructor", CodeStyleSettingsCustomizable.WRAPPING_METHOD_ARGUMENTS_WRAPPING, new Object[]{new String[]{"As is", "Always", "Never"}, new int[]{0, 1, 2}});
            consumer.renameStandardOption("FOR_STATEMENT_WRAP", "for()/foreach() statements");
            consumer.showCustomOption(PhpCodeStyleSettings.class, "KEEP_RPAREN_AND_LBRACE_ON_ONE_LINE", "Keep ')' and '{' on one line", CodeStyleSettingsCustomizable.WRAPPING_METHOD_PARAMETERS, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "ALIGN_ASSIGNMENTS", "Align consecutive assignments", CodeStyleSettingsCustomizable.WRAPPING_ASSIGNMENT, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "ALIGN_CLASS_CONSTANTS", "Align constants", CodeStyleSettingsCustomizable.WRAPPING_FIELDS_VARIABLES_GROUPS, new Object[0]);
            consumer.renameStandardOption("ALIGN_GROUP_FIELD_DECLARATIONS", "Align fields in columns");
            consumer.renameStandardOption(CodeStyleSettingsCustomizable.WRAPPING_FIELDS_VARIABLES_GROUPS, "Class field/constant groups");
            consumer.showCustomOption(PhpCodeStyleSettings.class, "MULTILINE_CHAINED_CALLS_SEMICOLON_ON_NEW_LINE", "Place ';' on new line", CodeStyleSettingsCustomizable.WRAPPING_CALL_CHAIN, new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "ALIGN_KEY_VALUE_PAIRS", "Align key-value pairs", CodeStyleSettingsCustomizable.WRAPPING_ARRAY_INITIALIZER, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "RETURN_TYPE_ON_NEW_LINE", "Return type on new line", "Function return type", new Object[0]);
            consumer.showCustomOption(PhpCodeStyleSettings.class, "NAMESPACE_BRACE_STYLE", "In namespace", CodeStyleSettingsCustomizable.WRAPPING_BRACES, CodeStyleSettingsCustomizable.OptionAnchor.BEFORE, "CLASS_BRACE_STYLE", new Object[]{new String[]{ApplicationBundle.message((String)"wrapping.brace.placement.end.of.line", (Object[])new Object[0]), ApplicationBundle.message((String)"wrapping.brace.placement.next.line", (Object[])new Object[0])}, new int[]{1, 2}});
            consumer.showCustomOption(PhpCodeStyleSettings.class, "GROUP_USE_WRAP", "Group use", null, new Object[]{CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS) {
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_AT_FIRST_COLUMN"});
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_ADD_SPACE"});
        }
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        if (indentOptions == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        commonSettings.CLASS_BRACE_STYLE = 2;
        commonSettings.METHOD_BRACE_STYLE = 2;
        commonSettings.SPECIAL_ELSE_IF_TREATMENT = false;
        commonSettings.SPACE_AFTER_TYPE_CAST = false;
        commonSettings.BLANK_LINES_BEFORE_PACKAGE = 1;
        commonSettings.BLANK_LINES_AFTER_PACKAGE = 0;
        commonSettings.BLANK_LINES_AROUND_FIELD = 0;
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new PhpSmartIndentOptionsEditor();
    }

    public int getRightMargin(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            PhpLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            return 40;
        }
        return super.getRightMargin(settingsType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/ui/PhpLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/ui/PhpLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRightMargin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CodeIgniterPredefinedCodeStyle
    extends PhpPredefinedCodeStyleBase {
        public CodeIgniterPredefinedCodeStyle() {
            super("CodeIgniter");
        }

        public CodeIgniterPredefinedCodeStyle(@NotNull String name) {
            if (name == null) {
                CodeIgniterPredefinedCodeStyle.$$$reportNull$$$0(0);
            }
            super(name);
        }

        @Override
        public void apply(CodeStyleSettings settings) {
            super.apply(settings);
            PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
            phpSettings.SPACE_BEFORE_UNARY_NOT = true;
            phpSettings.SPACE_AFTER_UNARY_NOT = true;
            phpSettings.UPPER_CASE_BOOLEAN_CONST = true;
            phpSettings.UPPER_CASE_NULL_CONST = true;
            phpSettings.VARIABLE_NAMING_STYLE = PhpNameStyle.Style.SNAKE_CASE;
            CommonCodeStyleSettings commonSettings = settings.getCommonSettings(this.getLanguage());
            commonSettings.BRACE_STYLE = 2;
            commonSettings.CLASS_BRACE_STYLE = 1;
            CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)PhpFileType.INSTANCE);
            indentOptions.USE_TAB_CHARACTER = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/php/lang/formatter/ui/PhpLanguageCodeStyleSettingsProvider$CodeIgniterPredefinedCodeStyle", "<init>"));
        }
    }

    public static class PSR1PSR2CodeStyle
    extends PhpPredefinedCodeStyleBase {
        public PSR1PSR2CodeStyle(@NotNull String name) {
            if (name == null) {
                PSR1PSR2CodeStyle.$$$reportNull$$$0(0);
            }
            super(name);
        }

        public PSR1PSR2CodeStyle() {
            super("PSR1/PSR2");
        }

        @Override
        public void apply(CodeStyleSettings settings) {
            super.apply(settings);
            CommonCodeStyleSettings commonSettings = settings.getCommonSettings(this.getLanguage());
            commonSettings.DOWHILE_BRACE_FORCE = 3;
            commonSettings.FOR_BRACE_FORCE = 3;
            commonSettings.IF_BRACE_FORCE = 3;
            commonSettings.WHILE_BRACE_FORCE = 3;
            commonSettings.CLASS_BRACE_STYLE = 2;
            commonSettings.METHOD_BRACE_STYLE = 2;
            commonSettings.BRACE_STYLE = 1;
            commonSettings.BLANK_LINES_AFTER_PACKAGE = 1;
            CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)PhpFileType.INSTANCE);
            indentOptions.INDENT_SIZE = 4;
            indentOptions.USE_TAB_CHARACTER = false;
            commonSettings.SPACE_BEFORE_IF_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_WHILE_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_FOR_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_TRY_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_CATCH_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_METHOD_PARENTHESES = false;
            commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_IF_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_WHILE_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_FOR_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_TRY_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_SWITCH_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_CATCH_PARENTHESES = false;
            commonSettings.SPACE_BEFORE_IF_LBRACE = true;
            commonSettings.SPACE_BEFORE_WHILE_LBRACE = true;
            commonSettings.SPACE_BEFORE_ELSE_LBRACE = true;
            commonSettings.SPACE_BEFORE_FOR_LBRACE = true;
            commonSettings.SPACE_BEFORE_DO_LBRACE = true;
            commonSettings.SPACE_BEFORE_SWITCH_LBRACE = true;
            commonSettings.ELSE_ON_NEW_LINE = false;
            commonSettings.SPACE_BEFORE_COMMA = false;
            commonSettings.METHOD_PARAMETERS_WRAP = 5;
            commonSettings.ALIGN_MULTILINE_PARAMETERS = false;
            commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = true;
            commonSettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE = true;
            commonSettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES = false;
            commonSettings.SPACE_AFTER_TYPE_CAST = false;
            commonSettings.SPACE_AROUND_UNARY_OPERATOR = false;
            commonSettings.SPACE_WITHIN_PARENTHESES = false;
            commonSettings.CALL_PARAMETERS_WRAP = 1;
            commonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = false;
            commonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
            commonSettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = false;
            commonSettings.SPACE_WITHIN_METHOD_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES = false;
            commonSettings.INDENT_CASE_FROM_SWITCH = true;
            commonSettings.WHILE_ON_NEW_LINE = false;
            commonSettings.CATCH_ON_NEW_LINE = false;
            commonSettings.ARRAY_INITIALIZER_WRAP = 5;
            commonSettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = true;
            commonSettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = true;
            PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
            phpSettings.UPPER_CASE_BOOLEAN_CONST = false;
            phpSettings.UPPER_CASE_NULL_CONST = false;
            phpSettings.LOWER_CASE_BOOLEAN_CONST = true;
            phpSettings.LOWER_CASE_NULL_CONST = true;
            phpSettings.KEEP_RPAREN_AND_LBRACE_ON_ONE_LINE = true;
            phpSettings.SPACE_BEFORE_CLOSURE_LEFT_PARENTHESIS = true;
            phpSettings.ELSE_IF_STYLE = PhpCodeStyleSettings.ElseIfStyle.COMBINE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/php/lang/formatter/ui/PhpLanguageCodeStyleSettingsProvider$PSR1PSR2CodeStyle", "<init>"));
        }
    }

    public static class SymfonyCodeStyle
    extends PSR1PSR2CodeStyle {
        public SymfonyCodeStyle() {
            super("Symfony2");
        }

        @Override
        public void apply(CodeStyleSettings settings) {
            super.apply(settings);
            CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)PhpLanguage.INSTANCE);
            commonSettings.SPACE_AFTER_COMMA = true;
            commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS = true;
            commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
            commonSettings.SPACE_AROUND_BITWISE_OPERATORS = true;
            commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = true;
            commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = true;
            commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
            commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = true;
            commonSettings.SPACE_AROUND_SHIFT_OPERATORS = true;
            commonSettings.SPACE_AROUND_UNARY_OPERATOR = false;
            commonSettings.CALL_PARAMETERS_WRAP = 5;
            commonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = true;
            commonSettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = true;
            PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
            phpSettings.CONCAT_SPACES = false;
            phpSettings.BLANK_LINES_BEFORE_RETURN_STATEMENT = 1;
            phpSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT = true;
            phpSettings.VARIABLE_NAMING_STYLE = PhpNameStyle.Style.CAMEL_CASE;
        }
    }

    public static class ZendCodeStyle
    extends PearCodeStyle {
        public ZendCodeStyle() {
            super("Zend");
        }

        @Override
        public void apply(CodeStyleSettings settings) {
            super.apply(settings);
            CommonCodeStyleSettings commonSettings = settings.getCommonSettings(this.getLanguage());
            commonSettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = true;
            commonSettings.EXTENDS_KEYWORD_WRAP = 1;
            commonSettings.ALIGN_MULTILINE_EXTENDS_LIST = true;
            commonSettings.INDENT_CASE_FROM_SWITCH = true;
            commonSettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = false;
            commonSettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = false;
            commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = false;
            PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
            phpSettings.ALIGN_KEY_VALUE_PAIRS = true;
            phpSettings.KEEP_RPAREN_AND_LBRACE_ON_ONE_LINE = true;
            phpSettings.VARIABLE_NAMING_STYLE = PhpNameStyle.Style.CAMEL_CASE;
        }
    }

    public static class PearCodeStyle
    extends PhpPredefinedCodeStyleBase {
        public PearCodeStyle() {
            super("PEAR");
        }

        protected PearCodeStyle(String name) {
            super(name);
        }

        @Override
        public void apply(CodeStyleSettings settings) {
            super.apply(settings);
            CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)PhpFileType.INSTANCE);
            indentOptions.INDENT_SIZE = 4;
            indentOptions.CONTINUATION_INDENT_SIZE = 4;
            indentOptions.USE_TAB_CHARACTER = false;
            indentOptions.TAB_SIZE = 4;
            PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
            phpSettings.INDENT_CODE_IN_PHP_TAGS = false;
            phpSettings.ALIGN_PHPDOC_PARAM_NAMES = true;
            phpSettings.ALIGN_PHPDOC_COMMENTS = true;
            phpSettings.PHPDOC_BLANK_LINE_BEFORE_TAGS = true;
            phpSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS = true;
            phpSettings.LOWER_CASE_BOOLEAN_CONST = true;
            phpSettings.UPPER_CASE_BOOLEAN_CONST = false;
            phpSettings.LOWER_CASE_NULL_CONST = true;
            phpSettings.UPPER_CASE_NULL_CONST = false;
            phpSettings.IF_LPAREN_ON_NEXT_LINE = false;
            phpSettings.IF_RPAREN_ON_NEXT_LINE = true;
            CommonCodeStyleSettings commonSettings = settings.getCommonSettings(this.getLanguage());
            commonSettings.RIGHT_MARGIN = 80;
            commonSettings.BRACE_STYLE = 1;
            commonSettings.CLASS_BRACE_STYLE = 2;
            commonSettings.METHOD_BRACE_STYLE = 2;
            commonSettings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS = false;
            commonSettings.ELSE_ON_NEW_LINE = false;
            commonSettings.WHILE_ON_NEW_LINE = false;
            commonSettings.CATCH_ON_NEW_LINE = false;
            commonSettings.INDENT_CASE_FROM_SWITCH = false;
            commonSettings.ALIGN_MULTILINE_CHAINED_METHODS = false;
            commonSettings.ALIGN_MULTILINE_PARAMETERS = false;
            commonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = false;
            commonSettings.ALIGN_MULTILINE_FOR = false;
            commonSettings.ALIGN_MULTILINE_BINARY_OPERATION = false;
            commonSettings.ALIGN_MULTILINE_ASSIGNMENT = false;
            commonSettings.ALIGN_MULTILINE_TERNARY_OPERATION = false;
            commonSettings.ALIGN_MULTILINE_THROWS_LIST = false;
            commonSettings.ALIGN_THROWS_KEYWORD = false;
            commonSettings.ALIGN_MULTILINE_EXTENDS_LIST = false;
            commonSettings.ALIGN_MULTILINE_METHOD_BRACKETS = false;
            commonSettings.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION = false;
            commonSettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = false;
            commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
            commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = true;
            commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = true;
            commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = true;
            commonSettings.SPACE_AROUND_BITWISE_OPERATORS = true;
            commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS = true;
            commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
            commonSettings.SPACE_AROUND_SHIFT_OPERATORS = true;
            commonSettings.SPACE_AROUND_UNARY_OPERATOR = false;
            commonSettings.SPACE_AFTER_COMMA = true;
            commonSettings.SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS = true;
            commonSettings.SPACE_BEFORE_COMMA = false;
            commonSettings.SPACE_AFTER_SEMICOLON = true;
            commonSettings.SPACE_BEFORE_SEMICOLON = false;
            commonSettings.SPACE_WITHIN_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_METHOD_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_IF_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_WHILE_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_FOR_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_TRY_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_CATCH_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_SWITCH_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_CAST_PARENTHESES = false;
            commonSettings.SPACE_WITHIN_BRACKETS = false;
            commonSettings.SPACE_WITHIN_BRACES = false;
            commonSettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES = false;
            commonSettings.SPACE_AFTER_TYPE_CAST = false;
            commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
            commonSettings.SPACE_BEFORE_METHOD_PARENTHESES = false;
            commonSettings.SPACE_BEFORE_IF_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_WHILE_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_FOR_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_TRY_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_CATCH_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES = true;
            commonSettings.SPACE_BEFORE_CLASS_LBRACE = true;
            commonSettings.SPACE_BEFORE_METHOD_LBRACE = true;
            commonSettings.SPACE_BEFORE_IF_LBRACE = true;
            commonSettings.SPACE_BEFORE_ELSE_LBRACE = true;
            commonSettings.SPACE_BEFORE_WHILE_LBRACE = true;
            commonSettings.SPACE_BEFORE_FOR_LBRACE = true;
            commonSettings.SPACE_BEFORE_DO_LBRACE = true;
            commonSettings.SPACE_BEFORE_SWITCH_LBRACE = true;
            commonSettings.SPACE_BEFORE_TRY_LBRACE = true;
            commonSettings.SPACE_BEFORE_CATCH_LBRACE = true;
            commonSettings.SPACE_BEFORE_FINALLY_LBRACE = true;
            commonSettings.SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE = false;
            commonSettings.SPACE_BEFORE_ELSE_KEYWORD = true;
            commonSettings.SPACE_BEFORE_WHILE_KEYWORD = true;
            commonSettings.SPACE_BEFORE_CATCH_KEYWORD = true;
            commonSettings.SPACE_BEFORE_FINALLY_KEYWORD = true;
            commonSettings.SPACE_BEFORE_QUEST = true;
            commonSettings.SPACE_AFTER_QUEST = true;
            commonSettings.SPACE_BEFORE_COLON = true;
            commonSettings.SPACE_AFTER_COLON = true;
            commonSettings.SPACE_BEFORE_TYPE_PARAMETER_LIST = false;
            commonSettings.CALL_PARAMETERS_WRAP = 1;
            commonSettings.PREFER_PARAMETERS_WRAP = true;
            commonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = true;
            commonSettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = true;
            commonSettings.METHOD_PARAMETERS_WRAP = 1;
            commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE = true;
            commonSettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE = true;
            commonSettings.EXTENDS_LIST_WRAP = 1;
            commonSettings.THROWS_LIST_WRAP = 1;
            commonSettings.EXTENDS_KEYWORD_WRAP = 0;
            commonSettings.THROWS_KEYWORD_WRAP = 0;
            commonSettings.METHOD_CALL_CHAIN_WRAP = 1;
            commonSettings.PARENTHESES_EXPRESSION_LPAREN_WRAP = false;
            commonSettings.PARENTHESES_EXPRESSION_RPAREN_WRAP = false;
            commonSettings.BINARY_OPERATION_WRAP = 1;
            commonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE = true;
            commonSettings.TERNARY_OPERATION_WRAP = 1;
            commonSettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE = true;
            commonSettings.MODIFIER_LIST_WRAP = false;
            commonSettings.FOR_STATEMENT_WRAP = 1;
            commonSettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE = true;
            commonSettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE = true;
            commonSettings.ARRAY_INITIALIZER_WRAP = 1;
            commonSettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = true;
            commonSettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = true;
            commonSettings.ASSIGNMENT_WRAP = 1;
            commonSettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE = true;
            commonSettings.WRAP_COMMENTS = true;
            commonSettings.WRAP_LONG_LINES = false;
            commonSettings.IF_BRACE_FORCE = 3;
            commonSettings.WHILE_BRACE_FORCE = 3;
            commonSettings.FOR_BRACE_FORCE = 3;
            commonSettings.DOWHILE_BRACE_FORCE = 3;
        }
    }
}

